/*
 * Decompiled with CFR 0.152.
 */
package uibk.mtk.math;

import uibk.mtk.lang.ComputationException;
import uibk.mtk.math.Messages;
import uibk.mtk.math.functions.Function1D;

public class NewtonMethod {
    double x;
    Function1D function;
    int type;
    public static final int TYPE_STANDARD = 0;
    public static final int TYPE_SIMPLE = 1;
    double x0;
    double dx;
    double defect;

    public NewtonMethod(Function1D function) {
        this.setFunction(function);
    }

    public void setFunction(Function1D function) {
        this.function = function;
    }

    public NewtonMethod() {
    }

    public double getX() {
        return this.x;
    }

    public double getIncrement() {
        return Math.abs(this.dx);
    }

    public double getDefect() {
        return Math.abs(this.defect);
    }

    public void setX0(double x) {
        this.x = x;
    }

    public void setJacobiPostion(double x0) {
        this.x0 = x0;
    }

    public double nextApproximation() throws ComputationException {
        double deriv;
        if (this.function == null) {
            throw new ComputationException(Messages.getString("NewtonMethod.0"));
        }
        try {
            double tempx = this.type == 1 ? this.x0 : this.x;
            deriv = this.function.getDerivation(tempx);
        }
        catch (Exception ex) {
            throw new ComputationException(ex.getMessage());
        }
        if (deriv == 0.0) {
            throw new ComputationException("f'(" + this.x + Messages.getString("NewtonMethod.2"));
        }
        if (Double.isNaN(deriv) || Double.isInfinite(deriv)) {
            throw new ComputationException(Messages.getString("NewtonMethod.3"));
        }
        this.defect = this.function.getValue(this.x);
        this.dx = -this.defect / deriv;
        this.x += this.dx;
        if (Double.isNaN(this.x) || Double.isInfinite(this.x)) {
            throw new ComputationException(Messages.getString("NewtonMethod.4"));
        }
        return this.x;
    }

    public void setType(int type) {
        if (type != 0 && type != 1) {
            throw new IllegalArgumentException(Messages.getString("NewtonMethod.5"));
        }
        this.type = type;
    }

    public int getType() {
        return this.type;
    }

    public double getError() {
        return Math.abs(this.dx);
    }
}

