/*
 * Decompiled with CFR 0.152.
 */
package uibk.applets.newton;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import uibk.applets.newton.AppletNewton;
import uibk.applets.newton.Messages;
import uibk.mtk.math.parsing.Misc;
import uibk.mtk.swing.base.TitledPanel;

public class PanelNewton
extends TitledPanel
implements ActionListener {
    AppletNewton main;
    JButton buttonNext;
    JButton buttonZoom;
    JTextField texteps;
    JLabel labeleps;
    JRadioButton optSimpleNewton;
    JRadioButton optStandardNewton;

    public PanelNewton(AppletNewton main) {
        super(Messages.getString("PanelNewton.0"));
        this.main = main;
        this.initComponents();
    }

    private void zoom() {
        try {
            this.main.newtonvisual.zoom();
        }
        catch (Exception e) {
            this.main.mathpanel2d.reportError(e.getMessage());
        }
        this.main.mathpanel2d.repaint();
    }

    private void next() {
        double eps = 0.0;
        try {
            eps = Misc.parseEps(this.texteps.getText(), 1.0E-12);
        }
        catch (Exception ex) {
            this.main.mathpanel2d.reportError(ex);
            return;
        }
        this.main.newtonvisual.setEps(eps);
        int type = this.optSimpleNewton.isSelected() ? 1 : 0;
        this.main.newtonvisual.getNewtonMethod().setType(type);
        if (!this.main.newtonvisual.hasNext()) {
            return;
        }
        try {
            this.main.newtonvisual.next();
        }
        catch (Exception e) {
            this.main.mathpanel2d.reportError(e);
            return;
        }
        this.buttonZoom.setEnabled(true);
        this.main.table.scrollToLastLine();
        if (this.main.newtonvisual.getState() == 0) {
            this.main.table.add(this.main.newtonvisual.getLast());
            this.main.table.revalidate();
        }
        this.main.mathpanel2d.repaint();
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        if (ev.getActionCommand().equals("zoom")) {
            this.zoom();
        }
        if (ev.getActionCommand().equals("next")) {
            this.next();
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.buttonNext.setEnabled(enabled);
        this.texteps.setEnabled(enabled);
        this.labeleps.setEnabled(enabled);
        this.buttonZoom.setEnabled(false);
        this.optSimpleNewton.setEnabled(enabled);
        this.optStandardNewton.setEnabled(enabled);
    }

    void initComponents() {
        this.setLayout(new GridBagLayout());
        this.setMaximumSize(new Dimension(2000, 170));
        this.texteps = new JTextField(8);
        this.texteps.setActionCommand("eps");
        this.texteps.addActionListener(this);
        this.texteps.setToolTipText(Messages.getString("PanelNewton.4"));
        this.labeleps = new JLabel(Messages.getString("PanelNewton.5"));
        this.buttonNext = new JButton(Messages.getString("PanelNewton.6"));
        this.buttonNext.setActionCommand("next");
        this.buttonNext.addActionListener(this);
        this.buttonNext.setToolTipText(Messages.getString("PanelNewton.8"));
        this.buttonZoom = new JButton(Messages.getString("PanelNewton.9"));
        this.buttonZoom.setActionCommand("zoom");
        this.buttonZoom.addActionListener(this);
        this.buttonZoom.setToolTipText(Messages.getString("PanelNewton.11"));
        this.optSimpleNewton = new JRadioButton(Messages.getString("PanelNewton.12"), false);
        this.optStandardNewton = new JRadioButton(Messages.getString("PanelNewton.13"), true);
        this.optStandardNewton.setToolTipText(Messages.getString("PanelNewton.14"));
        this.optStandardNewton.setToolTipText(Messages.getString("PanelNewton.15"));
        ButtonGroup groupMethods = new ButtonGroup();
        groupMethods.add(this.optSimpleNewton);
        groupMethods.add(this.optStandardNewton);
        this.add((Component)this.optStandardNewton, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.optSimpleNewton, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 10, 0), 0, 0));
        this.add((Component)this.labeleps, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.texteps, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 10, 0, 0), 0, 0));
        this.add((Component)this.buttonZoom, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(30, 0, 0, 10), 0, 0));
        this.add((Component)this.buttonNext, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(30, 30, 0, 0), 0, 0));
    }
}

