/*
 * Decompiled with CFR 0.152.
 */
package uibk.applets.newton;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.Vector;
import uibk.applets.newton.Messages;
import uibk.mtk.draw2d.base.Drawable2D;
import uibk.mtk.draw2d.base.MathPanel2D;
import uibk.mtk.draw2d.objects.FunctionValue2D;
import uibk.mtk.draw2d.objects.Graph2D;
import uibk.mtk.draw2d.objects.MathLine2D;
import uibk.mtk.draw2d.util.GraphUtil;
import uibk.mtk.geom.CoordinateRect2D;
import uibk.mtk.lang.ComputationException;
import uibk.mtk.lang.InputException;
import uibk.mtk.math.Interval;
import uibk.mtk.math.NewtonMethod;
import uibk.mtk.math.functions.Function1D;

public class NewtonVisualisation
extends Drawable2D {
    Interval interval;
    protected Function1D function;
    protected NewtonMethod newton = new NewtonMethod();
    protected NewtonMethod newtonzoom = new NewtonMethod();
    protected Graph2D graph = new Graph2D();
    protected Vector lines = new Vector();
    private double eps;
    private int count;
    private static final Color TANGENTCOLOR = Color.green;
    private static final Color LINECOLOR = Color.blue;
    private static final int NUMPOINTSGRAPH = 500;
    double[] last = new double[4];
    static final int STATE_NEW_APPROX = 0;
    static final int STATE_NO_NEW_APPROX = 1;
    FunctionValue2D initial = new FunctionValue2D(){

        @Override
        public void drag(MouseEvent ev) {
            super.drag(ev);
            this.panel.report(String.valueOf(Messages.getString("NewtonVisualisation.0")) + this.getPos());
        }
    };

    public NewtonVisualisation(Function1D function) {
        this();
        this.setFunction(function);
    }

    public NewtonVisualisation() {
        this.initial.setColor(LINECOLOR);
        this.draw = false;
    }

    public void setEps(double eps) {
        this.eps = eps;
    }

    @Override
    public void draw(BufferedImage framebuffer, Graphics2D g2) {
        if (!this.draw) {
            return;
        }
        this.graph.draw(framebuffer, g2);
        int i = 0;
        while (i < this.lines.size()) {
            MathLine2D tangent = (MathLine2D)this.lines.elementAt(i);
            tangent.draw(framebuffer, g2);
            ++i;
        }
    }

    public void setInterval(Interval interval) {
        this.interval = interval;
    }

    public void initialize() throws Exception {
        if (this.function == null) {
            throw new InputException(Messages.getString("NewtonVisualisation.1"));
        }
        if (this.interval == null) {
            throw new InputException(Messages.getString("NewtonVisualisation.2"));
        }
        this.draw = false;
        this.initial.setVisible(false);
        this.graph.setPoints(GraphUtil.compute(this.function, this.interval.a, this.interval.b, 500));
        this.scene2d.setLimits(this.graph.getLimits());
        this.scene2d.ensureZeroY(true);
        this.panel.add(this.initial);
        this.initial.setFunction(this.function);
        this.initial.setPos(this.graph.getLimits().xmax);
        this.newton.setType(0);
        this.draw = true;
        this.initial.setVisible(true);
    }

    public void setFunction(Function1D f) {
        this.function = f;
        this.newton.setFunction(f);
        this.newtonzoom.setFunction(f);
    }

    @Override
    public void setMathPanel2D(MathPanel2D panel) {
        super.setMathPanel2D(panel);
        this.graph.setMathPanel2D(panel);
    }

    public double[] getLast() {
        return (double[])this.last.clone();
    }

    public boolean hasNext() {
        return this.count <= 0 || !(this.newton.getIncrement() < this.eps);
    }

    public void next() throws Exception {
        this.initial.enabledrag(false);
        if (this.count > 0 && this.newton.getIncrement() < this.eps) {
            this.panel.reportSuccess(String.valueOf(Messages.getString("NewtonVisualisation.3")) + this.initial.getPos());
            return;
        }
        if (this.count == 0) {
            if (this.function.getValue(this.initial.getPos()) == 0.0) {
                this.initial.enabledrag(true);
                throw new Exception(String.valueOf(Messages.getString("NewtonVisualisation.4")) + this.initial.getPos() + Messages.getString("NewtonVisualisation.5"));
            }
            this.newton.setX0(this.initial.getPos());
            this.newton.setJacobiPostion(this.initial.getPos());
        }
        if (this.count % 2 == 0) {
            double x1 = this.newton.getX();
            double y1 = this.function.getValue(this.newton.getX());
            double x2 = this.newton.nextApproximation();
            double y2 = 0.0;
            if (Double.isNaN(x1) || Double.isNaN(y1) || Double.isNaN(x2) || Double.isInfinite(x1) || Double.isInfinite(y1) || Double.isInfinite(x2)) {
                throw new ComputationException(Messages.getString("NewtonVisualisation.6"));
            }
            this.panel.report(String.valueOf(Messages.getString("NewtonVisualisation.7")) + x2);
            MathLine2D line = new MathLine2D();
            line.setPoints(x1, y1, x2, y2);
            line.setMathPanel2D(this.panel);
            line.setColor(TANGENTCOLOR);
            this.lines.add(line);
            this.last[0] = x2;
            this.last[1] = this.newton.getDefect();
            this.last[2] = this.newton.getIncrement();
            this.last[3] = this.newton.getError();
            if (x2 < this.panel.getScene2d().getXmin() || x2 > this.panel.getScene2d().getXmax()) {
                double b;
                double a;
                if (x2 < this.panel.getScene2d().getXmin()) {
                    a = x2;
                    b = this.panel.getScene2d().getXmax();
                } else {
                    a = this.panel.getScene2d().getXmin();
                    b = x2;
                }
                CoordinateRect2D rect = new CoordinateRect2D(a, b, -1.0, 1.0);
                rect.roundCoords(20.0, 1);
                this.graph.setPoints(GraphUtil.compute(this.function, rect.xmin, rect.xmax, 500));
                this.panel.getScene2d().setLimits(this.graph.getLimits());
            }
            ++this.count;
        } else {
            MathLine2D line = new MathLine2D();
            double x1 = this.newton.getX();
            double y1 = 0.0;
            double x2 = this.newton.getX();
            double y2 = this.function.getValue(x1);
            if (Double.isNaN(x1) || Double.isNaN(y1) || Double.isNaN(x2) || Double.isInfinite(x1) || Double.isInfinite(y1) || Double.isInfinite(x2)) {
                throw new ComputationException(Messages.getString("NewtonVisualisation.8"));
            }
            line.setPoints(x1, y1, x2, y2);
            line.setMathPanel2D(this.panel);
            line.setColor(LINECOLOR);
            this.lines.add(line);
            ++this.count;
        }
        if (this.count > 0 && this.newton.getIncrement() < this.eps) {
            this.panel.reportSuccess(String.valueOf(Messages.getString("NewtonVisualisation.9")) + this.newton.getX());
            return;
        }
    }

    public int getState() {
        if (this.count % 2 == 1) {
            return 0;
        }
        return 1;
    }

    public void zoom() throws Exception {
        double u;
        double x = this.newton.getX();
        this.newtonzoom.setX0(x);
        double xnext = 0.0;
        try {
            xnext = this.newtonzoom.nextApproximation();
        }
        catch (Exception ex) {
            throw new ComputationException(Messages.getString("NewtonVisualisation.10"));
        }
        if (Double.isInfinite(xnext) || Double.isNaN(x)) {
            throw new ComputationException(Messages.getString("NewtonVisualisation.11"));
        }
        double l = x < xnext ? x : xnext;
        Interval intervalx = new Interval(l, u = x < xnext ? xnext : x);
        if (!intervalx.isRealInterval() || intervalx.getLength() < 1.0E-10) {
            throw new ComputationException(Messages.getString("NewtonVisualisation.12"));
        }
        this.initial.setVisible(false);
        this.lines.clear();
        MathLine2D line = new MathLine2D();
        double x1 = x;
        double y1 = 0.0;
        double x2 = x;
        double y2 = this.function.getValue(x1);
        line.setPoints(x1, y1, x2, y2);
        line.setMathPanel2D(this.panel);
        line.setColor(LINECOLOR);
        this.lines.add(line);
        this.count = 2;
        this.scene2d.enableRoundY(false);
        this.scene2d.setXInterval(intervalx);
        this.scene2d.enableRoundY(true);
        Vector points = null;
        try {
            points = GraphUtil.compute(this.function, this.scene2d.getXmin(), this.scene2d.getXmax(), 500);
        }
        catch (Exception ex) {
            throw new ComputationException(Messages.getString("NewtonVisualisation.13"));
        }
        this.graph.setPoints(points);
        Interval intervaly = new Interval(this.graph.getLimits().ymin, this.graph.getLimits().ymax);
        if (!intervaly.isRealInterval()) {
            throw new ComputationException(Messages.getString("NewtonVisualisation.14"));
        }
        this.scene2d.setYInterval(intervaly);
    }

    public NewtonMethod getNewtonMethod() {
        return this.newton;
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.initial.setVisible(visible);
    }

    public void reset() {
        this.count = 0;
        this.lines.clear();
        this.initial.enabledrag(true);
        this.initial.setVisible(true);
    }
}

