/*
 * Decompiled with CFR 0.152.
 */
package uibk.mtk.math.numberPanel;

import uibk.mtk.exception.ExceptionLevel;
import uibk.mtk.exception.ExtendedException;
import uibk.mtk.lang.Messages;
import uibk.mtk.math.numberPanel.MatrixException;
import uibk.mtk.math.numberPanel.MatrixPanel;
import uibk.mtk.math.numberPanel.MatrixUtil;
import uibk.mtk.math.numberPanel.MyNumber;

public class MatrixPanelLU
extends MatrixPanel {
    private MatrixPanel L = null;
    private MatrixPanel permutS = null;
    private MatrixPanel permutZ = null;
    private int solveIndexColumn = -1;

    public MatrixPanelLU(MyNumber[][] data) throws ExtendedException {
        super(data);
    }

    public MatrixPanelLU(int rowDimension, int columnDimension) throws ExtendedException {
        super(rowDimension, columnDimension);
    }

    protected void intAlgorithm() throws ExtendedException {
        super.intAlgorithm();
        this.solveIndexColumn = -1;
    }

    public void setValueAt(int row, int column, MyNumber r) throws ExtendedException {
        super.setValueAt(row, column, r);
        this.setMatrixToIdentity(this.permutS);
        this.setMatrixToIdentity(this.permutZ);
        this.setMatrixToIdentity(this.L);
    }

    public void gaussStep(boolean columnPivot) throws ExtendedException {
        if (!this.haveLigalPivot(columnPivot)) {
            return;
        }
        int[] index = this.indexMaxValueAbs(this.indexPivot, this.indexPivot, columnPivot);
        if (this.data[index[0]][index[1]].getDoubleValue() == 0.0) {
            throw new MatrixException(Messages.getString("uibk.mtk.math.numberPanel.messages", "RationalMatrix.7"), ExceptionLevel.INFO);
        }
        this.gaussStep(index[0], index[1], columnPivot);
    }

    public void gaussStep(int row, int column, boolean columnPivot) throws ExtendedException {
        this.isPivotLegal(row, column, columnPivot);
        if (this.data[row][column].getDoubleValue() == 0.0) {
            throw new MatrixException(Messages.getString("uibk.mtk.math.numberPanel.messages", "RationalMatrix.3"), ExceptionLevel.INFO);
        }
        this.changeRowsIntern(this.indexPivot, row);
        this.changeColumnsIntern(this.indexPivot, column);
        MyNumber pivot = this.data[this.indexPivot][this.indexPivot];
        int i = this.indexPivot + 1;
        while (i < this.rowDim) {
            MyNumber r = this.data[i][this.indexPivot].div(pivot);
            this.subIntern(this.indexPivot, i, r);
            ++i;
        }
        ++this.indexPivot;
    }

    public MatrixPanel gaussAlgorithmus(boolean columnPivot) throws ExtendedException {
        while (this.haveLigalPivot(columnPivot)) {
            int[] index = this.indexMaxValueAbs(this.indexPivot, this.indexPivot, columnPivot);
            if (this.data[index[0]][index[1]].getDoubleValue() == 0.0) break;
            this.gaussStep(columnPivot);
        }
        return this;
    }

    protected void changeRowsIntern(int row1, int row2) throws ExtendedException {
        MyNumber tmp;
        this.permutZ = this.getPermuttationZeilen();
        super.changeRowsIntern(row1, row2);
        int i = 0;
        while (i < this.permutZ.columnDim) {
            tmp = this.permutZ.data[i][row1];
            this.permutZ.setValueAtIntern(i, row1, this.permutZ.data[i][row2]);
            this.permutZ.setValueAtIntern(i, row2, tmp);
            ++i;
        }
        if (this.L != null) {
            i = 0;
            while (i < this.indexPivot) {
                tmp = this.L.data[row1][i];
                this.L.setValueAtIntern(row1, i, this.L.data[row2][i]);
                this.L.setValueAtIntern(row2, i, tmp);
                ++i;
            }
        }
    }

    protected void changeColumnsIntern(int col1, int col2) throws ExtendedException {
        this.permutS = this.getPermuttationSpalten();
        super.changeColumnsIntern(col1, col2);
        int i = 0;
        while (i < this.permutS.rowDim) {
            MyNumber tmp = this.permutS.data[col1][i];
            this.permutS.setValueAtIntern(col1, i, this.permutS.data[col2][i]);
            this.permutS.setValueAtIntern(col2, i, tmp);
            ++i;
        }
    }

    public MatrixPanel subIntern(int row1, int row2, MyNumber t) throws ExtendedException {
        this.L = this.getL();
        super.subIntern(row1, row2, t);
        int i = row1;
        while (i < this.L.columnDim) {
            this.L.setValueAtIntern(row2, i, this.L.data[row2][i].add(t.mul(this.L.data[row1][i])));
            ++i;
        }
        return this;
    }

    public MatrixPanel solveStep(boolean permutX) throws ExtendedException {
        if (this.isSolved) {
            return this.x;
        }
        MyNumber sum = MyNumber.getNumber(this.x.getVauleAt(0, 0).getClass(), 0.0, 1, this.view, this, this.precision);
        int j = this.columnDim - 1;
        while (j > this.solveIndexColumn) {
            sum = sum.add(this.getVauleAt(this.solveIndexColumn, j).mul(this.x.getVauleAt(j, this.solveIndexColumn)));
            --j;
        }
        this.x.setValueAt(this.solveIndexColumn, this.solveIndexColumn, this.b.getVauleAt(this.solveIndexColumn, this.solveIndexColumn).sub(sum).div(this.getVauleAt(this.solveIndexColumn, this.solveIndexColumn)));
        if (this.solveIndexColumn == 0) {
            this.solveIndexColumn = this.rowDim - 1 - this.nullRows;
            ++this.solveIndexColumn;
        } else {
            --this.solveIndexColumn;
        }
        if (this.solveIndexColumn == this.b.columnDim) {
            if (permutX) {
                this.x = MatrixUtil.mul(MatrixUtil.transpose(this.permutS), this.x);
            }
            this.isSolved = true;
        }
        return this.x;
    }

    public MatrixPanel getPermuttationSpalten() throws ExtendedException {
        if (this.permutS == null) {
            this.permutS = MatrixUtil.getIdentityMatrix(this.columnDim, this.columnDim, this.view, this, this.precision, this.getVauleAt(0, 0).getClass());
        }
        return this.permutS;
    }

    public MatrixPanel getPermuttationZeilen() throws ExtendedException {
        if (this.permutZ == null) {
            this.permutZ = MatrixUtil.getIdentityMatrix(this.rowDim, this.rowDim, this.view, this, this.precision, this.getVauleAt(0, 0).getClass());
        }
        return this.permutZ;
    }

    public MatrixPanel getL() throws ExtendedException {
        if (this.L == null) {
            this.L = MatrixUtil.getIdentityMatrix(this.rowDim, this.rowDim, this.view, this, this.precision, this.getVauleAt(0, 0).getClass());
        }
        return this.L;
    }

    public void initSolve(MatrixPanel x, MatrixPanel b) throws ExtendedException {
        if (this.solveIndexColumn != -1) {
            return;
        }
        if (this.getRowDim() != b.getRowDim()) {
            throw new MatrixException(Messages.getString("uibk.mtk.math.numberPanel.messages", "RationalMatrix.4"), ExceptionLevel.ERROR);
        }
        MatrixPanel T = MatrixUtil.transpose(this.getPermuttationZeilen().clone());
        MatrixPanel Tb = MatrixUtil.mul(T, b);
        this.b = MatrixUtil.forwordInsert(this.getL(), Tb);
        int min = this.columnDim < this.rowDim ? this.columnDim : this.rowDim;
        int i = 0;
        while (i < min) {
            if (this.getVauleAt(i, i).getDoubleValue() == 0.0) break;
            ++i;
        }
        int rank = i;
        this.nullRows = MatrixUtil.isSolveAble(this, this.b, this.columnDim - rank);
        this.x = x != null ? x : this.initXMatrix(this.b);
        this.solveIndexColumn = this.rowDim - 1 - this.nullRows;
        if (this.solveIndexColumn < 0) {
            this.isSolved = true;
        }
    }

    public MatrixPanelLU clone() {
        try {
            int j;
            MyNumber[][] data = new MyNumber[this.rowDim][this.columnDim];
            int i = 0;
            while (i < this.rowDim) {
                int j2 = 0;
                while (j2 < this.columnDim) {
                    data[i][j2] = this.getVauleAt(i, j2).clone();
                    ++j2;
                }
                ++i;
            }
            MatrixPanelLU r = new MatrixPanelLU(data);
            r.indexPivot = this.indexPivot;
            if (this.L != null) {
                data = new MyNumber[this.L.rowDim][this.L.columnDim];
                int i2 = 0;
                while (i2 < this.L.rowDim) {
                    j = 0;
                    while (j < this.L.columnDim) {
                        data[i2][j] = this.L.getVauleAt(i2, j).clone();
                        ++j;
                    }
                    ++i2;
                }
                MatrixPanelLU p = new MatrixPanelLU(data);
                r.L = p;
            }
            if (this.permutS != null) {
                data = new MyNumber[this.permutS.rowDim][this.permutS.columnDim];
                int i3 = 0;
                while (i3 < this.permutS.rowDim) {
                    j = 0;
                    while (j < this.permutS.columnDim) {
                        data[i3][j] = this.permutS.getVauleAt(i3, j).clone();
                        ++j;
                    }
                    ++i3;
                }
                MatrixPanelLU p = new MatrixPanelLU(data);
                r.permutS = p;
            }
            if (this.permutZ != null) {
                data = new MyNumber[this.permutZ.rowDim][this.permutZ.columnDim];
                int i4 = 0;
                while (i4 < this.permutZ.rowDim) {
                    j = 0;
                    while (j < this.permutZ.columnDim) {
                        data[i4][j] = this.permutZ.getVauleAt(i4, j).clone();
                        ++j;
                    }
                    ++i4;
                }
                MatrixPanelLU p = new MatrixPanelLU(data);
                r.permutZ = p;
            }
            if (this.b != null) {
                data = new MyNumber[this.b.rowDim][this.b.columnDim];
                int i5 = 0;
                while (i5 < this.b.rowDim) {
                    j = 0;
                    while (j < this.b.columnDim) {
                        data[i5][j] = this.b.getVauleAt(i5, j).clone();
                        ++j;
                    }
                    ++i5;
                }
                MatrixPanelLU bneu = new MatrixPanelLU(data);
                r.b = bneu;
            }
            if (this.x != null) {
                data = new MyNumber[this.x.rowDim][this.x.columnDim];
                int i6 = 0;
                while (i6 < this.x.rowDim) {
                    j = 0;
                    while (j < this.x.columnDim) {
                        data[i6][j] = this.x.getVauleAt(i6, j).clone();
                        ++j;
                    }
                    ++i6;
                }
                MatrixPanelLU xNeu = new MatrixPanelLU(data);
                r.x = xNeu;
            }
            r.solveIndexColumn = this.solveIndexColumn;
            r.nullRows = this.nullRows;
            r.isSolved = this.isSolved;
            return r;
        }
        catch (ExtendedException e) {
            return null;
        }
    }

    public MatrixPanel initXMatrix(MatrixPanel b) throws ExtendedException {
        this.solveIndexColumn = -1;
        return super.initXMatrix(b);
    }

    public int getSolveIndexRow() {
        return this.solveIndexColumn;
    }

    public void isPivotLegal(int row, int column, boolean columnPivot) throws MatrixException {
        if (row >= this.rowDim || column >= this.columnDim) {
            throw new MatrixException(Messages.getString("uibk.mtk.math.numberPanel.messages", "RationalMatrix.2"), ExceptionLevel.ERROR);
        }
        if (columnPivot ? row < this.indexPivot || column != this.indexPivot : row < this.indexPivot || column < this.indexPivot) {
            throw new MatrixException(Messages.getString("uibk.mtk.math.numberPanel.messages", "RationalMatrix.3"), ExceptionLevel.INFO);
        }
        if (this.indexPivot >= this.rowDim || this.indexPivot >= this.columnDim) {
            throw new MatrixException(Messages.getString("uibk.mtk.math.numberPanel.messages", "RationalMatrix.7"), ExceptionLevel.INFO);
        }
    }

    public boolean haveLigalPivot(boolean columnPivot) throws ExtendedException {
        int min;
        int n = min = this.rowDim < this.columnDim ? this.rowDim : this.columnDim;
        if (this.indexPivot >= min) {
            return false;
        }
        int rD = this.rowDim;
        if (columnPivot) {
            rD = this.indexPivot + 1;
        }
        int i = this.indexPivot;
        while (i < rD) {
            int j = this.indexPivot;
            while (j < this.columnDim) {
                if (this.data[i][j].getDoubleValue() != 0.0) {
                    return true;
                }
                ++j;
            }
            ++i;
        }
        return false;
    }

    public int getIndexPivot() {
        return this.indexPivot;
    }
}

