/*
 * Decompiled with CFR 0.152.
 */
package uibk.mtk.math.numberPanel;

import uibk.mtk.exception.ExtendedException;
import uibk.mtk.math.numberPanel.MatrixPanel;
import uibk.mtk.math.numberPanel.MatrixUtil;
import uibk.mtk.math.numberPanel.MyNumber;

public class MatrixPanelCholesky
extends MatrixPanel {
    private MatrixPanel L = null;
    private MatrixPanel LT = null;
    private MatrixPanel vec = null;
    private int indexColumn = 0;
    private int indexRow = 0;

    public MatrixPanelCholesky(MyNumber[][] data) throws ExtendedException {
        super(data);
    }

    public MatrixPanelCholesky(int rowDimension, int columnDimension) throws ExtendedException {
        super(rowDimension, columnDimension);
    }

    protected void intAlgorithm() throws ExtendedException {
        super.intAlgorithm();
        this.indexColumn = 0;
        this.indexRow = 0;
    }

    public void setValueAt(int row, int column, MyNumber r) throws ExtendedException {
        super.setValueAt(row, column, r);
        this.setMatrixToIdentity(this.L);
        this.setMatrixToIdentity(this.LT);
        this.setMatrixToIdentity(this.vec);
    }

    public MatrixPanel subIntern(int row1, int row2, MyNumber t) throws ExtendedException {
        this.L = this.getL();
        super.subIntern(row1, row2, t);
        int i = row1;
        while (i < this.L.columnDim) {
            this.L.setValueAtIntern(row2, i, this.L.data[row2][i].add(t.mul(this.L.data[row1][i])));
            ++i;
        }
        this.LT = this.getLT();
        i = row1;
        while (i < this.L.columnDim) {
            this.LT.setValueAtIntern(row2, i, this.LT.data[row2][i].add(t.mul(this.LT.data[row1][i])));
            ++i;
        }
        return this;
    }

    public MatrixPanel getL() throws ExtendedException {
        if (this.L == null) {
            this.L = MatrixUtil.getIdentityMatrix(this.rowDim, this.rowDim, this.view, this, this.getVauleAt(0, 0).getClass());
        }
        return this.L;
    }

    public MatrixPanel getLT() throws ExtendedException {
        if (this.LT == null) {
            this.LT = MatrixUtil.getIdentityMatrix(this.rowDim, this.rowDim, this.view, this, this.getVauleAt(0, 0).getClass());
        }
        return this.LT;
    }

    public MatrixPanel getVec() throws ExtendedException {
        if (this.vec == null) {
            this.vec = MatrixUtil.getIdentityMatrix(this.rowDim, 1, this.view, this, this.getVauleAt(0, 0).getClass());
        }
        return this.vec;
    }

    public MatrixPanelCholesky clone() {
        try {
            int j;
            MyNumber[][] data = new MyNumber[this.rowDim][this.columnDim];
            int i = 0;
            while (i < this.rowDim) {
                int j2 = 0;
                while (j2 < this.columnDim) {
                    data[i][j2] = this.getVauleAt(i, j2).clone();
                    ++j2;
                }
                ++i;
            }
            MatrixPanelCholesky r = new MatrixPanelCholesky(data);
            r.indexPivot = this.indexPivot;
            if (this.L != null) {
                data = new MyNumber[this.L.rowDim][this.L.columnDim];
                int i2 = 0;
                while (i2 < this.L.rowDim) {
                    j = 0;
                    while (j < this.L.columnDim) {
                        data[i2][j] = this.L.getVauleAt(i2, j).clone();
                        ++j;
                    }
                    ++i2;
                }
                MatrixPanelCholesky p = new MatrixPanelCholesky(data);
                r.L = p;
            }
            if (this.LT != null) {
                data = new MyNumber[this.LT.rowDim][this.LT.columnDim];
                int i3 = 0;
                while (i3 < this.LT.rowDim) {
                    j = 0;
                    while (j < this.LT.columnDim) {
                        data[i3][j] = this.LT.getVauleAt(i3, j).clone();
                        ++j;
                    }
                    ++i3;
                }
                MatrixPanelCholesky p = new MatrixPanelCholesky(data);
                r.LT = p;
            }
            if (this.vec != null) {
                data = new MyNumber[this.vec.rowDim][1];
                int j3 = 0;
                while (j3 < this.vec.rowDim) {
                    data[j3][0] = this.vec.getVauleAt(j3, 0).clone();
                    ++j3;
                }
                MatrixPanelCholesky p = new MatrixPanelCholesky(data);
                r.vec = p;
            }
            r.setPrecision(this.precision);
            r.view = this.view;
            r.indexColumn = this.indexColumn;
            r.indexRow = this.indexRow;
            r.nullRows = this.nullRows;
            r.isSolved = this.isSolved;
            return r;
        }
        catch (ExtendedException e) {
            return null;
        }
    }

    public MatrixPanel initXMatrix(MatrixPanel b) throws ExtendedException {
        this.indexColumn = 0;
        this.indexRow = 0;
        return super.initXMatrix(b);
    }

    public int getIndexRow() {
        return this.indexRow;
    }

    public int getIndexColumn() {
        return this.indexColumn;
    }

    public void setIndexRow(int index) {
        this.indexRow = index;
    }

    public void setIndexColumn(int index) {
        this.indexColumn = index;
    }

    public synchronized void setPrecision(int i) {
        super.setPrecision(i);
        if (this.L != null) {
            this.L.setPrecision(i);
        }
        if (this.LT != null) {
            this.LT.setPrecision(i);
        }
        if (this.vec != null) {
            this.vec.setPrecision(i);
        }
    }
}

