/*
 * Decompiled with CFR 0.152.
 */
package uibk.mtk.math.numberPanel;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import uibk.mtk.exception.ExceptionLevel;
import uibk.mtk.exception.ExtendedException;
import uibk.mtk.math.NotANumberException;
import uibk.mtk.math.Rounder;
import uibk.mtk.math.numberPanel.MyNumber;

public class IrrationalNumber
extends MyNumber {
    private static double EPS = 1.0E-15;
    public static final IrrationalNumber ONE = new IrrationalNumber(0, null, 3);
    private double number = 0.0;
    private String symbol = null;
    private JLabel label = new JLabel();
    private Component parentComponent;
    private int view = 2;

    public IrrationalNumber(double number, int view, Component parentComponent, int precision) {
        super(precision);
        this.parentComponent = parentComponent;
        this.setView(view);
        this.number = number;
    }

    public IrrationalNumber(String symbol, int view, Component parentComponent, int precision) {
        super(precision);
        this.parentComponent = parentComponent;
        this.symbol = symbol;
        this.setView(view);
    }

    public IrrationalNumber(int view, Component parentComponent, int precision) {
        super(precision);
        this.parentComponent = parentComponent;
        this.setView(view);
        this.number = 0.0;
    }

    public void setView(int view) {
        if (view != 0 && view != 2 && view != 3) {
            throw new IllegalArgumentException("Nur DOUBLE_VIEW und SYMBOL_VIEW zul\u00e4ssig");
        }
        if (this.view != view) {
            this.view = view;
            this.setLabels();
        }
    }

    public int getView() {
        return this.view;
    }

    public double getDoubleValue() throws ExtendedException {
        return this.number;
    }

    public void setNumber(double n) throws NotANumberException {
        this.number = n;
        this.symbol = null;
        this.setLabels();
    }

    public void setSymbol(String n) {
        this.symbol = n;
        this.number = 0.0;
        this.setLabels();
    }

    public double getNumber() {
        return this.number;
    }

    protected void setLabels() {
        switch (this.view) {
            case 3: {
                if (this.symbol != null) {
                    this.label.setText(this.toString());
                    break;
                }
                this.label.setText("0");
                break;
            }
            case 2: {
                Double d = Rounder.roundNumPlacesNext(this.number, this.commaPlaces);
                if (d == 0.0) {
                    d = new Double(0.0);
                }
                this.label.setText(d.toString());
                break;
            }
            case 0: {
                break;
            }
        }
        this.initPanel();
    }

    public MyNumber add(MyNumber _r) throws ExtendedException {
        IrrationalNumber r = new IrrationalNumber(_r.getDoubleValue(), _r.getView(), this.parentComponent, this.commaPlaces);
        return new IrrationalNumber(this.number + r.number, this.view, this.parentComponent, this.commaPlaces);
    }

    public MyNumber sub(MyNumber _r) throws ExtendedException {
        IrrationalNumber r = new IrrationalNumber(_r.getDoubleValue(), _r.getView(), this.parentComponent, this.commaPlaces);
        if (r.symbol != null || this.symbol != null) {
            throw new NotANumberException("Nicht implementiert", ExceptionLevel.ERROR);
        }
        return new IrrationalNumber(this.number - r.number, this.view, this.parentComponent, this.commaPlaces);
    }

    public MyNumber mul(MyNumber _r) throws ExtendedException {
        IrrationalNumber r = new IrrationalNumber(_r.getDoubleValue(), _r.getView(), this.parentComponent, this.commaPlaces);
        return new IrrationalNumber(this.number * r.number, this.view, this.parentComponent, this.commaPlaces);
    }

    public MyNumber div(MyNumber _r) throws ExtendedException {
        IrrationalNumber r = new IrrationalNumber(_r.getDoubleValue(), _r.getView(), this.parentComponent, this.commaPlaces);
        if (r.symbol != null || this.symbol != null) {
            throw new NotANumberException("Nicht implementiert", ExceptionLevel.ERROR);
        }
        if (r.number == 0.0) {
            throw new NotANumberException("Zahl muss ungleich Null sein", ExceptionLevel.ERROR);
        }
        return new IrrationalNumber(this.number / r.number, this.view, this.parentComponent, this.commaPlaces);
    }

    public int compareTo(MyNumber r) throws ExtendedException {
        return new Double(this.number).compareTo(r.getDoubleValue());
    }

    public String toString() {
        String ret = "";
        ret = this.symbol != null ? String.valueOf(ret) + this.symbol : String.valueOf(ret) + this.number;
        return ret;
    }

    private void initPanel() {
        if (this.parentComponent != null && this.view != 0) {
            this.setLayout(new BorderLayout());
            this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.label.setBorder(BorderFactory.createEmptyBorder(0, 1, 0, 1));
            this.label.setHorizontalAlignment(0);
            this.add((Component)this.label, "Center");
        }
    }

    public MyNumber abs() throws NotANumberException {
        if (this.symbol == null) {
            return new IrrationalNumber(Math.abs(this.number), this.view, this.parentComponent, this.commaPlaces);
        }
        return new IrrationalNumber(this.view, this.parentComponent, this.commaPlaces);
    }

    public void setFont(Font f) {
        if (f != null && this.label != null) {
            this.label.setFont(f);
        }
        this.setLabels();
    }

    public void setBackground(Color c) {
        if (c != null && this.label != null) {
            super.setBackground(c);
            this.label.setBackground(c);
        }
        this.setLabels();
    }

    public Component getParentComponent() {
        return this.parentComponent;
    }

    public void setParentComponent(Component parentComponent) {
        this.parentComponent = parentComponent;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public MyNumber clone() {
        IrrationalNumber r = new IrrationalNumber(this.number, this.view, this.parentComponent, this.commaPlaces);
        if (this.symbol != null) {
            r.symbol = new String(this.symbol);
        }
        return r;
    }

    public boolean isZero() {
        return this.number > -EPS && this.number < EPS && this.symbol == null;
    }

    public IrrationalNumber sqrt() throws NotANumberException {
        if (this.symbol == null) {
            this.number = Math.sqrt(this.number);
            return this;
        }
        throw new NotANumberException("Irrationale Zahl ist Symbol", ExceptionLevel.ERROR);
    }

    public static double getEPS() {
        return EPS;
    }

    public static void setEPS(double eps) {
        EPS = Math.abs(eps);
    }
}

