/*
 * Decompiled with CFR 0.152.
 */
package uibk.applets.QRAlgorithmus;

import java.awt.Component;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import uibk.applets.QRAlgorithmus.AppletQRAlgorithmus;
import uibk.applets.QRAlgorithmus.MouseEvents;
import uibk.applets.QRAlgorithmus.PanelControl;
import uibk.applets.QRAlgorithmus.PanelMatrixParameter;
import uibk.mtk.exception.ExtendedException;
import uibk.mtk.lang.Messages;
import uibk.mtk.math.NotANumberException;
import uibk.mtk.math.numberPanel.MatrixEvent;
import uibk.mtk.math.numberPanel.MatrixException;
import uibk.mtk.math.numberPanel.MatrixPanel;
import uibk.mtk.math.numberPanel.MatrixPanelQR;
import uibk.mtk.math.numberPanel.RationalMatrixListener;
import uibk.mtk.math.numberPanel.RationalNumber;
import uibk.mtk.math.polynom.Polynom;
import uibk.mtk.swing.base.MPanel;

public abstract class PanelMain
extends MPanel
implements RationalMatrixListener,
ComponentListener {
    protected int step = 0;
    protected final AppletQRAlgorithmus main;
    protected final PanelControl panelControl;
    protected final MouseEvents mouseEvents;
    protected MatrixPanelQR A;
    protected MatrixPanelQR R;
    protected MatrixPanel x;
    protected MatrixPanel b;
    protected final MPanel[] panels = new MPanel[9];
    protected Vector<History> history = new Vector();
    protected final PanelMatrixParameter panelParameter;
    protected MatrixPanel Qt = null;
    protected MatrixPanel H = null;

    public PanelMain(AppletQRAlgorithmus main, PanelControl panelControl, PanelMatrixParameter panelParameter) {
        this.main = main;
        this.mouseEvents = new MouseEvents(main, this, panelControl);
        this.panelControl = panelControl;
        this.panelParameter = panelParameter;
        this.setBackground(AppletQRAlgorithmus.COLOR_BGD);
        this.setLayout(new BoxLayout(this, 1));
    }

    protected void initPanels() {
        this.removeAll();
        this.history.lastElement().removeAll();
        this.history.lastElement().setBackground(AppletQRAlgorithmus.COLOR_BGD);
        this.history.lastElement().setAlignmentX(0.0f);
        this.history.lastElement().add(Box.createGlue());
        int i = 0;
        while (i < this.panels.length) {
            this.panels[i] = new MPanel();
            this.panels[i].setBackground(AppletQRAlgorithmus.COLOR_BGD);
            this.history.lastElement().add(this.panels[i]);
            ++i;
        }
        this.history.lastElement().add(Box.createGlue());
        i = this.history.size();
        while (i > 0) {
            this.add(this.history.get(i - 1));
            --i;
        }
        this.add(Box.createVerticalGlue());
    }

    public void newGLS(int rows, int columns, int columnsRe, boolean isPivotin, int calcType) throws ExtendedException {
        int j;
        int i;
        MatrixPanelQR A = new MatrixPanelQR(rows, columns, isPivotin, this.panelControl.getPrecision(), calcType);
        MatrixPanel b = null;
        if (columnsRe > 0) {
            b = new MatrixPanel(rows, columnsRe);
            i = 0;
            while (i < rows) {
                j = 0;
                while (j < columnsRe) {
                    b.setValueAt(i, j, new RationalNumber(0L, 1L, 2, (Component)this.main));
                    ++j;
                }
                ++i;
            }
        }
        i = 0;
        while (i < rows) {
            j = 0;
            while (j < columns) {
                A.setValueAt(i, j, new RationalNumber(0L, 1L, 2, (Component)this.main));
                ++j;
            }
            ++i;
        }
        this.newGLS(A, b);
    }

    public void newGLS(MatrixPanelQR A, MatrixPanel b) throws ExtendedException {
        this.A = A;
        this.R = A.clone();
        this.b = b;
        this.newGLSImpl();
        this.x = this.initXMatrix(A, b);
        this.Qt = null;
        this.H = null;
        this.history.removeAllElements();
        this.history.add(new History(A, this.R, this.Qt, this.H, this.x, b, 0));
        this.initGLS(0);
        this.panelParameter.setMatrixParameter(A);
        A.addRationalMatrixListener(this);
        this.setTitleStep();
        this.main.report.reportSuccess(Messages.getString("uibk.applets.QRAlgorithmus.messages", "PanelMain.13"));
    }

    protected abstract void newGLSImpl();

    protected MatrixPanel initXMatrix(MatrixPanel A, MatrixPanel b) throws ExtendedException {
        if (b == null) {
            return null;
        }
        MatrixPanel x = A.initXMatrix(b);
        int i = 0;
        while (i < A.getColumnDim()) {
            int j = 0;
            while (j < b.getColumnDim()) {
                String sym = "x[" + (i + 1) + "," + (j + 1) + "]";
                if (b.getColumnDim() == 1) {
                    sym = "x[" + (i + 1) + "]";
                }
                x.setValueAt(i, j, new RationalNumber(new Polynom(sym), new Polynom("1"), 3, (Component)this.main));
                ++j;
            }
            ++i;
        }
        return x;
    }

    public abstract void initGLS(int var1) throws ExtendedException;

    public void valueSet(MatrixEvent ev) throws ExtendedException {
        this.setTitleStep();
        this.R = this.A.clone();
        this.initGLS(this.step);
        this.history.lastElement().R = this.R;
        this.main.report.reportSuccess(Messages.getString("uibk.applets.QRAlgorithmus.messages", "PanelMain.14"));
    }

    protected void addSteppToHistory(int step) throws ExtendedException {
        this.A.removeMouseListener(this.mouseEvents);
        this.A.removeMouseMotionListener(this.mouseEvents);
        this.A.setBackground(AppletQRAlgorithmus.COLOR_HISTORY);
        this.A.setFont(AppletQRAlgorithmus.FONT_HISTORY);
        this.A.setBorderByIndex(-1, -1, 1, null);
        this.R.setBackground(AppletQRAlgorithmus.COLOR_HISTORY);
        this.R.setFont(AppletQRAlgorithmus.FONT_HISTORY);
        this.R.removeMouseListener(this.mouseEvents);
        this.R.removeMouseMotionListener(this.mouseEvents);
        if (this.b != null) {
            this.b.removeMouseListener(this.mouseEvents);
            this.b.removeMouseMotionListener(this.mouseEvents);
            this.b.setBackground(AppletQRAlgorithmus.COLOR_HISTORY);
            this.b.setFont(AppletQRAlgorithmus.FONT_HISTORY);
            this.b.setBorderByIndex(-1, -1, 1, null);
        }
        if (this.Qt != null) {
            this.Qt.setBackground(AppletQRAlgorithmus.COLOR_HISTORY);
            this.Qt.setFont(AppletQRAlgorithmus.FONT_HISTORY);
        }
        if (this.H != null) {
            this.H.setBackground(AppletQRAlgorithmus.COLOR_HISTORY);
            this.H.setFont(AppletQRAlgorithmus.FONT_HISTORY);
        }
        if (this.A.getP() != null) {
            this.A.getP().setBackground(AppletQRAlgorithmus.COLOR_HISTORY);
            this.A.getP().setFont(AppletQRAlgorithmus.FONT_HISTORY);
        }
        if (this.x != null) {
            this.x.setBackground(AppletQRAlgorithmus.COLOR_HISTORY);
            this.x.setFont(AppletQRAlgorithmus.FONT_HISTORY);
        }
        if (this.A.getQ() != null) {
            this.A.getQ().setBackground(AppletQRAlgorithmus.COLOR_HISTORY);
            this.A.getQ().setFont(AppletQRAlgorithmus.FONT_HISTORY);
        }
        this.addSteppToHistoryImpl(step);
        this.A = this.A.clone();
        this.R = this.R.clone();
        if (this.b != null) {
            this.x = this.x.clone();
            this.b = this.b.clone();
        }
        if (this.Qt != null) {
            this.Qt = this.Qt.clone();
        }
        if (this.H != null) {
            this.H = this.H.clone();
        }
        this.history.add(new History(this.A, this.R, this.Qt, this.H, this.x, this.b, step));
    }

    protected abstract void addSteppToHistoryImpl(int var1) throws ExtendedException;

    public void removeStepFromHistory() throws ExtendedException {
        if (this.history.size() > 1) {
            this.history.remove(this.history.lastElement());
            this.step = this.history.lastElement().step;
            this.A = this.history.lastElement().A;
            this.A.setBorderByIndex(-1, -1, 1, null);
            this.x = this.history.lastElement().x;
            this.b = this.history.lastElement().b;
            this.Qt = this.history.lastElement().Qt;
            this.H = this.history.lastElement().H;
            this.R = this.history.lastElement().R;
            this.initGLS(this.step);
            this.setTitleStep();
            this.main.report.reportSuccess(Messages.getString("uibk.applets.QRAlgorithmus.messages", "PanelMain.12"));
            this.removeStepFromHistoryImpl();
        }
    }

    public void goToFirstHistroyEntry() throws ExtendedException {
        while (this.history.size() > 1) {
            this.removeStepFromHistory();
        }
    }

    protected abstract void removeStepFromHistoryImpl() throws ExtendedException;

    /*
     * Unable to fully structure code
     */
    public void qrAlgorithmus() throws ExtendedException {
        if (this.A != null) ** GOTO lbl4
        return;
lbl-1000:
        // 1 sources

        {
            this.qrStep(null);
lbl4:
            // 2 sources

            ** while (!this.A.isQR())
        }
lbl5:
        // 1 sources

    }

    public void solve() throws ExtendedException {
        if (this.A == null) {
            return;
        }
        this.qrAlgorithmus();
        while (!this.A.isSolved()) {
            this.solveStep();
        }
    }

    public void step() throws ExtendedException {
        if (this.A == null) {
            return;
        }
        this.main.report.reportSuccess(this.setTitleStep());
        if (!this.A.isQR()) {
            this.qrStep(null);
        } else {
            this.solveStep();
        }
        this.setTitleStep();
    }

    public String setTitleStep() throws ExtendedException {
        String msg = this.A == null ? Messages.getString("uibk.applets.QRAlgorithmus.messages", "PanelControl.5") : (!this.A.isQR() ? Messages.getString("uibk.applets.QRAlgorithmus.messages", "PanelMain.10") : Messages.getString("uibk.applets.QRAlgorithmus.messages", "PanelMain.11"));
        this.panelControl.setTitleStep(msg);
        return msg;
    }

    public void qrStep(int[] ij) throws ExtendedException {
        ++this.step;
        this.addSteppToHistory(this.step);
        try {
            this.qrStepImpl(ij);
        }
        catch (MatrixException e) {
            this.removeStepFromHistory();
            throw e;
        }
        catch (NotANumberException e) {
            this.removeStepFromHistory();
            throw e;
        }
    }

    protected abstract void qrStepImpl(int[] var1) throws ExtendedException;

    protected abstract void solveStep() throws ExtendedException;

    public MatrixPanelQR getA() {
        return this.A;
    }

    public MatrixPanelQR getR() {
        return this.R;
    }

    public MatrixPanel getB() {
        return this.b;
    }

    public void componentHidden(ComponentEvent e) {
        try {
            if (this.main != null && this.main.getSelectedMainPanel() != null) {
                this.main.getSelectedMainPanel().setTitleStep();
                this.main.getSelectedMainPanel().setLabelAlgo();
            }
        }
        catch (ExtendedException extendedException) {
            // empty catch block
        }
    }

    public void componentMoved(ComponentEvent e) {
    }

    public void componentResized(ComponentEvent e) {
    }

    public void componentShown(ComponentEvent e) {
        this.setLabelAlgo();
        try {
            this.setTitleStep();
        }
        catch (ExtendedException extendedException) {
            // empty catch block
        }
    }

    protected abstract void setLabelAlgo();

    public void setPrecision(int i) {
        if (this.A != null) {
            this.A.setPrecision(i);
        }
        if (this.R != null) {
            this.R.setPrecision(i);
        }
        if (this.Qt != null) {
            this.Qt.setPrecision(i);
        }
        if (this.H != null) {
            this.H.setPrecision(i);
        }
        for (History h : this.history) {
            if (h.A != null) {
                h.A.setPrecision(i);
            }
            if (h.R != null) {
                h.R.setPrecision(i);
            }
            if (h.Qt != null) {
                h.Qt.setPrecision(i);
            }
            if (h.H != null) {
                h.H.setPrecision(i);
            }
            if (h.x != null) {
                h.x.setPrecision(i);
            }
            if (h.b != null) {
                h.b.setPrecision(i);
            }
            if (h.xDisplay != null) {
                h.xDisplay.setPrecision(i);
            }
            if (h.bDisplay == null) continue;
            h.bDisplay.setPrecision(i);
        }
    }

    public int getStep() {
        return this.step;
    }

    protected class History
    extends MPanel {
        MatrixPanelQR A;
        MatrixPanelQR R;
        MatrixPanel Qt;
        MatrixPanel H;
        MatrixPanel x;
        MatrixPanel b;
        MatrixPanel xDisplay;
        MatrixPanel bDisplay;
        Vector<MatrixPanel> generalSolution;
        int step = -1;

        public History(MatrixPanelQR A, MatrixPanelQR R, MatrixPanel Qt, MatrixPanel H, MatrixPanel x, MatrixPanel b, int solveStep) {
            this.A = A;
            this.R = R;
            this.Qt = Qt;
            this.H = H;
            this.x = x;
            this.b = b;
            this.step = solveStep;
        }
    }
}

