/*
 * Decompiled with CFR 0.152.
 */
package uibk.applets.QRAlgorithmus;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.URL;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import uibk.applets.QRAlgorithmus.AppletQRAlgorithmus;
import uibk.applets.QRAlgorithmus.PanelExampleData;
import uibk.applets.QRAlgorithmus.PanelMain;
import uibk.applets.QRAlgorithmus.PanelMainGivens;
import uibk.applets.QRAlgorithmus.PanelMainQR;
import uibk.mtk.lang.Messages;
import uibk.mtk.swing.base.IntegerTextField;
import uibk.mtk.swing.base.MPanel;
import uibk.mtk.swing.base.TitledPanel;

public class PanelControl
extends MPanel
implements ActionListener,
ChangeListener {
    private final AppletQRAlgorithmus main;
    private final IntegerTextField rows = new IntegerTextField(10, 1, 10, Messages.getString("uibk.applets.QRAlgorithmus.messages", "PanelControl.14"));
    private final IntegerTextField columns = new IntegerTextField(10, 1, 10, Messages.getString("uibk.applets.QRAlgorithmus.messages", "PanelControl.15"));
    private final IntegerTextField columnsReSite = new IntegerTextField(10, 0, 10, Messages.getString("uibk.applets.QRAlgorithmus.messages", "PanelControl.16"));
    private final JEditorPane textPane = new JEditorPane();
    private JSpinner spinner;
    private final TitledPanel panelGauss = this.buttonsStep();

    public PanelControl(AppletQRAlgorithmus main) {
        this.main = main;
        this.initPanel();
    }

    private void initPanel() {
        this.setLayout(new BoxLayout(this, 1));
        this.add(new PanelExampleData(this.main, this));
        this.add(this.createEmtyMatrixPanel());
        this.add(this.spinnerPre());
        this.add(this.panelGauss);
        this.add(this.createAlgoDes());
        this.add(Box.createVerticalGlue());
        this.add(this.buttonsControl());
    }

    private TitledPanel createAlgoDes() {
        TitledPanel titlePanel = new TitledPanel(Messages.getString("uibk.applets.QRAlgorithmus.messages", "PanelControl.17"));
        titlePanel.setLayout(new BorderLayout());
        this.textPane.setEditable(false);
        titlePanel.add((Component)new JScrollPane(this.textPane), "Center");
        return titlePanel;
    }

    private TitledPanel createEmtyMatrixPanel() {
        TitledPanel titlePanel = new TitledPanel(Messages.getString("uibk.applets.QRAlgorithmus.messages", "PanelControl.13"));
        titlePanel.setLayout(new GridBagLayout());
        titlePanel.setMaximumSize(new Dimension(2000, 120));
        JLabel labelRows = new JLabel(Messages.getString("uibk.applets.QRAlgorithmus.messages", "PanelControl.14"));
        JLabel labelColumns = new JLabel(Messages.getString("uibk.applets.QRAlgorithmus.messages", "PanelControl.15"));
        JLabel lableColumnsRe = new JLabel(Messages.getString("uibk.applets.QRAlgorithmus.messages", "PanelControl.16"));
        this.setMaximumSize(new Dimension(2000, 120));
        titlePanel.add((Component)labelRows, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        titlePanel.add((Component)this.rows, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        titlePanel.add((Component)labelColumns, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 0, 0, 0), 0, 0));
        titlePanel.add((Component)this.columns, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        titlePanel.add((Component)lableColumnsRe, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 0, 0, 0), 0, 0));
        titlePanel.add((Component)this.columnsReSite, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        JButton creat = new JButton(Messages.getString("uibk.applets.QRAlgorithmus.messages", "PanelControl.0"));
        titlePanel.add((Component)creat, new GridBagConstraints(0, 4, 2, 1, 0.0, 0.0, 10, 0, new Insets(20, 0, 0, 0), 0, 0));
        this.columnsReSite.setText("0");
        creat.addActionListener(this);
        creat.setActionCommand("create");
        return titlePanel;
    }

    private TitledPanel buttonsStep() {
        TitledPanel panel = new TitledPanel(Messages.getString("uibk.applets.QRAlgorithmus.messages", "PanelControl.5"));
        JButton step = new JButton(Messages.getString("uibk.applets.QRAlgorithmus.messages", "PanelControl.2"));
        JButton rev = new JButton(Messages.getString("uibk.applets.QRAlgorithmus.messages", "PanelControl.4"));
        panel.setMaximumSize(new Dimension(1000, 20));
        panel.add(step);
        panel.add(rev);
        step.addActionListener(this);
        step.setActionCommand("step");
        step.setPreferredSize(new Dimension(100, 23));
        rev.addActionListener(this);
        rev.setActionCommand("rev");
        rev.setPreferredSize(new Dimension(100, 23));
        return panel;
    }

    private MPanel buttonsControl() {
        TitledPanel panel = new TitledPanel(Messages.getString("uibk.applets.QRAlgorithmus.messages", "PanelControl.5"));
        panel.setMaximumSize(new Dimension(1000, 20));
        JButton zerlegung = new JButton(Messages.getString("uibk.applets.QRAlgorithmus.messages", "PanelControl.1"));
        panel.add(zerlegung);
        JButton solve = new JButton(Messages.getString("uibk.applets.QRAlgorithmus.messages", "PanelControl.3"));
        panel.add(solve);
        zerlegung.addActionListener(this);
        zerlegung.setActionCommand("deco");
        solve.addActionListener(this);
        solve.setActionCommand("solve");
        return panel;
    }

    private MPanel spinnerPre() {
        TitledPanel panel = new TitledPanel(Messages.getString("uibk.applets.QRAlgorithmus.messages", "PanelControl.40"));
        panel.setMaximumSize(new Dimension(1000, 100));
        panel.setLayout(new GridBagLayout());
        SpinnerNumberModel model = new SpinnerNumberModel(3, 1, 15, 1);
        this.spinner = new JSpinner(model);
        this.spinner.addChangeListener(this);
        JLabel labelRows = new JLabel(Messages.getString("uibk.applets.QRAlgorithmus.messages", "PanelControl.41"));
        panel.add((Component)labelRows, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.spinner, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        return panel;
    }

    public void actionPerformed(ActionEvent ev) {
        try {
            if (ev.getActionCommand() == "create") {
                PanelMain[] panelMainArray = this.main.mainPanel;
                int n = this.main.mainPanel.length;
                int n2 = 0;
                while (n2 < n) {
                    PanelMain mainP = panelMainArray[n2];
                    if (mainP instanceof PanelMainQR) {
                        mainP.newGLS(this.rows.getValue(), this.columns.getValue(), this.columnsReSite.getValue(), false, 1);
                    } else if (mainP instanceof PanelMainGivens) {
                        mainP.newGLS(this.rows.getValue(), this.columns.getValue(), this.columnsReSite.getValue(), true, 2);
                    } else {
                        mainP.newGLS(this.rows.getValue(), this.columns.getValue(), this.columnsReSite.getValue(), true, 1);
                    }
                    ++n2;
                }
            } else if (ev.getActionCommand() == "step") {
                this.main.getSelectedMainPanel().step();
            } else if (ev.getActionCommand() == "deco") {
                this.main.getSelectedMainPanel().qrAlgorithmus();
            } else if (ev.getActionCommand() == "solve") {
                this.main.getSelectedMainPanel().solve();
            } else if (ev.getActionCommand() == "rev") {
                this.main.getSelectedMainPanel().removeStepFromHistory();
            }
        }
        catch (Exception e) {
            this.main.report.reportException(null, e, this.main);
            e.printStackTrace();
        }
        this.main.setMainPanel();
    }

    public void setTitleStep(String title) {
        this.panelGauss.setBorderTitle(title);
        this.panelGauss.repaint();
    }

    public void stateChanged(ChangeEvent e) {
        if (e.getSource().equals(this.spinner)) {
            int i = (Integer)this.spinner.getValue();
            PanelMain[] panelMainArray = this.main.mainPanel;
            int n = this.main.mainPanel.length;
            int n2 = 0;
            while (n2 < n) {
                PanelMain panel = panelMainArray[n2];
                panel.setPrecision(i);
                ++n2;
            }
            this.main.setMainPanel();
        }
    }

    public int getPrecision() {
        return (Integer)this.spinner.getValue();
    }

    public void setLabelAlgo(URL url) {
        try {
            this.textPane.setPage(url);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

