/*
 * Decompiled with CFR 0.152.
 */
package uibk.mtk.draw2d.objects;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.Vector;
import uibk.mtk.draw2d.base.Drawable2D;
import uibk.mtk.draw2d.objects.MathArrow2D;
import uibk.mtk.draw2d.objects.Messages;
import uibk.mtk.geom.CoordinateRect2D;
import uibk.mtk.geom.Punkt2D;
import uibk.mtk.lang.PrepaintComputable;
import uibk.mtk.math.functions.VectorField2D;
import uibk.mtk.util.Grid2D;

public class GraphVectorField2D
extends Drawable2D
implements PrepaintComputable {
    int gridx = 10;
    int gridy = 10;
    VectorField2D vectorfield2d;
    private Vector arrows = new Vector();
    public static final int ARROWS_SAME_LENGTH = 0;
    public static final int ARROWS_SCALED_LENGTH = 1;
    private int mode = 0;
    CoordinateRect2D limits_vectorfield = new CoordinateRect2D();
    CoordinateRect2D draw_limits = new CoordinateRect2D();

    public GraphVectorField2D(VectorField2D vectorfield2d) {
        this.setVectorField(vectorfield2d);
    }

    public GraphVectorField2D() {
    }

    public void setVectorField(VectorField2D vectorfield2d) {
        if (vectorfield2d == null) {
            throw new NullPointerException(Messages.getString("GraphVectorField2D.0"));
        }
        this.vectorfield2d = vectorfield2d;
    }

    public void setMode(int mode) {
        this.mode = mode;
    }

    public void setGridSize(int x, int y) throws Exception {
        if (x < 2 || y < 2) {
            throw new IllegalArgumentException(Messages.getString("GraphVectorField2D.1"));
        }
        this.gridx = x;
        this.gridy = y;
    }

    @Override
    public void setColor(Color color) {
        this.color = color;
        int i = 0;
        while (i < this.arrows.size()) {
            ((MathArrow2D)this.arrows.elementAt(i)).setColor(color);
            ++i;
        }
    }

    public void setLimits(CoordinateRect2D rect) {
        this.draw_limits = (CoordinateRect2D)rect.clone();
        this.limits_vectorfield = (CoordinateRect2D)rect.clone();
    }

    private void addArrow(Punkt2D p, Punkt2D velocity, double max) {
        double newheadY;
        double newheadX;
        double newbaseY;
        double newbaseX;
        double lx = (this.limits_vectorfield.xmax - this.limits_vectorfield.xmin) / (double)(this.gridx + this.gridx / 10);
        double ly = (this.limits_vectorfield.ymax - this.limits_vectorfield.ymin) / (double)(this.gridy + this.gridy / 10);
        double length = Math.min(lx, ly);
        double norm = Math.sqrt(velocity.x * velocity.x + velocity.y * velocity.y);
        Punkt2D velocityE = velocity.scale(1.0 / norm);
        if (this.mode == 0) {
            newbaseX = p.x - velocityE.x / 2.0 * length;
            newbaseY = p.y - velocityE.y / 2.0 * length;
            newheadX = p.x + velocityE.x / 2.0 * length;
            newheadY = p.y + velocityE.y / 2.0 * length;
        } else {
            newbaseX = p.x - velocityE.x / 2.0 * norm / max * length;
            newbaseY = p.y - velocityE.y / 2.0 * norm / max * length;
            newheadX = p.x + velocityE.x / 2.0 * norm / max * length;
            newheadY = p.y + velocityE.y / 2.0 * norm / max * length;
        }
        if (Double.isNaN(newbaseX) || Double.isInfinite(newbaseX) || Double.isNaN(newbaseY) || Double.isInfinite(newbaseY) || Double.isNaN(newheadX) || Double.isInfinite(newheadX) || Double.isNaN(newheadY) || Double.isInfinite(newheadY) || newbaseX == newheadX && newbaseY == newheadY) {
            return;
        }
        MathArrow2D arrow = new MathArrow2D(new Punkt2D(newbaseX, newbaseY), new Punkt2D(newheadX, newheadY));
        arrow.setColor(this.color);
        arrow.setMathPanel2D(this.panel);
        if (arrow.getHead().x < this.draw_limits.xmin) {
            this.draw_limits.xmin = arrow.getHead().x;
        }
        if (arrow.getHead().x > this.draw_limits.xmax) {
            this.draw_limits.xmax = arrow.getHead().x;
        }
        if (arrow.getHead().y < this.draw_limits.ymin) {
            this.draw_limits.ymin = arrow.getHead().y;
        }
        if (arrow.getHead().y > this.draw_limits.ymax) {
            this.draw_limits.ymax = arrow.getHead().y;
        }
        if (arrow.getBase().x < this.draw_limits.xmin) {
            this.draw_limits.xmin = arrow.getBase().x;
        }
        if (arrow.getBase().x > this.draw_limits.xmax) {
            this.draw_limits.xmax = arrow.getBase().x;
        }
        if (arrow.getBase().y < this.draw_limits.ymin) {
            this.draw_limits.ymin = arrow.getBase().y;
        }
        if (arrow.getBase().y > this.draw_limits.ymax) {
            this.draw_limits.ymax = arrow.getBase().y;
        }
        this.arrows.add(arrow);
    }

    @Override
    public void prepaintcompute() throws Exception {
        this.compute();
        int i = 0;
        while (i < this.arrows.size()) {
            try {
                ((MathArrow2D)this.arrows.elementAt(i)).prepaintcompute();
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++i;
        }
    }

    private void compute() throws Exception {
        Punkt2D p;
        int j;
        this.draw_limits = (CoordinateRect2D)this.limits_vectorfield.clone();
        this.arrows.clear();
        Punkt2D[][] gridpoints = Grid2D.createGrid2D(this.limits_vectorfield.xmin, this.limits_vectorfield.xmax, this.limits_vectorfield.ymin, this.limits_vectorfield.ymax, this.gridx, this.gridy);
        if (gridpoints == null) {
            throw new Exception(Messages.getString("GraphVectorField2D.2"));
        }
        double max = 0.0;
        int i = 0;
        while (i < gridpoints.length) {
            j = 0;
            while (j < gridpoints[0].length) {
                p = gridpoints[i][j];
                Punkt2D velocity = this.vectorfield2d.velocityVectorAt(p);
                double normquad = velocity.quadnorm();
                if (normquad > max) {
                    max = normquad;
                }
                ++j;
            }
            ++i;
        }
        max = Math.sqrt(max);
        i = 0;
        while (i < gridpoints.length) {
            j = 0;
            while (j < gridpoints.length) {
                p = gridpoints[i][j];
                this.addArrow(p, this.vectorfield2d.velocityVectorAt(p), max);
                ++j;
            }
            ++i;
        }
        this.scene2d.setLimits(this.draw_limits);
    }

    @Override
    public void draw(BufferedImage framebuffer, Graphics2D g2) {
        int i = 0;
        while (i < this.arrows.size()) {
            MathArrow2D arrow = (MathArrow2D)this.arrows.elementAt(i);
            arrow.draw(framebuffer, g2);
            ++i;
        }
    }
}

