/*
 * Decompiled with CFR 0.152.
 */
package uibk.applets.dynamicsystems2d;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import uibk.applets.dynamicsystems2d.AppletDynamicSystems2D;
import uibk.applets.dynamicsystems2d.Messages;
import uibk.mtk.geom.CoordinateRect2D;
import uibk.mtk.math.functions.ParsedVectorField2D;
import uibk.mtk.math.parsing.Misc;
import uibk.mtk.math.parsing.VectorFieldParser;
import uibk.mtk.swing.base.MPanel;
import uibk.mtk.swing.base.TitledPanel;

class PanelVectorField
extends MPanel
implements ActionListener {
    AppletDynamicSystems2D main;
    JTextField txtXmin;
    JTextField txtXmax;
    JTextField txtYmin;
    JTextField txtYmax;
    JRadioButton optSameLength;
    JRadioButton optScaleLength;
    JSlider sliderGridPoints = new JSlider();
    JTextField txtKomponenteX;
    JTextField txtKomponenteY;
    JLabel labelGrid;

    @Override
    public void actionPerformed(ActionEvent ev) {
        if (ev.getActionCommand().equals("drawvectorfield")) {
            this.main.mathpanel2d.getScene2d().enableRound(false);
            this.main.mathpanel2d.getScene2d().axesequal(false);
            this.main.panelscaleaxes.update();
            if (this.optSameLength.isSelected()) {
                this.main.graphvectorfield.setMode(0);
            } else {
                this.main.graphvectorfield.setMode(1);
            }
            try {
                String varx = String.valueOf(AppletDynamicSystems2D.VARSAUTO[0]);
                String vary = String.valueOf(AppletDynamicSystems2D.VARSAUTO[1]);
                ParsedVectorField2D vf = VectorFieldParser.parseVectorfield(varx, vary, this.txtKomponenteX.getText(), this.txtKomponenteY.getText());
                this.main.graphvectorfield.setVectorField(vf);
                CoordinateRect2D rect = Misc.parseRectArea(this.txtXmin.getText(), this.txtXmax.getText(), this.txtYmin.getText(), this.txtYmax.getText());
                this.main.graphvectorfield.setLimits(rect);
                this.main.graphvectorfield.setGridSize(this.sliderGridPoints.getValue(), this.sliderGridPoints.getValue());
                this.main.graphvectorfield.setColor(AppletDynamicSystems2D.COLORVECTORFIELD);
                this.main.graphvectorfield.setVisible(true);
                this.main.graphflow.clear();
                this.main.calcSolFromClick = true;
                this.main.panelscaleaxes.setEnabled(false);
                this.main.mathpanel2d.reportSuccess(Messages.getString("PanelVectorField.1"));
                this.main.mathpanel2d.repaint();
            }
            catch (Exception ex) {
                this.main.mathpanel2d.reportError(ex);
                return;
            }
        }
    }

    public PanelVectorField(AppletDynamicSystems2D main) {
        this.main = main;
        this.initComponents();
    }

    MPanel createPanelComponents() {
        TitledPanel panelcomponents = new TitledPanel(Messages.getString("PanelVectorField.2"));
        panelcomponents.setLayout(new GridBagLayout());
        JLabel labelKomponenteX = new JLabel(String.valueOf(AppletDynamicSystems2D.VARSAUTO[0]) + "'=");
        JLabel labelKomponenteY = new JLabel(String.valueOf(AppletDynamicSystems2D.VARSAUTO[1]) + "'=");
        char varx = AppletDynamicSystems2D.VARSAUTO[0];
        char vary = AppletDynamicSystems2D.VARSAUTO[1];
        this.txtKomponenteX = new JTextField(10);
        this.txtKomponenteX.setActionCommand("drawvectorfield");
        this.txtKomponenteX.addActionListener(this);
        this.txtKomponenteX.setToolTipText(String.valueOf(Messages.getString("PanelVectorField.6")) + varx + Messages.getString("PanelVectorField.7") + varx + "," + vary + Messages.getString("PanelVectorField.9"));
        this.txtKomponenteY = new JTextField(10);
        this.txtKomponenteY.setActionCommand("drawvectorfield");
        this.txtKomponenteY.addActionListener(this);
        this.txtKomponenteY.setToolTipText(String.valueOf(Messages.getString("PanelVectorField.11")) + vary + Messages.getString("PanelVectorField.0") + varx + "," + vary + Messages.getString("PanelVectorField.14"));
        panelcomponents.add((Component)labelKomponenteX, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        panelcomponents.add((Component)this.txtKomponenteX, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        panelcomponents.add((Component)labelKomponenteY, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 0, 0, 0), 0, 0));
        panelcomponents.add((Component)this.txtKomponenteY, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        return panelcomponents;
    }

    MPanel createPanelDefine() {
        TitledPanel panelOpt = new TitledPanel(Messages.getString("PanelVectorField.15"));
        panelOpt.setLayout(new GridBagLayout());
        char varx = AppletDynamicSystems2D.VARSAUTO[0];
        char vary = AppletDynamicSystems2D.VARSAUTO[1];
        this.txtXmin = new JTextField(4);
        this.txtXmin.setActionCommand("drawvectorfield");
        this.txtXmin.addActionListener(this);
        this.txtXmin.setToolTipText(String.valueOf(Messages.getString("PanelVectorField.17")) + varx + Messages.getString("PanelVectorField.18"));
        this.txtXmax = new JTextField(4);
        this.txtXmax.setActionCommand("drawvectorfield");
        this.txtXmax.addActionListener(this);
        this.txtXmax.setToolTipText(String.valueOf(Messages.getString("PanelVectorField.20")) + varx + Messages.getString("PanelVectorField.21"));
        this.txtYmin = new JTextField(4);
        this.txtYmin.setActionCommand("drawvectorfield");
        this.txtYmin.addActionListener(this);
        this.txtYmin.setToolTipText(String.valueOf(Messages.getString("PanelVectorField.23")) + vary + Messages.getString("PanelVectorField.24"));
        this.txtYmax = new JTextField(4);
        this.txtYmax.setActionCommand("drawvectorfield");
        this.txtYmax.addActionListener(this);
        this.txtYmax.setToolTipText(String.valueOf(Messages.getString("PanelVectorField.26")) + vary + Messages.getString("PanelVectorField.27"));
        this.optSameLength = new JRadioButton(Messages.getString("PanelVectorField.28"), true);
        this.optScaleLength = new JRadioButton(Messages.getString("PanelVectorField.29"), false);
        this.optSameLength.setActionCommand("samelength");
        this.optScaleLength.setActionCommand("scaledlength");
        ButtonGroup groupVectorfieldOpt = new ButtonGroup();
        groupVectorfieldOpt.add(this.optSameLength);
        groupVectorfieldOpt.add(this.optScaleLength);
        JLabel labelArrows = new JLabel(Messages.getString("PanelVectorField.32"));
        JLabel labelArea = new JLabel(Messages.getString("PanelVectorField.33"));
        this.labelGrid = new JLabel(Messages.getString("PanelVectorField.34"));
        this.labelGrid.setFont(this.labelGrid.getFont().deriveFont(1));
        labelArrows.setFont(this.labelGrid.getFont().deriveFont(1));
        labelArea.setFont(this.labelGrid.getFont().deriveFont(1));
        JButton buttonCalc = new JButton(Messages.getString("PanelVectorField.35"));
        buttonCalc.setActionCommand("drawvectorfield");
        buttonCalc.addActionListener(this);
        this.sliderGridPoints.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                JSlider slider = (JSlider)evt.getSource();
                int value = slider.getValue();
                PanelVectorField.this.labelGrid.setText(String.valueOf(Messages.getString("PanelVectorField.37")) + String.valueOf(value) + "x" + String.valueOf(value));
            }
        });
        this.sliderGridPoints.setMinimum(2);
        this.sliderGridPoints.setMaximum(40);
        this.sliderGridPoints.setValue(25);
        panelOpt.add((Component)labelArrows, new GridBagConstraints(0, 0, 3, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        panelOpt.add((Component)this.optSameLength, new GridBagConstraints(0, 1, 3, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        panelOpt.add((Component)this.optScaleLength, new GridBagConstraints(0, 2, 3, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        panelOpt.add((Component)this.labelGrid, new GridBagConstraints(0, 3, 3, 1, 0.0, 0.0, 17, 0, new Insets(10, 0, 0, 0), 0, 0));
        panelOpt.add((Component)this.sliderGridPoints, new GridBagConstraints(0, 4, 3, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 20, 0), 0, 0));
        panelOpt.add((Component)this.txtYmax, new GridBagConstraints(1, 5, 3, 1, 0.0, 0.0, 17, 0, new Insets(0, 30, 5, 0), 0, 0));
        panelOpt.add((Component)labelArea, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        panelOpt.add((Component)this.txtXmin, new GridBagConstraints(1, 6, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        panelOpt.add((Component)this.txtXmax, new GridBagConstraints(2, 6, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 0), 0, 0));
        panelOpt.add((Component)this.txtYmin, new GridBagConstraints(1, 7, 3, 1, 0.0, 0.0, 17, 0, new Insets(5, 30, 0, 0), 0, 0));
        panelOpt.add((Component)buttonCalc, new GridBagConstraints(0, 8, 3, 1, 0.0, 0.0, 13, 0, new Insets(15, 0, 0, 0), 0, 0));
        return panelOpt;
    }

    private void initComponents() {
        this.setLayout(new BoxLayout(this, 1));
        this.add(this.createPanelComponents());
        this.add(this.createPanelDefine());
    }
}

