/*
 * Decompiled with CFR 0.152.
 */
package uibk.applets.dynamicsystems2d;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import uibk.applets.dynamicsystems2d.AppletDynamicSystems2D;
import uibk.applets.dynamicsystems2d.Messages;
import uibk.mtk.swing.base.DoubleTextField;
import uibk.mtk.swing.base.IntegerTextField;
import uibk.mtk.swing.base.TitledPanel;

public class PanelSolverOptions
extends TitledPanel
implements ActionListener {
    AppletDynamicSystems2D main;
    DoubleTextField textEps;
    IntegerTextField textMaxIterations;
    JCheckBox checkDenseOutput;

    public PanelSolverOptions(AppletDynamicSystems2D main) {
        super(Messages.getString("PanelSolverOptions.0"));
        this.main = main;
        this.initComponents();
    }

    private void applychanges() {
        int maxiter;
        double eps;
        try {
            eps = this.textEps.getValue();
            maxiter = this.textMaxIterations.getValue();
        }
        catch (Exception e) {
            this.main.mathpanel2d.reportError(e);
            return;
        }
        this.main.odesolverAutonom.setTOL(eps);
        this.main.odesolverNonAutonom.setTOL(eps);
        this.main.odesolverAutonom.setMaxSteps(maxiter);
        this.main.odesolverNonAutonom.setMaxSteps(maxiter);
        this.main.odesolverAutonom.enableDenseOutput(this.checkDenseOutput.isSelected());
        this.main.odesolverNonAutonom.enableDenseOutput(this.checkDenseOutput.isSelected());
        this.main.mathpanel2d.reportSuccess(Messages.getString("PanelSolverOptions.1"));
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (event.getActionCommand().equals("applychanges")) {
            this.applychanges();
        }
    }

    void initComponents() {
        this.setLayout(new GridBagLayout());
        this.textEps = new DoubleTextField(10, AppletDynamicSystems2D.MINEPS, null, true, Messages.getString("PanelSolverOptions.3"));
        this.textEps.setActionCommand("applychanges");
        this.textEps.addActionListener(this);
        this.textEps.setToolTipText(Messages.getString("PanelSolverOptions.5"));
        this.textMaxIterations = new IntegerTextField(10, AppletDynamicSystems2D.MINITER, AppletDynamicSystems2D.MAXITER, Messages.getString("PanelSolverOptions.6"));
        this.textMaxIterations.setActionCommand("applychanges");
        this.textMaxIterations.addActionListener(this);
        this.textMaxIterations.setToolTipText(Messages.getString("PanelSolverOptions.8"));
        this.checkDenseOutput = new JCheckBox(Messages.getString("PanelSolverOptions.9"));
        this.textEps.setText(String.valueOf(this.main.odesolverAutonom.getTOL()));
        this.textMaxIterations.setText(String.valueOf(this.main.odesolverAutonom.getMaxSteps()));
        this.checkDenseOutput.setSelected(this.main.odesolverAutonom.isDenseOutputEnabled());
        JButton buttonApply = new JButton(Messages.getString("PanelSolverOptions.10"));
        buttonApply.setActionCommand("applychanges");
        buttonApply.addActionListener(this);
        buttonApply.setToolTipText(Messages.getString("PanelSolverOptions.12"));
        this.add((Component)new JLabel(Messages.getString("PanelSolverOptions.13")), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 0, 0, 0), 0, 0));
        this.add((Component)this.textEps, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.add((Component)new JLabel(Messages.getString("PanelSolverOptions.14")), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 0, 0, 0), 0, 0));
        this.add((Component)this.textMaxIterations, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.add((Component)this.checkDenseOutput, new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        this.add((Component)buttonApply, new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0, 10, 0, new Insets(5, 0, 0, 0), 0, 0));
    }
}

