/*
 * Decompiled with CFR 0.152.
 */
package uibk.applets.dynamicsystems2d;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import uibk.applets.dynamicsystems2d.AppletDynamicSystems2D;
import uibk.applets.dynamicsystems2d.Messages;
import uibk.mtk.draw2d.objects.Graph2D;
import uibk.mtk.math.Interval;
import uibk.mtk.math.functions.ParsedFunction;
import uibk.mtk.math.parsing.ODEParser;
import uibk.mtk.swing.PanelLoadExample;
import uibk.mtk.swing.base.IntervalTextField;
import uibk.mtk.swing.base.MPanel;
import uibk.mtk.swing.base.TitledPanel;

class PanelNonAutonomDGL
extends MPanel
implements ActionListener {
    AppletDynamicSystems2D main;
    JTextField textInitialCondtion;
    JTextField textDGL;
    IntervalTextField textInterval;
    double[] initials;

    public PanelNonAutonomDGL(AppletDynamicSystems2D main) {
        this.main = main;
        this.initComponents();
    }

    private boolean setInitials() {
        ODEParser.InitialCondition ic;
        try {
            ic = ODEParser.parseInitialCondition(this.textInitialCondtion.getText(), 'x', false);
        }
        catch (Exception e) {
            this.main.mathpanel2d.reportError(e);
            return false;
        }
        this.initials = ic.x0;
        if (this.initials.length != 2) {
            this.main.mathpanel2d.reportError(Messages.getString("PanelNonAutonomDGL.0"));
            return false;
        }
        return true;
    }

    private boolean setFunction() {
        try {
            String[] dgl = new String[]{this.textDGL.getText()};
            ParsedFunction f = ODEParser.parse(dgl, AppletDynamicSystems2D.VARSNONAUTO, false);
            this.main.odesolverNonAutonom.setDGL(f);
        }
        catch (Exception e) {
            this.main.mathpanel2d.reportError(Messages.getString("PanelNonAutonomDGL.1"), e);
            return false;
        }
        return true;
    }

    private void addGraph(Vector sol) {
        this.main.graphflow.clear();
        if (sol == null || sol.size() < 1) {
            return;
        }
        Graph2D graph = new Graph2D();
        if (sol.size() > 1) {
            int i = 0;
            while (i < sol.size()) {
                double[] p = (double[])sol.elementAt(i);
                graph.addPoint(p[0], p[1]);
                ++i;
            }
            graph.setColor(AppletDynamicSystems2D.SOLOPLOT);
            this.main.graphflow.addGraph(graph);
            this.main.mathpanel2d.getScene2d().enableRound(true);
            this.main.mathpanel2d.getScene2d().setLimits(graph.getLimits());
            this.main.graphvectorfield.setVisible(false);
            this.main.panelscaleaxes.setEnabled(true);
            this.main.panelscaleaxes.update();
            this.main.calcSolFromClick = false;
        }
    }

    void solveDGL() {
        Interval interval;
        Vector sol = null;
        if (!this.setFunction() || !this.setInitials()) {
            return;
        }
        try {
            interval = this.textInterval.getInterval();
        }
        catch (Exception e) {
            this.main.mathpanel2d.reportError(e.getMessage());
            return;
        }
        this.main.odesolverNonAutonom.setInitialCondition(0.0, this.initials);
        this.main.odesolverNonAutonom.setIntegrationInvervall(interval);
        try {
            sol = this.main.odesolverNonAutonom.solve(null);
        }
        catch (Exception ex) {
            this.main.mathpanel2d.reportError(ex);
            return;
        }
        this.addGraph(sol);
        this.main.mathpanel2d.repaint();
        if (this.main.odesolverNonAutonom.integrationSuccess()) {
            this.main.mathpanel2d.reportSuccess(Messages.getString("PanelNonAutonomDGL.2"));
        } else {
            this.main.mathpanel2d.reportError(Messages.getString("PanelNonAutonomDGL.3"));
        }
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        if (ev.getActionCommand().equals("solve_nonautonnom_dgl")) {
            this.solveDGL();
        }
    }

    void initComponents() {
        this.setLayout(new BoxLayout(this, 1));
        TitledPanel panelsolve = new TitledPanel(Messages.getString("PanelNonAutonomDGL.5"));
        panelsolve.setLayout(new GridBagLayout());
        this.textInitialCondtion = new JTextField(10);
        this.textInitialCondtion.setActionCommand("solve_nonautonnom_dgl");
        this.textInitialCondtion.addActionListener(this);
        this.textInitialCondtion.setToolTipText(Messages.getString("PanelNonAutonomDGL.7"));
        this.textDGL = new JTextField(10);
        this.textDGL.setActionCommand("solve_nonautonnom_dgl");
        this.textDGL.addActionListener(this);
        this.textDGL.setToolTipText(String.valueOf(Messages.getString("PanelNonAutonomDGL.9")) + AppletDynamicSystems2D.VARSNONAUTO[0] + Messages.getString("PanelNonAutonomDGL.10") + AppletDynamicSystems2D.VARSNONAUTO[1] + Messages.getString("PanelNonAutonomDGL.11"));
        this.textInterval = new IntervalTextField(10, Messages.getString("PanelNonAutonomDGL.12"), true);
        this.textInterval.setActionCommand("solve_nonautonnom_dgl");
        this.textInterval.addActionListener(this);
        this.textInterval.setToolTipText(Messages.getString("PanelNonAutonomDGL.14"));
        JLabel labelInitialCondition = new JLabel(Messages.getString("PanelNonAutonomDGL.15"));
        JLabel labelDGL = new JLabel("x'(t)=");
        JLabel labelIntervall = new JLabel(Messages.getString("PanelNonAutonomDGL.17"));
        JButton buttonCalc = new JButton(Messages.getString("PanelNonAutonomDGL.18"));
        buttonCalc.setActionCommand("solve_nonautonnom_dgl");
        buttonCalc.addActionListener(this);
        panelsolve.add((Component)labelDGL, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 0, 0, 0), 0, 0));
        panelsolve.add((Component)this.textDGL, new GridBagConstraints(1, 0, 3, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        panelsolve.add((Component)labelInitialCondition, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 0, 0, 0), 0, 0));
        panelsolve.add((Component)this.textInitialCondtion, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        panelsolve.add((Component)labelIntervall, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 0, 0, 0), 0, 0));
        panelsolve.add((Component)this.textInterval, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        panelsolve.add((Component)buttonCalc, new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0, 10, 0, new Insets(10, 0, 0, 0), 0, 0));
        this.add(panelsolve);
        this.add(this.createPanelLoadExamples());
    }

    MPanel createPanelLoadExamples() {
        String[] options = new String[]{Messages.getString("PanelNonAutonomDGL.20"), Messages.getString("PanelNonAutonomDGL.21")};
        JTextComponent[] textfields = new JTextField[]{this.textDGL, this.textInitialCondtion, this.textInterval};
        String[][] values = new String[][]{{"x", "x(0)=1", "[-2,2]"}, {"t", "x(0)=-1", "[-2,2]"}};
        return new PanelLoadExample(Messages.getString("PanelNonAutonomDGL.28"), Messages.getString("PanelNonAutonomDGL.29"), options, textfields, values);
    }
}

