/*
 * Decompiled with CFR 0.152.
 */
package uibk.applets.dynamicsystems2d;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import uibk.applets.dynamicsystems2d.AppletDynamicSystems2D;
import uibk.applets.dynamicsystems2d.Messages;
import uibk.mtk.draw2d.objects.Graph2D;
import uibk.mtk.math.Interval;
import uibk.mtk.math.functions.ParsedFunction;
import uibk.mtk.math.parsing.ODEParser;
import uibk.mtk.swing.PanelLoadExample;
import uibk.mtk.swing.base.InitialsTextField;
import uibk.mtk.swing.base.IntervalTextField;
import uibk.mtk.swing.base.MPanel;
import uibk.mtk.swing.base.TitledPanel;

class PanelAutonomDGL
extends MPanel
implements ActionListener {
    AppletDynamicSystems2D main;
    InitialsTextField textInitialCondtion;
    JTextField textDGLX;
    JTextField textDGLY;
    IntervalTextField textIntervall;

    public PanelAutonomDGL(AppletDynamicSystems2D main) {
        this.main = main;
        this.initComponents();
    }

    private boolean setFunction() {
        try {
            String[] dgl = new String[]{this.textDGLX.getText(), this.textDGLY.getText()};
            ParsedFunction f = ODEParser.parse(dgl, AppletDynamicSystems2D.VARSAUTO, true);
            this.main.odesolverAutonom.setDGL(f);
        }
        catch (Exception e) {
            this.main.mathpanel2d.reportError(Messages.getString("PanelAutonomDGL.0"), e);
            return false;
        }
        return true;
    }

    private void addGraph(Vector sol) {
        this.main.graphflow.clear();
        if (sol == null || sol.size() < 1) {
            return;
        }
        Graph2D graph = new Graph2D();
        if (sol.size() > 1) {
            int i = 0;
            while (i < sol.size()) {
                double[] p = (double[])sol.elementAt(i);
                graph.addPoint(p[0], p[1]);
                ++i;
            }
            graph.setColor(AppletDynamicSystems2D.SOLOPLOT);
            this.main.graphflow.addGraph(graph);
            this.main.mathpanel2d.getScene2d().enableRound(true);
            this.main.mathpanel2d.getScene2d().setLimits(graph.getLimits());
            this.main.graphvectorfield.setVisible(false);
            this.main.panelscaleaxes.setEnabled(true);
            this.main.panelscaleaxes.update();
            this.main.calcSolFromClick = false;
        }
    }

    void solveDGL() {
        Interval interval;
        double[] initials;
        Vector sol = null;
        if (!this.setFunction()) {
            return;
        }
        try {
            initials = this.textInitialCondtion.getValues();
            interval = this.textIntervall.getInterval();
        }
        catch (Exception e) {
            this.main.mathpanel2d.reportError(e.getMessage());
            return;
        }
        if (initials.length != 2) {
            this.main.mathpanel2d.reportError(Messages.getString("PanelAutonomDGL.1"));
            return;
        }
        this.main.odesolverAutonom.setInitialCondition(0.0, initials);
        this.main.odesolverAutonom.setIntegrationInvervall(interval);
        try {
            sol = this.main.odesolverAutonom.solve(null);
        }
        catch (Exception ex) {
            this.main.mathpanel2d.reportError(ex);
            return;
        }
        this.addGraph(sol);
        this.main.mathpanel2d.repaint();
        if (this.main.odesolverAutonom.integrationSuccess()) {
            this.main.mathpanel2d.reportSuccess(Messages.getString("PanelAutonomDGL.2"));
        } else {
            this.main.mathpanel2d.reportError(Messages.getString("PanelAutonomDGL.3"));
        }
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        if (ev.getActionCommand().equals("solve_autonnom_dgl")) {
            this.solveDGL();
        }
    }

    void initComponents() {
        TitledPanel panelsolve = new TitledPanel(Messages.getString("PanelAutonomDGL.5"));
        panelsolve.setLayout(new GridBagLayout());
        this.setLayout(new BoxLayout(this, 1));
        this.textInitialCondtion = new InitialsTextField(10, true, Messages.getString("PanelAutonomDGL.6"));
        this.textInitialCondtion.setActionCommand("solve_autonnom_dgl");
        this.textInitialCondtion.addActionListener(this);
        this.textInitialCondtion.setToolTipText(Messages.getString("PanelAutonomDGL.8"));
        this.textDGLX = new JTextField(10);
        this.textDGLX.setActionCommand("solve_autonnom_dgl");
        this.textDGLX.addActionListener(this);
        this.textDGLX.setToolTipText(Messages.getString("PanelAutonomDGL.10"));
        this.textDGLY = new JTextField(10);
        this.textDGLY.setActionCommand("solve_autonnom_dgl");
        this.textDGLY.addActionListener(this);
        this.textDGLY.setToolTipText(Messages.getString("PanelAutonomDGL.12"));
        this.textIntervall = new IntervalTextField(10, Messages.getString("PanelAutonomDGL.13"), true);
        this.textIntervall.setActionCommand("solve_autonnom_dgl");
        this.textIntervall.addActionListener(this);
        this.textIntervall.setToolTipText(Messages.getString("PanelAutonomDGL.15"));
        JButton jButtonCalc = new JButton(Messages.getString("PanelAutonomDGL.16"));
        jButtonCalc.setActionCommand("solve_autonnom_dgl");
        jButtonCalc.addActionListener(this);
        panelsolve.add((Component)new JLabel("x'="), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 0, 0, 0), 0, 0));
        panelsolve.add((Component)this.textDGLX, new GridBagConstraints(1, 0, 3, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        panelsolve.add((Component)new JLabel("y'="), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 0, 0, 0), 0, 0));
        panelsolve.add((Component)this.textDGLY, new GridBagConstraints(1, 1, 3, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        panelsolve.add((Component)new JLabel("(x(0),y(0))="), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 0, 0, 0), 0, 0));
        panelsolve.add((Component)this.textInitialCondtion, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        panelsolve.add((Component)new JLabel(Messages.getString("PanelAutonomDGL.21")), new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 0, 0, 0), 0, 0));
        panelsolve.add((Component)this.textIntervall, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        panelsolve.add((Component)jButtonCalc, new GridBagConstraints(0, 4, 2, 1, 0.0, 0.0, 10, 0, new Insets(10, 0, 0, 0), 0, 0));
        this.add(panelsolve);
        this.add(this.createPanelLoadExamples());
    }

    MPanel createPanelLoadExamples() {
        String[] options = new String[]{Messages.getString("PanelAutonomDGL.22"), Messages.getString("PanelAutonomDGL.23")};
        JTextComponent[] textfields = new JTextField[]{this.textDGLX, this.textDGLY, this.textInitialCondtion, this.textIntervall};
        String[][] values = new String[][]{{"y", "-x", "(0,1)", "[0,2*pi]"}, {"y+x/5", "-x", "(0,1)", "[0,25]"}};
        return new PanelLoadExample(Messages.getString("PanelAutonomDGL.32"), Messages.getString("PanelAutonomDGL.33"), options, textfields, values);
    }
}

