/*
 * Decompiled with CFR 0.152.
 */
package uibk.applets.dynamicsystems2d;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.Vector;
import javax.swing.SwingUtilities;
import uibk.applets.dynamicsystems2d.AppletDynamicSystems2D;
import uibk.applets.dynamicsystems2d.Messages;
import uibk.mtk.draw2d.objects.GraphSplitter2D;
import uibk.mtk.math.Interval;
import uibk.mtk.math.functions.ParsedFunction;
import uibk.mtk.math.parsing.ODEParser;

class MyMouseListener
extends MouseAdapter
implements MouseMotionListener {
    AppletDynamicSystems2D main;

    public MyMouseListener(AppletDynamicSystems2D main) {
        this.main = main;
    }

    @Override
    public void mousePressed(MouseEvent event) {
        if (SwingUtilities.isLeftMouseButton(event) && this.main.calcSolFromClick && this.main.mathpanel2d.isPointInCoordsArea(event.getPoint())) {
            this.main.mathpanel2d.getScene2d().enableRound(false);
            Vector sol = null;
            double[] initials = new double[]{this.main.mathpanel2d.getScene2d().pixelToX(event.getX()), this.main.mathpanel2d.getScene2d().pixelToY(event.getY())};
            if (!this.setFunction()) {
                return;
            }
            double r = Math.max(this.main.mathpanel2d.getScene2d().getXRange(), this.main.mathpanel2d.getScene2d().getYRange()) * 10.0;
            this.main.odesolverAutonom.setIntegrationInvervall(new Interval(-r, r));
            this.main.odesolverAutonom.setInitialCondition(0.0, initials);
            try {
                sol = this.main.odesolverAutonom.solve(null);
            }
            catch (Exception ex) {
                this.main.mathpanel2d.reportError(ex);
                return;
            }
            GraphSplitter2D.splitgraph(sol, this.main.graphflow, this.main.mathpanel2d.getScene2d().getCoordinates());
            this.main.panelscaleaxes.setEnabled(false);
            this.main.graphvectorfield.setColor(AppletDynamicSystems2D.COLORVECTORFIELDLIGHT);
            this.main.mathpanel2d.reportSuccess(Messages.getString("MyMouseListener.0"));
            this.main.mathpanel2d.repaint();
        }
    }

    private boolean setFunction() {
        try {
            String[] dgl = new String[]{this.main.panelvectorfield.txtKomponenteX.getText(), this.main.panelvectorfield.txtKomponenteY.getText()};
            ParsedFunction f = ODEParser.parse(dgl, AppletDynamicSystems2D.VARSAUTO, true);
            this.main.odesolverAutonom.setDGL(f);
        }
        catch (Exception e) {
            this.main.mathpanel2d.reportError(Messages.getString("MyMouseListener.1"), e);
            return false;
        }
        return true;
    }

    @Override
    public void mouseMoved(MouseEvent event) {
        if (this.main.calcSolFromClick && this.main.mathpanel2d.isPointInCoordsArea(event.getPoint())) {
            String str = "(" + this.main.mathpanel2d.getScene2d().pixelToX(event.getX()) + "," + this.main.mathpanel2d.getScene2d().pixelToY(event.getY()) + ")";
            this.main.mathpanel2d.report(str);
        }
    }

    @Override
    public void mouseDragged(MouseEvent event) {
    }
}

