/*
 * Decompiled with CFR 0.152.
 */
package uibk.mtk.swing.datatable;

import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.Vector;
import javax.swing.JTable;
import uibk.mtk.swing.datatable.MyAbstractTableModel;
import uibk.mtk.swing.datatable.TableModelWithRowIndex;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataTable
extends JTable {
    MyAbstractTableModel tm;

    public DataTable(double[][] data) {
        super(new TableModelWithRowIndex(data));
        this.tm = (TableModelWithRowIndex)this.dataModel;
    }

    public DataTable(int rows, int cols) {
        super(new TableModelWithRowIndex(rows, cols));
        this.tm = (TableModelWithRowIndex)this.dataModel;
    }

    public DataTable() {
        this((double[][])null);
    }

    public DataTable(MyAbstractTableModel tableModel) {
        super(tableModel);
        this.tm = tableModel;
    }

    public void scrollToLastLine() {
        if (this.getRowCount() >= 1) {
            this.setRowSelectionInterval(this.getRowCount() - 1, this.getRowCount() - 1);
            Rectangle rect = this.getCellRect(this.getRowCount(), 0, true);
            this.scrollRectToVisible(rect);
        }
    }

    public void cleardata() {
        this.tm.cleardata();
    }

    public DataTable(String[] labels) {
        this(0, labels.length);
        this.tm.setColumnNames(labels);
        this.tm.fireTableStructureChanged();
    }

    public DataTable(double[][] data, String[] labels) {
        this(data);
        this.tm.setColumnNames(labels);
        this.tm.fireTableStructureChanged();
    }

    public void setData(double[][] data) {
        this.tm.setData(data);
    }

    public void setData(double[][] data, String[] labels) {
        if (labels.length != data.length) {
            throw new IllegalArgumentException("");
        }
        this.tm.setColumnNames(labels);
        this.tm.setData(data);
    }

    public void setData(Vector<Double[]> data, String[] labels) {
        if (data == null || data.size() == 0) {
            throw new IllegalArgumentException("Keine Daten vorhanden");
        }
        if (labels.length != data.firstElement().length) {
            throw new IllegalArgumentException("");
        }
        this.tm.setColumnNames(labels);
        this.tm.setData(data);
    }

    public void add(double[] data) {
        Object[] dd = new Double[data.length];
        int i = 0;
        while (i < data.length) {
            dd[i] = new Double(data[i]);
            ++i;
        }
        this.tm.datagrid.addrow(dd);
    }

    public void create(int rows, int cols) {
        String[] newlables = new String[cols];
        int i = 0;
        while (i < cols) {
            newlables[i] = "x" + (i + 1);
            ++i;
        }
        this.tm.setColumnNames(newlables);
        this.tm.create(rows, cols);
    }

    public double[][] getData() {
        int m = this.tm.getRowCount();
        int n = this.tm.getColumnCount();
        double[][] data = new double[n][m];
        int i = 0;
        while (i < m) {
            int j = 0;
            while (j < n) {
                data[j][i] = (Double)this.tm.getValueAt(i, j);
                ++j;
            }
            ++i;
        }
        return data;
    }

    public Vector getDataVector() {
        return this.tm.datagrid.getValue();
    }

    public String[] getLabel() {
        return this.tm.getColumnNames();
    }

    public double[][] getDataCols(int[] cols) {
        int m = this.tm.getRowCount();
        int n = cols.length;
        double[][] data = new double[n][m];
        int i = 0;
        while (i < m) {
            int j = 0;
            while (j < n) {
                data[j][i] = (Double)this.tm.getValueAt(i, cols[j]);
                ++j;
            }
            ++i;
        }
        return data;
    }

    public double[] getDataCol(int col) {
        int m = this.tm.getRowCount();
        double[] data = new double[m];
        int i = 0;
        while (i < m) {
            data[i] = (Double)this.tm.getValueAt(i, col);
            ++i;
        }
        return data;
    }

    public boolean isEmpty() {
        return this.tm.datagrid.isEmpty();
    }

    public boolean isComplete() {
        return this.tm.datagrid.isComplete();
    }

    public void setColumnWidthFromLabels() {
        this.setAutoResizeMode(0);
        Graphics g = this.getGraphics();
        if (g == null || this.tm.getColumnName(0) == null) {
            return;
        }
        FontMetrics metrics = g.getFontMetrics();
        int i = 0;
        while (i < this.getColumnCount()) {
            String str = this.tm.getColumnName(i);
            this.getColumn(this.getColumnName(i)).setPreferredWidth(metrics.stringWidth(str) + 20);
            ++i;
        }
    }
}

