/*
 * Decompiled with CFR 0.152.
 */
package uibk.mtk.math.regression;

import uibk.mtk.lang.InputException;
import uibk.mtk.math.MathUtil;
import uibk.mtk.math.functions.ParsedFunction1D;
import uibk.mtk.math.integration.GaussIntegration;
import uibk.mtk.math.parsing.Function1DParser;

public class TStatisik {
    private final double n;
    private final double value;
    public static final int GAUSS_STEPS = 5;
    public static final int GAUSS_SUBDIVISIONS = 30;

    public TStatisik(int n, double value) {
        this.n = n;
        this.value = value;
    }

    public double getValue() {
        return this.value;
    }

    public double getpValue() throws InputException {
        double d = MathUtil.gamma((this.n + 1.0) / 2.0) / (Math.sqrt(this.n * Math.PI) * MathUtil.gamma(this.n / 2.0));
        String fun = "( 1 + x^2 / " + this.n + ")^(-" + (this.n + 1.0) / 2.0 + ")";
        GaussIntegration integrator = new GaussIntegration();
        ParsedFunction1D f = Function1DParser.parse("x", fun);
        return 1.0 - d * integrator.quadrature(f, -Math.abs(this.value), Math.abs(this.value), 5, 30);
    }
}

