/*
 * Decompiled with CFR 0.152.
 */
package uibk.mtk.math.regression;

import uibk.mtk.lang.InputException;
import uibk.mtk.lang.Messages;
import uibk.mtk.math.functions.Function;
import uibk.mtk.math.functions.ParsedFunction;
import uibk.mtk.math.parsing.FunctionParser;
import uibk.mtk.math.regression.FormFunctionRegression;

public final class RegressionCreator {
    private static final String BUNDLE_NAME = "uibk.mtk.math.regression.messages";

    private RegressionCreator() {
    }

    public static FormFunctionRegression create(String[] formfunctions, String[] variables) throws Exception {
        if (variables == null || variables.length == 0) {
            throw new InputException(Messages.getString(BUNDLE_NAME, "RegressionCreator.0"));
        }
        if (formfunctions == null || formfunctions.length == 0) {
            throw new InputException(Messages.getString(BUNDLE_NAME, "RegressionCreator.1"));
        }
        int nvars = variables.length;
        int k = formfunctions.length;
        Function[] functions = new Function[k];
        int i = 0;
        while (i < k) {
            ParsedFunction f = FunctionParser.parseFunction(variables, new String[]{formfunctions[i]});
            functions[i] = f;
            ++i;
        }
        return new FormFunctionRegression(nvars, functions);
    }
}

