/*
 * Decompiled with CFR 0.152.
 */
package uibk.mtk.math.regression;

import Jama.Matrix;
import Jama.QRDecomposition;
import uibk.mtk.lang.Messages;
import uibk.mtk.math.regression.FStatisik;
import uibk.mtk.math.regression.TStatisik;

public class Regression {
    private static final String BUNDLE_NAME = "uibk.mtk.math.regression.messages";
    Matrix X;
    Matrix Y;
    private Matrix Yhat = null;
    private Matrix Res = null;
    Matrix beta;
    private double rsquare;
    private Double sse = null;
    private Double ssr = null;
    private Double syy = null;
    protected int k;
    protected int n;
    private Double standardError = null;
    private double[] standadErrorKoeff = null;
    QRDecomposition qr;

    public Regression(int k) {
        this.k = k;
    }

    public Matrix getDataMatrix() {
        return this.X.copy();
    }

    public double[] getDependentVariable() {
        return this.Y.getColumnPackedCopy();
    }

    public void setDataMatrix(Matrix data) throws Exception {
        this.setDataMatrix(data.transpose().getArray());
    }

    public void setDataMatrix(double[][] data) throws Exception {
        this.Yhat = null;
        this.Res = null;
        this.sse = null;
        this.ssr = null;
        this.syy = null;
        this.standardError = null;
        this.standadErrorKoeff = null;
        if (data == null) {
            throw new IllegalArgumentException(Messages.getString(BUNDLE_NAME, "Regression.0"));
        }
        int rows = 0;
        int i = 0;
        while (i < data.length) {
            if (data[i] == null) {
                throw new IllegalArgumentException(Messages.getString(BUNDLE_NAME, "Regression.1"));
            }
            if (i == 0) {
                rows = data[0].length;
            } else if (rows != data[i].length) {
                throw new IllegalArgumentException(Messages.getString(BUNDLE_NAME, "Regression.2"));
            }
            ++i;
        }
        this.n = rows;
        this.X = this.setupRegressionMatrix(data);
        i = 0;
        while (i < this.X.getRowDimension()) {
            int j = 0;
            while (j < this.X.getColumnDimension()) {
                if (Double.isInfinite(this.X.get(i, j)) || Double.isNaN(this.X.get(i, j))) {
                    throw new Exception(Messages.getString(BUNDLE_NAME, "Regression.3"));
                }
                ++j;
            }
            ++i;
        }
        if (this.X.rank() != this.X.getColumnDimension()) {
            this.qr = null;
            throw new Exception(Messages.getString(BUNDLE_NAME, "Regression.4"));
        }
        this.qr = new QRDecomposition(this.X);
    }

    public void regress(double[] y) {
        if (y.length != this.X.getRowDimension()) {
            throw new IllegalArgumentException(Messages.getString(BUNDLE_NAME, "Regression.5"));
        }
        if (this.qr == null) {
            throw new IllegalStateException("");
        }
        this.n = y.length;
        this.Y = new Matrix(y, this.n);
        int i = 0;
        while (i < this.n) {
            this.Y.set(i, 0, y[i]);
            ++i;
        }
        this.beta = this.qr.solve(this.Y);
        this.Yhat = this.X.times(this.beta);
        this.Res = this.Y.minus(this.Yhat);
        this.calcAnova();
        this.standardError = Math.sqrt(this.sse / (double)(this.n - this.k - 1));
        this.standadErrorKoeff = new double[this.beta.getRowDimension()];
        Matrix R = this.qr.getR();
        Matrix M = R.transpose().times(R).inverse();
        int i2 = 0;
        while (i2 < this.beta.getRowDimension()) {
            this.standadErrorKoeff[i2] = this.standardError * Math.sqrt(M.get(i2, i2));
            ++i2;
        }
    }

    protected Matrix setupRegressionMatrix(double[][] data) {
        Matrix temp = new Matrix(this.n, this.k + 1);
        int i = 0;
        while (i < this.n) {
            temp.set(i, 0, 1.0);
            ++i;
        }
        i = 0;
        while (i < this.n) {
            int j = 0;
            while (j < this.k) {
                temp.set(i, j + 1, data[j][i]);
                ++j;
            }
            ++i;
        }
        return temp;
    }

    private double getYQuer() {
        double sum = 0.0;
        int i = 0;
        while (i < this.n) {
            sum += this.Y.get(i, 0);
            ++i;
        }
        return sum /= (double)this.n;
    }

    private void calcSSR() {
        double t1 = this.beta.transpose().times(this.X.transpose()).times(this.Y).get(0, 0);
        double yquer = this.getYQuer();
        this.ssr = t1 - (double)this.n * yquer * yquer;
    }

    private void calcAnova() {
        this.calcSSE();
        this.calcSSR();
        this.syy = this.ssr + this.sse;
        this.rsquare = this.ssr / this.syy;
    }

    private void calcSSE() {
        double t1 = this.Y.transpose().times(this.Y).get(0, 0);
        double t2 = this.beta.transpose().times(this.X.transpose()).times(this.Y).get(0, 0);
        this.sse = t1 - t2;
    }

    public double getSSR() {
        return this.ssr;
    }

    public double getSSY() {
        return this.syy;
    }

    public double getSSE() {
        return this.sse;
    }

    public double getrsquare() {
        return this.rsquare;
    }

    public double[] getCoefficients() {
        if (this.beta == null) {
            return null;
        }
        double[] coeff = new double[this.k + 1];
        int i = 0;
        while (i < this.k + 1) {
            coeff[i] = this.beta.get(i, 0);
            ++i;
        }
        return coeff;
    }

    public int getNumberDataSets() {
        return this.n;
    }

    public int getNumberVars() {
        return this.k;
    }

    public double[] getSchaetzwerte() {
        if (this.Yhat == null) {
            return null;
        }
        double[] yhat = new double[this.n];
        int i = 0;
        while (i < this.n) {
            yhat[i] = this.Yhat.get(i, 0);
            ++i;
        }
        return yhat;
    }

    public double[] getResiduen() {
        if (this.Res == null) {
            return null;
        }
        double[] res = new double[this.n];
        int i = 0;
        while (i < this.n) {
            res[i] = this.Res.get(i, 0);
            ++i;
        }
        return res;
    }

    public Double getStandadError() {
        return this.standardError;
    }

    public double[] getStandadErrorKoeff() {
        if (this.standadErrorKoeff == null) {
            return null;
        }
        return this.standadErrorKoeff;
    }

    public FStatisik getFstatistik() {
        if (this.ssr == null || this.sse == null) {
            return null;
        }
        return new FStatisik(this.k, this.n - (this.k + 1), this.ssr / (double)this.k / (this.sse / (double)(this.n - (this.k + 1))));
    }

    public TStatisik[] getTstatistik() {
        if (this.standadErrorKoeff == null || this.beta == null) {
            return null;
        }
        TStatisik[] tStat = new TStatisik[this.standadErrorKoeff.length];
        int i = 0;
        while (i < this.standadErrorKoeff.length) {
            tStat[i] = new TStatisik(this.n - 1, this.beta.get(i, 0) / this.standadErrorKoeff[i]);
            ++i;
        }
        return tStat;
    }
}

