/*
 * Decompiled with CFR 0.152.
 */
package uibk.mtk.math.regression;

import java.util.Arrays;

class IntegerSet {
    private int[] data;

    public IntegerSet(int[] a) {
        this.data = (int[])a.clone();
        Arrays.sort(this.data);
    }

    public IntegerSet(int[] a, int n) {
        if (n < 1) {
            throw new IllegalArgumentException("");
        }
        this.data = new int[n];
        System.arraycopy(a, 0, this.data, 0, n);
        Arrays.sort(this.data);
    }

    public int hashCode() {
        int n = this.data.length;
        int hash = 0;
        int i = 0;
        while (i < n) {
            hash = 31 * hash + this.data[i];
            ++i;
        }
        return hash;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof IntegerSet)) {
            return false;
        }
        int[] a = ((IntegerSet)obj).data;
        int n = a.length;
        if (this.data.length != n) {
            return false;
        }
        int i = 0;
        while (i < n) {
            if (a[i] != this.data[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public String toString() {
        String s = "{";
        int i = 0;
        while (i < this.data.length) {
            s = String.valueOf(s) + this.data[i];
            if (i < this.data.length - 1) {
                s = String.valueOf(s) + ",";
            }
            ++i;
        }
        s = String.valueOf(s) + "}";
        return s;
    }

    public int[] getData() {
        return (int[])this.data.clone();
    }
}

