/*
 * Decompiled with CFR 0.152.
 */
package uibk.mtk.math.regression;

import uibk.mtk.lang.InputException;
import uibk.mtk.math.Interval;
import uibk.mtk.math.MathUtil;
import uibk.mtk.math.functions.ParsedFunction1D;
import uibk.mtk.math.integration.GaussIntegration;
import uibk.mtk.math.parsing.Function1DParser;

public class FStatisik {
    private final double n1;
    private final double n2;
    private final double value;
    public static final int GAUSS_STEPS = 5;
    public static final int GAUSS_SUBDIVISIONS = 30;

    public FStatisik(int n1, int n2, double value) {
        this.n1 = n1;
        this.n2 = n2;
        this.value = value;
    }

    public double getValue() {
        return this.value;
    }

    public double getpValue() throws InputException {
        double t1 = Math.pow(this.n1, this.n1 / 2.0) * MathUtil.gamma(this.n1 / 2.0 + this.n2 / 2.0) / (MathUtil.gamma(this.n1 / 2.0) * MathUtil.gamma(this.n2 / 2.0));
        double t2 = Math.pow(this.n2, -this.n1 / 2.0);
        String fun = String.valueOf(t2) + "*x^(" + (this.n1 / 2.0 - 1.0) + ")/ (x * " + this.n1 / this.n2 + "+" + 1 + ")^" + (this.n1 + this.n2) / 2.0;
        ParsedFunction1D f = Function1DParser.parse("x", fun);
        Interval inter = new Interval(0.0, 1.0);
        double I = 0.0;
        GaussIntegration integrator = new GaussIntegration();
        if (this.n1 == 1.0) {
            if (this.value > 0.01) {
                inter.b = 0.01;
            }
            double alpha = -(this.n1 + this.n2) / 2.0;
            I = t2 * (2.0 * Math.sqrt(inter.b) + 0.6666666666666666 * alpha / this.n2 * Math.pow(inter.b, 1.5) + 0.4 * alpha * (alpha - 1.0) / (2.0 * this.n2 * this.n2) * Math.pow(inter.b, 2.5));
            inter.a = 0.01;
            inter.b = 1.0;
        }
        double i = 1.0;
        while (i < this.value * 10.0) {
            inter.b = i > this.value ? this.value : i;
            double tmp = integrator.quadrature(f, inter.a, inter.b, 5, 30);
            I += tmp;
            inter.a = inter.b;
            if (tmp < 1.0E-4) break;
            i *= 10.0;
        }
        return 1.0 - t1 * I;
    }

    public double getN1() {
        return this.n1;
    }

    public double getN2() {
        return this.n2;
    }
}

