/*
 * Decompiled with CFR 0.152.
 */
package uibk.applets.regression;

import Jama.Matrix;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import uibk.applets.regression.AppletRegression;
import uibk.applets.regression.Control;
import uibk.mtk.draw2d.objects.MathPoint2D;
import uibk.mtk.geom.geom2d.CoordinateRect2D;
import uibk.mtk.geom.geom2d.Punkt2D;
import uibk.mtk.lang.Messages;
import uibk.mtk.math.Rounder;
import uibk.mtk.math.functions.Function;
import uibk.mtk.math.regression.FormFunctionRegression;
import uibk.mtk.math.regression.RegressionCreator;
import uibk.mtk.swing.base.MPanel;
import uibk.mtk.swing.base.TitledPanel;
import uibk.mtk.util.IntervalIterator;

public class PanelPlot
extends MPanel
implements ListSelectionListener,
ActionListener {
    private final AppletRegression main;
    private JList[] dataList = new JList[2];
    private final int[] independentvarsindex;
    private final String[] formfunctions;
    private String[] actionCommando;
    private Vector points = null;
    private int columnIndexX = -1;
    private int columnIndexY = -1;
    private final Control control;
    private int indexResiduen = 0;
    private int indexSchaetzwerte = 0;

    public PanelPlot(AppletRegression main, Control control, int dependentvarindex, int[] independentvarsindex, String[] formfunctions) {
        this.main = main;
        this.independentvarsindex = independentvarsindex;
        this.formfunctions = formfunctions;
        this.control = control;
        main.mathpanel2d.setVisible(false);
        this.setLayout(new BorderLayout());
        this.add((Component)this.initComponents(dependentvarindex, independentvarsindex), "North");
        this.add(Box.createVerticalGlue(), "Center");
        main.mathpanel2d.removeAllDragListener();
        main.mathpanel2d.addDragListener(this);
        this.dataList[0].setSelectedIndex(this.indexSchaetzwerte);
        this.dataList[1].setSelectedIndex(this.indexResiduen);
    }

    private MPanel initComponents(int dependentvarindex, int[] independentvarsindex) {
        MPanel panel = new MPanel();
        panel.setLayout(new GridLayout(2, 1));
        Vector<String> vectorFormFun = new Vector<String>();
        Vector<Integer> vectorIndexFormFun = new Vector<Integer>();
        int i = 0;
        while (i < this.formfunctions.length) {
            boolean formFunFound = true;
            int j = 0;
            while (j < independentvarsindex.length) {
                if (this.formfunctions[i].equals("x" + independentvarsindex[j])) {
                    formFunFound = false;
                    break;
                }
                ++j;
            }
            if (formFunFound) {
                vectorFormFun.add(this.formfunctions[i]);
                vectorIndexFormFun.add(i);
            }
            ++i;
        }
        int anzFormFun = vectorFormFun.size() == 0 ? 0 : vectorFormFun.size() + 1;
        int anz = 2 + independentvarsindex.length + 1 + 2 + 1 + anzFormFun;
        int i2 = 0;
        String[] var = new String[anz];
        this.actionCommando = new String[anz];
        this.actionCommando[i2] = "D" + dependentvarindex + "x" + dependentvarindex;
        var[i2++] = this.main.table.getLabel()[dependentvarindex - 1];
        this.actionCommando[i2] = "N0";
        var[i2++] = this.trenner(20);
        while (i2 < independentvarsindex.length + 2) {
            var[i2] = this.main.table.getLabel()[independentvarsindex[i2 - 2] - 1];
            this.actionCommando[i2] = "I" + (i2 - 2) + "x" + independentvarsindex[i2 - 2];
            ++i2;
        }
        this.actionCommando[i2] = "N0";
        var[i2++] = this.trenner(20);
        int j = 0;
        for (String formFun : vectorFormFun) {
            this.actionCommando[i2] = "F" + vectorIndexFormFun.get(j++) + formFun;
            var[i2++] = formFun;
        }
        if (anzFormFun > 0) {
            this.actionCommando[i2] = "N0";
            var[i2++] = this.trenner(20);
        }
        this.actionCommando[i2] = "R0" + Messages.getString("uibk.applets.regression.messages", "PanelPlot.10");
        this.indexResiduen = i2;
        var[i2++] = Messages.getString("uibk.applets.regression.messages", "PanelPlot.10");
        this.actionCommando[i2] = "N0";
        var[i2++] = this.trenner(20);
        this.actionCommando[i2] = "S0" + Messages.getString("uibk.applets.regression.messages", "PanelPlot.11");
        this.indexSchaetzwerte = i2;
        var[i2++] = Messages.getString("uibk.applets.regression.messages", "PanelPlot.11");
        panel.add(this.createAxis(dependentvarindex, independentvarsindex, Messages.getString("uibk.applets.regression.messages", "PanelPlot.1"), 0, var));
        panel.add(this.createAxis(dependentvarindex, independentvarsindex, Messages.getString("uibk.applets.regression.messages", "PanelPlot.2"), 1, var));
        return panel;
    }

    private String trenner(int i) {
        String ret = "";
        int j = 0;
        while (j < i) {
            ret = String.valueOf(ret) + "-";
            ++j;
        }
        return ret;
    }

    private TitledPanel createAxis(int dependentvarindex, int[] independentvarsindex, String title, int actionIndex, String[] var) {
        TitledPanel panel = new TitledPanel(title);
        this.dataList[actionIndex] = new JList<String>(var);
        this.dataList[actionIndex].addListSelectionListener(this);
        this.dataList[actionIndex].setLayoutOrientation(2);
        this.dataList[actionIndex].setVisibleRowCount(-1);
        this.dataList[actionIndex].setSelectionMode(0);
        JScrollPane listScroller = new JScrollPane(this.dataList[actionIndex]);
        listScroller.setPreferredSize(new Dimension(120, 170));
        panel.add(listScroller);
        return panel;
    }

    private void plot(Type xSelection, Type ySelection, int xIndex, int yIndex, String xBez, String yBez) throws Exception {
        this.main.pointplot.clearpoints();
        this.main.graph2d.clearpoints();
        this.main.mathpanel2d.setVisible(true);
        this.main.graph2d.setVisible(false);
        this.main.mathpanel2d.setListenForDragAndDrop(true);
        double[][] x = new double[1][];
        double[] y = new double[1];
        boolean plotRegX = false;
        boolean plotRegY = false;
        boolean dragAbleX = false;
        boolean dragAbleY = false;
        switch (xSelection) {
            case D: {
                x[0] = this.main.table.getDataCol(xIndex);
                plotRegX = true;
                if (!ySelection.equals((Object)Type.D)) {
                    dragAbleX = true;
                }
                this.columnIndexX = xIndex;
                break;
            }
            case I: {
                if (xIndex < 0 || xIndex > this.independentvarsindex.length) {
                    return;
                }
                x[0] = this.main.table.getDataCol(this.independentvarsindex[xIndex]);
                plotRegX = true;
                dragAbleX = !ySelection.equals((Object)Type.I) || this.independentvarsindex[xIndex] != this.independentvarsindex[yIndex];
                this.columnIndexX = this.independentvarsindex[xIndex];
                break;
            }
            case F: {
                plotRegX = true;
                x[0] = this.getTransformedData(xIndex);
                break;
            }
            case R: {
                x[0] = this.main.regression.getResiduen();
                break;
            }
            case S: {
                x[0] = this.main.regression.getSchaetzwerte();
                break;
            }
            default: {
                return;
            }
        }
        switch (ySelection) {
            case D: {
                y = this.main.table.getDataCol(yIndex);
                this.columnIndexY = yIndex;
                plotRegY = true;
                if (xSelection.equals((Object)Type.D)) break;
                dragAbleY = true;
                break;
            }
            case I: {
                if (yIndex < 0 || yIndex > this.independentvarsindex.length) {
                    return;
                }
                y = this.main.table.getDataCol(this.independentvarsindex[yIndex]);
                this.columnIndexY = this.independentvarsindex[yIndex];
                plotRegY = true;
                if (xSelection.equals((Object)Type.I) && this.independentvarsindex[xIndex] == this.independentvarsindex[yIndex]) {
                    dragAbleY = false;
                    break;
                }
                dragAbleY = true;
                break;
            }
            case F: {
                plotRegY = true;
                y = this.getTransformedData(yIndex);
                break;
            }
            case R: {
                y = this.main.regression.getResiduen();
                break;
            }
            case S: {
                y = this.main.regression.getSchaetzwerte();
                break;
            }
            default: {
                return;
            }
        }
        this.points = this.main.pointplot.setPoints(x[0], y);
        CoordinateRect2D limits1 = this.main.pointplot.getLimits();
        CoordinateRect2D limits2 = this.main.pointplot.getLimits();
        if (plotRegX && plotRegY) {
            limits2 = this.regression(x, y);
        }
        if (dragAbleX && dragAbleY) {
            this.main.pointplot.enabledrag(true);
            this.main.pointplot.setColor(new Color(0, 100, 0));
            this.main.pointplot.setPointRadius(3);
        } else {
            this.points = null;
            this.main.pointplot.enabledrag(false);
            this.main.pointplot.setColor(Color.RED);
            this.main.pointplot.setPointRadius(2);
            this.columnIndexX = -1;
            this.columnIndexY = -1;
        }
        this.main.mathpanel2d.getScene2d().setLimits(limits1.combine(limits2));
        this.main.pointplot.setVisible(true);
        this.main.axes.setCaptionXAxis(xBez);
        this.main.axes.setCaptionYAxis(yBez);
        this.main.mathpanel2d.repaint();
    }

    private double[] getTransformedData(int index) throws Exception {
        Matrix data = this.main.regression.getDataMatrix();
        double[] ret = new double[data.getRowDimension()];
        int i = 0;
        while (i < ret.length) {
            ret[i] = data.get(i, index + 1);
            ++i;
        }
        return ret;
    }

    private CoordinateRect2D regression(double[][] x, double[] y) throws Exception {
        String[] formfunctions = new String[]{"t"};
        String[] variables = new String[]{"t"};
        FormFunctionRegression reg = RegressionCreator.create(formfunctions, variables);
        reg.setDataMatrix(x);
        reg.regress(y);
        double[] dummy = (double[])x[0].clone();
        Arrays.sort(dummy);
        double min = dummy[0];
        double max = dummy[x[0].length - 1];
        Function f = reg.getPredictionFunction();
        double[] temp = new double[1];
        Vector<Punkt2D> v = new Vector<Punkt2D>();
        IntervalIterator it = new IntervalIterator(min, max, 300);
        while (it.hasNext()) {
            double t;
            temp[0] = t = it.nextdouble();
            v.add(new Punkt2D(t, f.getValue(temp)[0]));
        }
        this.main.graph2d.setPoints(v);
        CoordinateRect2D limits = this.main.graph2d.getLimits();
        this.main.graph2d.setColor(AppletRegression.PLOTCOLOR);
        this.main.graph2d.setVisible(true);
        return limits;
    }

    public void valueChanged(ListSelectionEvent e) {
        try {
            if (this.dataList[0].getSelectedIndex() >= 0 && this.dataList[1].getSelectedIndex() >= 0) {
                String x = this.actionCommando[this.dataList[0].getSelectedIndex()];
                String y = this.actionCommando[this.dataList[1].getSelectedIndex()];
                this.plot(Type.valueOf(x.substring(0, 1)), Type.valueOf(y.substring(0, 1)), Integer.parseInt(x.substring(1, 2)), Integer.parseInt(y.substring(1, 2)), x.substring(2), y.substring(2));
            }
        }
        catch (Exception ex) {
            this.main.mathpanel2d.reportError(ex, (Component)this.main);
        }
    }

    public synchronized void actionPerformed(ActionEvent event) {
        try {
            if (event.getActionCommand().equals("drag") && this.points != null && this.main.pointplot.isDragEnabled()) {
                double[][] x = new double[1][this.points.size()];
                double[] y = new double[this.points.size()];
                int i = 0;
                for (Object o : this.points) {
                    x[0][i] = ((MathPoint2D)o).getX();
                    y[i++] = ((MathPoint2D)o).getY();
                }
                CoordinateRect2D limits1 = this.main.pointplot.getLimits();
                CoordinateRect2D limits2 = this.regression(x, y);
                this.main.mathpanel2d.getScene2d().setLimits(limits1.combine(limits2));
                int rowIndex = this.main.pointplot.getIndex();
                this.main.table.setValueAt(Rounder.roundNumPlacesNext(x[0][rowIndex], 2), rowIndex, this.columnIndexX);
                this.main.table.setValueAt(Rounder.roundNumPlacesNext(y[rowIndex], 2), rowIndex, this.columnIndexY);
                this.control.compute(false, false);
            }
        }
        catch (Exception ex) {
            this.main.mathpanel2d.reportError(ex, (Component)this.main);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Type {
        D,
        I,
        F,
        R,
        S,
        N;

    }
}

