/*
 * Decompiled with CFR 0.152.
 */
package uibk.applets.regression;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import uibk.mtk.lang.InputException;
import uibk.mtk.lang.Messages;
import uibk.mtk.math.Rounder;
import uibk.mtk.math.regression.FStatisik;
import uibk.mtk.math.regression.FormFunctionRegression;
import uibk.mtk.math.regression.TStatisik;
import uibk.mtk.swing.base.MPanel;
import uibk.mtk.swing.datatable.DataTable;
import uibk.mtk.swing.datatable.TableModelWithRowNames;

public class PanelOutput2
extends MPanel {
    DecimalFormat format = new DecimalFormat("0.0000", new DecimalFormatSymbols(Locale.US));
    JLabel labelheader1 = new JLabel(Messages.getString("uibk.applets.regression.messages", "PanelOutput2.0"));
    JLabel labelN = new JLabel("");
    JLabel labelKoeffizenten = new JLabel("");
    JLabel labelrsquare = new JLabel("");
    JLabel labelStdErr = new JLabel("");
    JLabel labelFstat = new JLabel("");
    JLabel labelpWert = new JLabel("");
    JScrollPane scrollPane = new JScrollPane();
    private final String[] columnNames = new String[]{Messages.getString("uibk.applets.regression.messages", "PanelOutput2.11"), Messages.getString("uibk.applets.regression.messages", "PanelOutput2.12"), Messages.getString("uibk.applets.regression.messages", "PanelOutput2.13")};
    private static String FORMATCOLOR = "blue";

    public PanelOutput2() {
        this.initComponents();
    }

    void initComponents() {
        this.labelheader1.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.labelN.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.labelrsquare.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.labelStdErr.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.labelFstat.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.labelpWert.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.labelKoeffizenten.setBorder(BorderFactory.createEmptyBorder(15, 5, 5, 5));
        this.setLayout(new BorderLayout());
        this.setMinimumSize(new Dimension(300, 300));
        MPanel panel = new MPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.add(this.labelheader1);
        panel.add(this.labelN);
        panel.add(this.labelrsquare);
        panel.add(this.labelStdErr);
        panel.add(this.labelFstat);
        panel.add(this.labelpWert);
        panel.add(this.labelKoeffizenten);
        this.add((Component)panel, "North");
        this.add((Component)this.scrollPane, "Center");
    }

    public void createOutput(FormFunctionRegression regression, String[] formfunctions) throws InputException {
        this.labelN.setText(this.makeString(Messages.getString("uibk.applets.regression.messages", "PanelOutput2.1"), regression.getNumberDataSets()));
        this.labelKoeffizenten.setText(Messages.getString("uibk.applets.regression.messages", "PanelOutput2.2"));
        this.labelrsquare.setText(this.makeString(Messages.getString("uibk.applets.regression.messages", "PanelOutput2.3"), this.format.format(regression.getrsquare())));
        this.labelStdErr.setText(this.makeString(Messages.getString("uibk.applets.regression.messages", "PanelOutput2.4"), this.format.format(regression.getStandadError())));
        FStatisik fStatisik = regression.getFstatistik();
        this.labelFstat.setText(this.makeString(Messages.getString("uibk.applets.regression.messages", "PanelOutput2.5"), this.format.format(fStatisik.getValue())));
        this.labelpWert.setText(this.makeString(Messages.getString("uibk.applets.regression.messages", "PanelOutput2.6"), this.format.format(fStatisik.getpValue())));
        String[] rowLabels = new String[formfunctions.length + 2];
        rowLabels[0] = Messages.getString("uibk.applets.regression.messages", "PanelOutput2.10");
        rowLabels[1] = Messages.getString("uibk.applets.regression.messages", "PanelOutput2.14");
        double[] koeff = regression.getCoefficients();
        double[] errorKoeff = regression.getStandadErrorKoeff();
        TStatisik[] tStat = regression.getTstatistik();
        double[][] data = new double[this.columnNames.length][formfunctions.length + 1];
        int i = 0;
        while (i < formfunctions.length + 1) {
            data[0][i] = Rounder.roundNumPlacesNext(koeff[i], 3);
            data[1][i] = Rounder.roundNumPlacesNext(errorKoeff[i], 3);
            data[2][i] = Rounder.roundNumPlacesNext(tStat[i].getpValue(), 3);
            if (i < rowLabels.length - 2) {
                rowLabels[i + 2] = formfunctions[i];
            }
            ++i;
        }
        TableModelWithRowNames tableModel = new TableModelWithRowNames(data, rowLabels);
        tableModel.setColumnNames(this.columnNames);
        tableModel.setEditable(false);
        DataTable table = new DataTable(tableModel);
        this.scrollPane.setViewportView(table);
        this.scrollPane.setMaximumSize(new Dimension(1000, 24 + 17 * table.getRowCount()));
    }

    public void clear() {
        this.labelheader1.setText(Messages.getString("uibk.applets.regression.messages", "PanelOutput2.0"));
        this.labelN.setText("");
        this.labelKoeffizenten.setText("");
        this.labelrsquare.setText("");
        this.labelStdErr.setText("");
        this.labelFstat.setText("");
        this.labelpWert.setText("");
    }

    private String makeString(String name, int value) {
        Integer i = new Integer(value);
        return this.makeString(name, i.toString());
    }

    private String makeString(String name, String value) {
        String str = "<html><font color=" + FORMATCOLOR + ">" + name + ": </font>" + value;
        return str;
    }
}

