/*
 * Decompiled with CFR 0.152.
 */
package Jama.util;

public class Maths {
    static final String VAR = "t";

    public static double hypot(double a, double b) {
        double r;
        if (Math.abs(a) > Math.abs(b)) {
            r = b / a;
            r = Math.abs(a) * Math.sqrt(1.0 + r * r);
        } else if (b != 0.0) {
            r = a / b;
            r = Math.abs(b) * Math.sqrt(1.0 + r * r);
        } else {
            r = 0.0;
        }
        return r;
    }

    public static double beta(double a, double b) {
        if (a < 0.0 || b < 0.0) {
            return -1.0;
        }
        double r = Maths.gamma(a) * Maths.gamma(b) / Maths.gamma(a + b);
        return r;
    }

    public static double gamma(double a) {
        double x;
        if (a <= 0.0) {
            return -1.0;
        }
        double[] cof = new double[]{76.18009172947146, -86.50532032941678, 24.01409824083091, -1.231739572450155, 0.001208650973866179, -5.395239384953E-6};
        double y = x = a;
        double tmp = x + 5.5;
        tmp -= (x + 0.5) * Math.log(tmp);
        double ser = 1.000000000190015;
        int j = 0;
        while (j <= 5) {
            ser += cof[j] / (y += 1.0);
            ++j;
        }
        return Math.exp(-tmp + Math.log(2.5066282746310007 * ser / x));
    }
}

