function [areas,links,nodes]=gettheproberties(areas,links,nodes,valuegradient,sewerlength,rint,links_diams)
% Autor: Michael Mderl
n_areas=sum(nodes.type~=1);
n_nodes=length(nodes.x);
n_gen=max(nodes.gen);
n_links=length(links.start);

%links
for i=1:n_links
    if links.type(i)==0
        Qpipemax=areas.aimpcon(links.start(i))*rint*1/1000;%v=1m/s => Q=A
        temp=(4*Qpipemax/pi)^0.5;
        i_temp=find(temp<links_diams,1,'first');
        if isempty(i_temp)
            links.diam(i)=max(links_diams);
        else
            links.diam(i)=links_diams(i_temp);
        end
    elseif links.type(i)==1
        
        d0(i)=min( links.diam(links.start(i)==links.end) );
        ii=find( links.start(i)==links.start,1,'first');
        randfac=0.95+rand(1,1)/20;
        links.diam(ii)=round(d0(i)*randfac*10)/10 ;
        links.diam(i)=max(links_diams);
        
%         d0(i)=min( links.diam(links.start(i)==links.end) );
         randfac=0.9+rand(1,1)/10;
         links.height(i)=round(d0(i).*randfac*100)/100;
         temp=round((3+rand(1,1)*3).*d0(i)*10)/10;
         links.l(i)=(temp>1.5).*temp+1.5;
    end
end

links.diam(n_links)=links.height(find(links.start==1,1,'first'));


links.length=((nodes.x(links.start)-nodes.x(links.end)).^2+(nodes.y(links.start)-nodes.y(links.end)).^2).^0.5;
links.n=0.015*ones(1,length(links.start));
links.z1=0*ones(1,length(links.start));
links.z2=0*ones(1,length(links.start));
links.cd=1.8*ones(1,length(links.start));


%Areas
areas.width=            sewerlength/n_gen*ones(1,n_areas);
areas.slope=            valuegradient*ones(1,n_areas);
areas.clength=          1*ones(1,n_areas);
areas.nimp=             0.015*ones(1,n_areas);
areas.nperf=            0.200*ones(1,n_areas);
areas.sinp=             1.8*ones(1,n_areas);
areas.sperv=            5*ones(1,n_areas);
areas.zero=             0*ones(1,n_areas);

%Nodes
for i=1:n_nodes
    if nodes.type(i)==1
    else
        if isempty(find(links.end==i))
            nodes.ymax(i)=max(links.diam((links.start==i)))+2;
        else
            nodes.ymax(i)=max(links.diam((links.end==i)))+2;
        end
        if nodes.type(i)==2
            nodes.v(i)=sum( areas.aimpcon( links.start((links.end==i)) )) * (10+50*rand(1))+1;
        end
    end
end
nodes.y0=0*ones(1,length(nodes.x));