function nodes=gettheparents(prob_mat)
% Autor: Michael Mderl
% extended original code by Ingemar Kaj and Raimundas Gaigalas
% taken from http://www.math.uu.se/research/telecom/software/

ngen=size(prob_mat,2);

parents = 0;
extinct = 0;
nkids = 1; % number of children in the last generation

for i=1:ngen
    prob_vec=prob_mat(:,i)';
    max_kids = length(prob_vec)-1; % maximal number of children
    cum_prob = [cumsum(prob_vec) 1]; % distribution function
    gprevi = length(parents)-nkids+1:length(parents);% indices of individuals in the previous generation
    npar = nkids;

    % generate a set of numbers of children for all individuals
    % according to the distribution
    runi = rand(1, npar);  % a uniform sample

    % add the kids to the tree
    nkids = 0;
    for j=1:max_kids
        % find indexes of the parents who give birth to j children
        jpi = gprevi(((runi>cum_prob(j)) & (runi<=cum_prob(j+1))));
        if (~isempty(jpi))
            parents = [parents repmat(jpi, 1, j)];
            nkids = nkids+length(jpi)*j;
        end
    end

    % exit if no individuals left
    if (nkids==0)
        extinct = 1;
        break;
    end
end
nodes.parent=parents;