function gridareas=getthegrid(sewerlength,nodes,elevgradient)
% Autor: Michael Mderl
overlap=sewerlength/(1+max(nodes.gen));
cellfactor=50;
[gridareas.X gridareas.Y] =  meshgrid ( -1*overlap:sewerlength/cellfactor:sewerlength/2+overlap , -1*overlap:sewerlength/cellfactor:sewerlength+overlap );
oben=max(nodes.elev+(3*overlap*elevgradient));
unten=min(nodes.elev-(3*overlap*elevgradient));
x=[-overlap*2 -overlap*2 sewerlength/2+overlap*2 sewerlength/2+overlap*2];
y=[-overlap*2+1 sewerlength+overlap*2+1 -overlap*2 sewerlength+overlap*2];
z=[oben unten oben unten];
gridareas.Z=griddata([nodes.x x],[nodes.y y],[nodes.elev z],gridareas.X,gridareas.Y);

k=0;
for i=1:size(gridareas.X,1)-1
    for j=1:size(gridareas.X,2)-1
        k=k+1;
        gridareas.center(k,1)=gridareas.X(i,j)+(-gridareas.X(1,1)+gridareas.X(1,2))/2;
        gridareas.center(k,2)=gridareas.Y(i,j)+(-gridareas.Y(1,1)+gridareas.Y(2,1))/2;
        gridareas.area(k)=((-gridareas.X(i,j)+gridareas.X(i+1,j+1))*(-gridareas.Y(i,j)+gridareas.Y(i+1,j+1)))/100/100;
        gridareas.z(k)=gridareas.Z(i,j);
    end
end

%gridareas.Z(find(gridareas.Y==max(max(gridareas.Y))))=max(nodes.elev);

for i=1:size(gridareas.X,1)
    for j=1:size(gridareas.X,2)
        if isnan(gridareas.Z(i,j))
            gridareas.X(i,j)=nan;
            gridareas.Y(i,j)=nan;
        end
    end
end
