function [areas gridareas]=gettheareas(gridareas,nodes,populationdensity,pe,sewerlength)
% Autor: Michael Mderl
n_areas=sum(nodes.type~=1);
areas.a=zeros(1,n_areas);
maxlength=sewerlength/(max(nodes.gen+1))+0.5*sewerlength/(max(nodes.gen+1))*rand(1,length(nodes.x));
%maxlength=sewerlength/(max(nodes.gen+1));
for i=1:length(gridareas.center)
    L=((gridareas.center(i,1)-nodes.x).^2+(gridareas.center(i,2)-nodes.y).^2).^0.5;
    if isnan(gridareas.z(i))
        gridareas.m(i)=0;
    else
        index_under=gridareas.z(i)<nodes.elev;
        index_length=L>maxlength;
        L(index_under)=nan;
        L(index_length)=nan;

        if sum(~isnan(L))==0
            gridareas.m(i)=0;
        else
            index_area=find(min(L)==L,1,'first');
            areas.a(index_area)=areas.a(index_area)+gridareas.area(i);
            gridareas.m(i)=find(min(L)==L,1,'first');
        end

    end
end

population=populationdensity*areas.a.*(0.75+rand(1,n_areas)/2);
areas.dwf=population*pe;
areas.imperv= 0.25+rand(1,n_areas)/2;
