% Case Study Generator
% Autor: Michael Mderl
%% initialization
%clear all;clc;close all;
rand('twister',sum(100*clock));
%n=1
%number of generated virtual case studies (VCS)
if ~exist('n','var')
    n=250;
end

%allow storage units (1 -> Yes,  0 -> No )
as=1;

%constant boundary conditions
%rain fall intensity for pipe diameter design
rint=100;% [l/s/ha] r15(1)* time depending factor
%elevation of waste water treatement plant (WWTP)
elevwwtp=500;% [m]

%location of mfiles and rainfall file

rainfile='rain.dat';

%probability matrix of children
prob_mat(1:4,1)= [0.00 0.50 0.50 0.00];
for i=2:5
    prob_mat(1:4,i)= [0.00 0.45 0.55 0.00];
end
for ii=i:14
    prob_mat(1:4,ii)= [0.20 0.44 0.34 0.02];
end
for iii=ii:ii+4
    prob_mat(1:4,iii)=   [0.50 0.30 0.20 0.00];
end

% min and max of uniform distributed boundery condtions
% minimum and maximum of average elevation gradient
min_eg=0.5;% [%]
max_eg=1.5;% [%]
% minimum and maximum of longest path through urban drainage system (UDS)
min_sl=5000;% [m]
max_sl=13000;% [m]
% minimum and maximum population density
min_pd=150;% [inhabitants/ha]
max_pd=250;% [inhabitants/ha]
%min_pd=min_pd*2;%[population equivalent/ha]
%max_pd=max_pd*2;%[population equivalent/ha]
% possible diameters
links_diams=0.2:0.2:2.4; %(m)
% waste water per population equivalent
min_pe=250;% [l/day/pe]
max_pe=300;% [l/day/pe]

%TSS ... Stoffe, abfiltrierbare (AFS)
%BOD ... Sauerstoffbedarf, biochemischer (BSB)
%CSD ... Sauerstoffbedarf, chemischer (CSB)
%TOC ... Kohlenstoff, gesamter organisch gebundener
%DOC ... Kohlenstoff, gelster organisch gebundener
%NH4-N ... NH4-N
%NO3-N ... NO3-N
%Ntot ... Nges
%Ptot ... Pges
%Cu ... Cu
pollutants.ID=    {'TSS';'BOD';'CSD';'TOC';'DOC';'Ptot';'NH4-N';'NO3-N ';'Ntot';'Cu'};
pollutants.cdwf  = [141    178   403   116   110   4.50   21.4     1.9      14   58/1000];
pollutants.crain = [164     13    81    19    53   0.42    0.8     0.8     2.4   48/1000];
pollutants.cdwf  = pollutants.cdwf .*(0.8+rand(1,length(pollutants.crain))/5*2);
pollutants.crain = pollutants.crain.*(0.8+rand(1,length(pollutants.crain))/5*2);
%% Generation of VCS
i=0;
location=cd;
figure(1)
set(gcf,'visible','off')
while i<n
    % random variables
    elevgradient=(min_eg+(max_eg-min_eg)*rand(1))/100;
    pe=(min_pe+(max_pe-min_pe)*rand(1))/86400;
    populationdensity=(min_pd+(max_pd-min_pd)*rand(1));
    sewerlength=min_sl+(max_sl-min_sl)*rand(1);
    % used pipe dimaeter
    
    % get the parents of each node for tree generation
    nodes=gettheparents(prob_mat);
    % get the nodes of the tree
    nodes=getthenodes(nodes,sewerlength,elevwwtp,elevgradient);
    % get the links of the tree
    links=getthelinks(nodes);
    % create a surface raster
    gridareas=getthegrid(sewerlength,nodes,elevgradient);
    % allocate sub catchments to nodes
    [areas gridareas]=gettheareas(gridareas,nodes,populationdensity,pe,sewerlength);
    % introduce storage nodes
    if as==1
        nodes=getthestorages(nodes,links,areas);
    else
        nodes.v=[];
    end
    % introduce weirs
    [links,nodes]=gettheweirs(nodes,links,elevgradient,sewerlength);
    % allocate sub catchments for pipe design
    areas=gettheareasconnected(areas,nodes,links);
    % design of properties (e.g. pipe roughness)
    [areas,links,nodes]=gettheproberties(areas,links,nodes,elevgradient,sewerlength,rint,links_diams);

    if length(nodes.x)>=50
        i=i+1;
        networkname=['vcs_' num2str(i)];
        swmm_inpwirte(areas,nodes,links,rainfile,pollutants,networkname,[location '\inp\'])
        clf
        hold on
        plot(nodes.x,nodes.y,'.','MarkerFaceColor',[0.5 0.5 0.5],'MarkerEdgeColor',[0 0 0],'LineWidth',1)
        plot(  nodes.x( [links.start;links.end] ) , nodes.y( [links.start;links.end] ),'k','LineWidth',1);
        xlim([-sewerlength/(max(nodes.gen)+1)-sewerlength/4 sewerlength*3/4+sewerlength/(max(nodes.gen)+1)])
        ylim([-sewerlength/(max(nodes.gen)+1) sewerlength+sewerlength/(max(nodes.gen)+1)])
        hold off
        print('-djpeg',[cd '\jpg\vcs_' num2str(i) '.jpg'])
    end
    if n~=1
    clear('areas','nodes','links','gridareas');
    end
end
%save([cd '\mat\' 'CSC.mat'],'CSC')