/*
 * Decompiled with CFR 0.152.
 */
package uibk.mtk.swing.scene3d;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JRadioButton;
import uibk.mtk.draw3d.base.MathPanel3D;
import uibk.mtk.draw3d.objects.surface3d.Surface3D;
import uibk.mtk.lang.Messages;
import uibk.mtk.swing.base.TitledPanel;

public class PanelSurface3DStyle
extends TitledPanel
implements ActionListener {
    Surface3D surface3d;
    MathPanel3D mathpanel3d;
    JRadioButton radioWireframe;
    JRadioButton radioPatchWireframe;
    JRadioButton radioPatch;
    JRadioButton radioWireframeHidden;
    static final String BUNDLE_NAME = "uibk.mtk.swing.scene3d.messages";

    public PanelSurface3DStyle(Surface3D surface3d, MathPanel3D mathpanel3d) {
        super(Messages.getString(BUNDLE_NAME, "PanelSurface3DStyle.0"));
        if (mathpanel3d == null) {
            throw new NullPointerException(Messages.getString(BUNDLE_NAME, "PanelSurface3DStyle.1"));
        }
        if (surface3d == null) {
            throw new NullPointerException(Messages.getString(BUNDLE_NAME, "PanelSurface3DStyle.2"));
        }
        this.surface3d = surface3d;
        this.mathpanel3d = mathpanel3d;
        this.initComponents();
    }

    public void actionPerformed(ActionEvent event) {
        if (event.getActionCommand().equals("wireframe")) {
            this.surface3d.setDrawMode(0);
        }
        if (event.getActionCommand().equals("wireframehidden")) {
            this.surface3d.setDrawMode(1);
        }
        if (event.getActionCommand().equals("patch")) {
            this.surface3d.setDrawMode(3);
        }
        if (event.getActionCommand().equals("patchwireframe")) {
            this.surface3d.setDrawMode(2);
        }
        this.mathpanel3d.repaint();
    }

    void initComponents() {
        this.setLayout(new GridBagLayout());
        this.setMaximumSize(new Dimension(2000, 150));
        this.radioWireframe = new JRadioButton(Messages.getString(BUNDLE_NAME, "PanelSurface3DStyle.7"));
        this.radioWireframe.setActionCommand("wireframe");
        this.radioWireframe.addActionListener(this);
        this.radioPatchWireframe = new JRadioButton(Messages.getString(BUNDLE_NAME, "PanelSurface3DStyle.9"));
        this.radioPatchWireframe.setActionCommand("patchwireframe");
        this.radioPatchWireframe.addActionListener(this);
        this.radioWireframeHidden = new JRadioButton(Messages.getString(BUNDLE_NAME, "PanelSurface3DStyle.11"));
        this.radioWireframeHidden.setActionCommand("wireframehidden");
        this.radioWireframeHidden.addActionListener(this);
        this.radioPatch = new JRadioButton(Messages.getString(BUNDLE_NAME, "PanelSurface3DStyle.13"));
        this.radioPatch.setActionCommand("patch");
        this.radioPatch.addActionListener(this);
        ButtonGroup groupStyleOpt = new ButtonGroup();
        groupStyleOpt.add(this.radioWireframe);
        groupStyleOpt.add(this.radioPatchWireframe);
        groupStyleOpt.add(this.radioWireframeHidden);
        groupStyleOpt.add(this.radioPatch);
        this.setInitialOption();
        this.add((Component)this.radioWireframe, new GridBagConstraints(0, 0, 1, 1, 0.1, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        this.add((Component)this.radioWireframeHidden, new GridBagConstraints(0, 1, 1, 1, 0.1, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.radioPatchWireframe, new GridBagConstraints(0, 2, 1, 1, 0.1, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.radioPatch, new GridBagConstraints(0, 3, 1, 1, 0.1, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
    }

    private void setInitialOption() {
        switch (this.surface3d.getDrawMode()) {
            case 3: {
                this.radioPatch.setSelected(true);
                break;
            }
            case 2: {
                this.radioPatchWireframe.setSelected(true);
                break;
            }
            case 0: {
                this.radioWireframe.setSelected(true);
                break;
            }
            case 1: {
                this.radioWireframeHidden.setSelected(true);
            }
        }
    }
}

