/*
 * Decompiled with CFR 0.152.
 */
package uibk.mtk.math.integration;

import uibk.mtk.math.functions.Function2D;

public class GaussIntegration2D {
    private static double EPS = 1.0E-11;

    public static void calcKnotsAndWeights(double a, double b, double[] knots, double[] weights, int s) {
        double xm = 0.5 * (b + a);
        int m = (s + 1) / 2;
        int i = 1;
        while (i <= m) {
            double p2;
            double pp;
            double p1;
            double z1;
            double z = Math.cos(Math.PI * ((double)i - 0.25) / ((double)s + 0.5));
            do {
                p1 = 1.0;
                p2 = 0.0;
                int j = 1;
                while (j <= s) {
                    double p3 = p2;
                    p2 = p1;
                    p1 = ((2.0 * (double)j - 1.0) * z * p2 - ((double)j - 1.0) * p3) / (double)j;
                    ++j;
                }
            } while (Math.abs((z = (z1 = z) - p1 / (pp = (double)s * (z * p1 - p2) / (z * z - 1.0))) - z1) > EPS);
            double xl = 0.5 * (b - a);
            knots[i - 1] = xm - xl * z;
            knots[s - i] = xm + xl * z;
            weights[i - 1] = 2.0 * xl / ((1.0 - z * z) * pp * pp);
            weights[s - i] = weights[i - 1];
            ++i;
        }
    }

    public static void calcKnotsAndWeights(double a, double b, double c, double d, double[][] knots, double[][] weights, int s) {
        double[][] xw = new double[2][s];
        double n = (b - a) / (d - c);
        int m = (s + 1) / 2;
        GaussIntegration2D.calcKnotsAndWeights(a, b, knots[0], xw[0], s);
        int i = 0;
        while (i < s) {
            knots[1][i] = c + (knots[0][i] - a) / n;
            xw[1][i] = n * xw[0][i];
            ++i;
        }
        i = 0;
        while (i < m) {
            int j = 0;
            while (j < m) {
                weights[i][j] = xw[0][i] * xw[1][j];
                weights[s - 1 - i][j] = weights[i][j];
                weights[i][s - 1 - j] = weights[i][j];
                weights[s - 1 - i][s - 1 - j] = weights[i][j];
                ++j;
            }
            ++i;
        }
    }

    public static double quadrature(Function2D f, double lowerx, double upperx, double lowery, double uppery, int s, int n) {
        double[][] knots = new double[2][s];
        double[][] weights = new double[s][s];
        double sum = 0.0;
        double tempsum = 0.0;
        GaussIntegration2D.calcKnotsAndWeights(-1.0, 1.0, -1.0, 1.0, knots, weights, s);
        double hx = (upperx - lowerx) / (double)n;
        double hy = (uppery - lowery) / (double)n;
        int i = 0;
        while (i < n) {
            int j = 0;
            while (j < n) {
                double ax = lowerx + (double)i * hx;
                double bx = lowerx + (double)(i + 1) * hx;
                double ay = lowery + (double)j * hy;
                double by = lowery + (double)(j + 1) * hy;
                double xplus = 0.5 * (ax + bx);
                double xminus = 0.5 * (bx - ax);
                double yplus = 0.5 * (ay + by);
                double yminus = 0.5 * (by - ay);
                tempsum = 0.0;
                int m = 0;
                while (m < s) {
                    int k = 0;
                    while (k < s) {
                        double dx = xminus * knots[0][m];
                        double dy = yminus * knots[1][k];
                        tempsum += weights[m][k] * f.getValue(xplus + dx, yplus + dy);
                        ++k;
                    }
                    ++m;
                }
                tempsum = tempsum * xminus * yminus;
                sum += tempsum;
                ++j;
            }
            ++i;
        }
        return sum;
    }
}

