/*
 * Decompiled with CFR 0.152.
 */
package uibk.mtk.geom.geom3d;

import uibk.mtk.geom.geom3d.Punkt3D;
import uibk.mtk.math.Interval;
import uibk.mtk.math.Rounder;

public class CoordinateBox3D {
    public double xmin;
    public double xmax;
    public double ymin;
    public double ymax;
    public double zmin;
    public double zmax;
    public static final int ROUND_X = 1;
    public static final int ROUND_Y = 2;
    public static final int ROUND_Z = 4;
    public static final int ROUND_XY = 3;
    public static final int ROUND_YZ = 6;
    public static final int ROUND_XZ = 5;
    public static final int ROUND_XYZ = 7;

    public CoordinateBox3D(double xmin, double xmax, double ymin, double ymax, double zmin, double zmax) {
        if (xmin > xmax || ymin > ymax || zmin > zmax) {
            throw new IllegalArgumentException("");
        }
        this.xmin = xmin;
        this.xmax = xmax;
        this.ymin = ymin;
        this.ymax = ymax;
        this.zmin = zmin;
        this.zmax = zmax;
    }

    public CoordinateBox3D(Interval xrange, Interval yrange, Interval zrange) {
        if (xrange.a > xrange.b || zrange.a > zrange.b || zrange.a > zrange.b) {
            throw new IllegalArgumentException("");
        }
        this.xmin = xrange.a;
        this.xmax = xrange.b;
        this.ymin = yrange.a;
        this.ymax = yrange.b;
        this.zmin = zrange.a;
        this.zmax = zrange.b;
    }

    public CoordinateBox3D(CoordinateBox3D limits) {
        this.xmin = limits.xmin;
        this.xmax = limits.xmax;
        this.ymin = limits.ymin;
        this.ymax = limits.ymax;
        this.zmin = limits.zmin;
        this.zmax = limits.zmax;
    }

    public CoordinateBox3D() {
        this(-1.0, 1.0, -1.0, 1.0, -1.0, 1.0);
    }

    public double getXRange() {
        return Math.abs(this.xmax - this.xmin);
    }

    public double getYRange() {
        return Math.abs(this.ymax - this.ymin);
    }

    public double getZRange() {
        return Math.abs(this.zmax - this.zmin);
    }

    public Object clone() {
        return new CoordinateBox3D(this.xmin, this.xmax, this.ymin, this.ymax, this.zmin, this.zmax);
    }

    public Punkt3D getCenter() {
        return new Punkt3D((this.xmin + this.xmax) / 2.0, (this.ymin + this.ymax) / 2.0, (this.zmin + this.zmax) / 2.0);
    }

    public String toString() {
        return "[xmin=" + this.xmin + ",xmax=" + this.xmax + " ymin=" + this.ymin + ",ymax=" + this.ymax + ",zmin=" + this.zmin + ",zmax=" + this.zmax + "]";
    }

    public boolean isEmpty() {
        if (this.xmin <= this.xmax) {
            return true;
        }
        if (this.ymin <= this.ymax) {
            return true;
        }
        return this.zmin <= this.zmax;
    }

    public double maxBoundingBox() {
        double x = Math.abs(this.xmax - this.xmin);
        double y = Math.abs(this.ymax - this.ymin);
        double z = Math.abs(this.zmax - this.zmin);
        return Math.max(x, Math.max(y, z));
    }

    public double minBoundingBox() {
        double x = Math.abs(this.xmax - this.xmin);
        double y = Math.abs(this.ymax - this.ymin);
        double z = Math.abs(this.zmax - this.zmin);
        return Math.min(x, Math.min(y, z));
    }

    public boolean contains(CoordinateBox3D box) {
        if (box.xmax > this.xmax || box.xmin < this.xmin) {
            return false;
        }
        if (box.ymax > this.ymax || box.ymin < this.ymin) {
            return false;
        }
        return !(box.zmax > this.zmax) && !(box.zmin < this.zmin);
    }

    public CoordinateBox3D combine(CoordinateBox3D box) {
        double newxmin = this.xmin < box.xmin ? this.xmin : box.xmin;
        double newxmax = this.xmax > box.xmax ? this.xmax : box.xmax;
        double newymin = this.ymin < box.ymin ? this.ymin : box.ymin;
        double newymax = this.ymax > box.ymax ? this.ymax : box.ymax;
        double newzmin = this.zmin < box.zmin ? this.zmin : box.zmin;
        double newzmax = this.zmax > box.zmax ? this.zmax : box.zmax;
        return new CoordinateBox3D(newxmin, newxmax, newymin, newymax, newzmin, newzmax);
    }

    public boolean contains(Punkt3D p) {
        if (p.x1 > this.xmax || p.x1 < this.xmin) {
            return false;
        }
        if (p.x2 > this.ymax || p.x2 < this.ymin) {
            return false;
        }
        return !(p.x3 > this.zmax) && !(p.x3 < this.zmin);
    }

    public void roundCoords(double percent, int adjust) {
        double newymin = this.ymin;
        double newymax = this.ymax;
        double newxmin = this.xmin;
        double newxmax = this.xmax;
        double newzmin = this.xmin;
        double newzmax = this.xmax;
        double distx = Math.abs((this.xmax - this.xmin) / 100.0 * percent);
        double disty = Math.abs((this.ymax - this.ymin) / 100.0 * percent);
        double distz = Math.abs((this.zmax - this.zmin) / 100.0 * percent);
        if ((adjust & 2) == 2) {
            newymax = Rounder.getUpperRoundValue(this.ymax, disty);
            newymin = Rounder.getLowerRoundValue(this.ymin, disty);
        }
        if ((adjust & 1) == 1) {
            newxmax = Rounder.getUpperRoundValue(this.xmax, distx);
            newxmin = Rounder.getLowerRoundValue(this.xmin, distx);
        }
        if ((adjust & 4) == 4) {
            newzmax = Rounder.getUpperRoundValue(this.zmax, distz);
            newzmin = Rounder.getLowerRoundValue(this.zmin, distz);
        }
        if ((adjust & 2) == 1) {
            if (this.ymin > 0.0 && this.ymin - disty < 0.0) {
                newymin = 0.0;
            }
            if (this.ymax < 0.0 && this.ymax + disty > 0.0) {
                newymax = 0.0;
            }
        }
        if ((adjust & 1) == 1) {
            if (this.xmin > 0.0 && this.xmin - distx < 0.0) {
                newxmin = 0.0;
            }
            if (this.xmax < 0.0 && this.xmax + distx > 0.0) {
                newxmax = 0.0;
            }
        }
        if ((adjust & 4) == 1) {
            if (this.zmin > 0.0 && this.zmin - distz < 0.0) {
                newzmin = 0.0;
            }
            if (this.zmax < 0.0 && this.zmax + distz > 0.0) {
                newzmax = 0.0;
            }
        }
        this.xmin = newxmin;
        this.xmax = newxmax;
        this.ymin = newymin;
        this.ymax = newymax;
        this.zmin = newzmin;
        this.zmax = newzmax;
    }
}

