/*
 * Decompiled with CFR 0.152.
 */
package uibk.mtk.draw3d.objects.surface3d;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.Collections;
import java.util.Vector;
import uibk.mtk.draw3d.base.Rasterable3D;
import uibk.mtk.draw3d.objects.surface3d.AdditionalRendering;
import uibk.mtk.draw3d.objects.surface3d.ColorModel;
import uibk.mtk.draw3d.objects.surface3d.ColorModelXYZ;
import uibk.mtk.draw3d.objects.surface3d.Mesh;
import uibk.mtk.draw3d.objects.surface3d.Triangle;
import uibk.mtk.draw3d.objects.surface3d.Vertex3D;
import uibk.mtk.geom.geom2d.CoordinateRect2D;
import uibk.mtk.geom.geom3d.CoordinateBox3D;
import uibk.mtk.geom.geom3d.Punkt3D;
import uibk.mtk.geom.geom3d.Vector3D;
import uibk.mtk.lang.PrepaintComputable;

public class Surface3D
extends Rasterable3D
implements PrepaintComputable {
    Mesh mesh;
    AdditionalRendering addrendering;
    static final Color COLORMESH = new Color(255, 0, 0, 120);
    static final Color COLORPATCHMESH = new Color(0, 0, 0, 120);
    static final Color COLORFRONT = new Color(255, 0, 0);
    static final Color COLORBACK = new Color(0, 0, 255);
    ColorModel colormodel = new ColorModelXYZ();
    static final Color COLORBACKGROUND = Color.white;
    protected int colormode = 1;
    public static final int FRONTBACK = 0;
    private boolean step = false;
    public static final int VERTEXCOLORS = 1;
    int drawmode = 2;
    public static final int DRAW_WIREFRAME = 0;
    public static final int DRAW_VISIBLE_WIREFRAME = 1;
    public static final int DRAW_PATCH_WIREFRAME = 2;
    public static final int DRAW_PATCH = 3;

    public void setMesh(Mesh mesh) {
        this.mesh = mesh;
        this.calcColors();
    }

    public void setDrawMode(int mode) {
        this.drawmode = mode;
    }

    public int getDrawMode() {
        return this.drawmode;
    }

    public void draw(BufferedImage framebuffer, Graphics2D g2) {
        if (this.mesh == null) {
            return;
        }
        this.rasterizer.enableZBuffer(false);
        switch (this.drawmode) {
            case 0: {
                this.drawmesh(g2);
                break;
            }
            case 1: {
                this.drawVisibleMesh(g2);
                break;
            }
            case 2: {
                this.drawpatchwireframe(g2);
                break;
            }
            case 3: {
                this.drawpatch(g2);
                break;
            }
        }
    }

    private void drawpatch(Graphics2D g2) {
        Vector triangles = this.mesh.getTriangles();
        switch (this.colormode) {
            case 1: {
                int i = 0;
                while (i < triangles.size()) {
                    Triangle tri = (Triangle)triangles.elementAt(i);
                    this.rasterizer.setColor(tri.p1.color);
                    this.rasterizer.renderTriangle(tri);
                    this.additionalRendering(tri, g2);
                    ++i;
                }
                break;
            }
            case 0: {
                int savemode = this.rasterizer.getShadingMode();
                this.rasterizer.setShadingMode(0);
                int i = 0;
                while (i < triangles.size()) {
                    Triangle tri = (Triangle)triangles.elementAt(i);
                    Punkt3D cam = this.panel.getScene3D().getCamera();
                    if (cam.sub(tri.p1.wc).dotProd(tri.normal) < 0.0) {
                        this.rasterizer.setColor(COLORFRONT);
                    } else {
                        this.rasterizer.setColor(COLORBACK);
                    }
                    this.rasterizer.renderTriangle(tri);
                    ++i;
                }
                this.rasterizer.setShadingMode(savemode);
                break;
            }
        }
    }

    void drawpatchwireframe(Graphics2D g2) {
        Vector triangles = this.mesh.getTriangles();
        switch (this.colormode) {
            case 1: {
                int i = 0;
                while (i < triangles.size()) {
                    Triangle tri = (Triangle)triangles.elementAt(i);
                    this.rasterizer.setColor(tri.p1.color);
                    this.rasterizer.renderTriangle(tri);
                    this.rasterizer.setColor(COLORPATCHMESH);
                    this.rasterizer.drawline(tri.p1, tri.p2);
                    this.rasterizer.drawline(tri.p3, tri.p1);
                    this.additionalRendering(tri, g2);
                    ++i;
                }
                break;
            }
            case 0: {
                int savemode = this.rasterizer.getShadingMode();
                this.rasterizer.setShadingMode(0);
                int i = 0;
                while (i < triangles.size()) {
                    Triangle tri = (Triangle)triangles.elementAt(i);
                    Punkt3D cam = this.panel.getScene3D().getCamera();
                    if (cam.sub(tri.p1.wc).dotProd(tri.normal) < 0.0) {
                        this.rasterizer.setColor(COLORFRONT);
                    } else {
                        this.rasterizer.setColor(COLORBACK);
                    }
                    this.rasterizer.renderTriangle(tri);
                    this.rasterizer.setColor(COLORPATCHMESH);
                    this.rasterizer.drawline(tri.p1, tri.p2);
                    this.rasterizer.drawline(tri.p3, tri.p1);
                    this.additionalRendering(tri, g2);
                    ++i;
                }
                this.rasterizer.setShadingMode(savemode);
                break;
            }
        }
    }

    private void computenormals() {
        Vector triangles = this.mesh.getTriangles();
        int i = 0;
        while (i < triangles.size()) {
            Vector3D n;
            Triangle tri = (Triangle)triangles.elementAt(i);
            Punkt3D p1 = tri.p1.wc;
            Punkt3D p2 = tri.p2.wc;
            Punkt3D p3 = tri.p3.wc;
            tri.normal = n = p2.sub(p1).crossProd(p3.sub(p2));
            ++i;
        }
    }

    void drawVisibleMesh(Graphics2D g2) {
        int savemode = this.rasterizer.getShadingMode();
        this.rasterizer.setShadingMode(0);
        this.rasterizer.setColor(COLORBACKGROUND);
        Vector triangles = this.mesh.getTriangles();
        int i = 0;
        while (i < triangles.size()) {
            Triangle tri = (Triangle)triangles.elementAt(i);
            this.rasterizer.setColor(COLORBACKGROUND);
            this.rasterizer.renderTriangle(tri);
            this.rasterizer.setColor(COLORMESH);
            this.rasterizer.drawline(tri.p1, tri.p2);
            this.rasterizer.drawline(tri.p3, tri.p1);
            this.additionalRendering(tri, g2);
            ++i;
        }
        this.rasterizer.setShadingMode(savemode);
    }

    public void prepaintcompute() {
        Vertex3D vertex;
        if (this.mesh == null) {
            return;
        }
        Vector triangles = this.mesh.getTriangles();
        Vector vertices = this.mesh.getVertices();
        int i = 0;
        while (i < vertices.size()) {
            vertex = (Vertex3D)vertices.elementAt(i);
            vertex.dc = this.scene3d.mcToDevice(vertex.mc);
            vertex.wc = this.scene3d.getWC(vertex.mc);
            ++i;
        }
        i = 0;
        while (i < vertices.size()) {
            vertex = (Vertex3D)vertices.elementAt(i);
            vertex.distance = this.scene3d.calcdepth(vertex.wc);
            ++i;
        }
        i = 0;
        while (i < triangles.size()) {
            Triangle tri = (Triangle)triangles.elementAt(i);
            Punkt3D a = tri.p1.wc;
            Punkt3D b = tri.p2.wc;
            Punkt3D c = tri.p3.wc;
            Punkt3D center = new Punkt3D();
            if (this.step) {
                center = b.add(c);
                center.scaleself(0.5);
            } else {
                center = a.add(b).add(c);
                center.scaleself(0.3333333333333333);
            }
            tri.distance = this.scene3d.calcdepth(center);
            ++i;
        }
        if (this.colormode == 0) {
            this.computenormals();
        }
        if (this.drawmode != 0) {
            Collections.sort(triangles);
        }
    }

    public void setVertexColorModel(ColorModel model) {
        this.colormodel = model;
        this.calcColors();
    }

    public void setColorMode(int mode) {
        this.colormode = mode;
        if (this.colormode == 1) {
            this.calcColors();
        }
    }

    public void setVisibility(boolean g) {
        this.step = g;
    }

    public int getColorMode() {
        return this.colormode;
    }

    public ColorModel getColorModel() {
        return this.colormodel;
    }

    protected void calcColors() {
        if (this.mesh == null) {
            return;
        }
        CoordinateBox3D limits = this.mesh.getBoundingBox();
        Vector vertices = this.mesh.getVertices();
        this.colormodel.colorVertices(vertices.iterator(), limits);
    }

    private void drawmesh(Graphics2D g2) {
        Vector triangles = this.mesh.getTriangles();
        int i = 0;
        while (i < triangles.size()) {
            Triangle tri = (Triangle)triangles.elementAt(i);
            this.rasterizer.setColor(COLORMESH);
            this.rasterizer.drawline(tri.p1, tri.p2);
            this.rasterizer.drawline(tri.p3, tri.p1);
            this.additionalRendering(tri, g2);
            ++i;
        }
    }

    public CoordinateBox3D getBoundingBox() {
        if (this.mesh == null) {
            return null;
        }
        return this.mesh.getBoundingBox();
    }

    public CoordinateRect2D getXYLimits() {
        if (this.mesh == null) {
            return null;
        }
        CoordinateBox3D cube = this.mesh.getBoundingBox();
        return new CoordinateRect2D(cube.xmin, cube.xmax, cube.ymin, cube.ymax);
    }

    protected void setAdditionalRendering(AdditionalRendering add) {
        this.addrendering = add;
    }

    private void additionalRendering(Triangle tri, Graphics2D g2) {
        if (this.addrendering != null) {
            this.addrendering.render(tri, g2);
        }
    }
}

