/*
 * Decompiled with CFR 0.152.
 */
package uibk.mtk.draw3d.objects.surface3d;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Stroke;
import java.awt.image.BufferedImage;
import uibk.mtk.draw3d.base.Drawable3D;
import uibk.mtk.geom.geom2d.Punkt2D;
import uibk.mtk.geom.geom3d.Punkt3D;

public class Rectangular3D
extends Drawable3D {
    public static final int MESH = 1;
    public static final int FILL = 2;
    private Punkt3D point1;
    private Punkt3D point2;
    private Punkt3D point3;
    private boolean visible = false;
    private Color color = Color.BLACK;
    private int drawMode = 1;
    private int resolution = 20;

    public void setPoints(Punkt3D point1, Punkt3D point2, Punkt3D point3) {
        this.point1 = point1;
        this.point2 = point2;
        this.point3 = point3;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public void setDrawMode(int mode) {
        this.drawMode = mode;
    }

    public void setResolution(int resolution) {
        this.resolution = resolution;
    }

    private Polygon[] calcMesh(Punkt2D x1, Punkt2D x2, Punkt2D x3, Punkt2D x4) {
        Polygon[] polygons = new Polygon[this.resolution * this.resolution];
        Punkt2D displ1 = new Punkt2D((x2.x - x1.x) / (double)this.resolution, (x2.y - x1.y) / (double)this.resolution);
        Punkt2D displ2 = new Punkt2D((x4.x - x1.x) / (double)this.resolution, (x4.y - x1.y) / (double)this.resolution);
        int i = 0;
        while (i < this.resolution) {
            int j = 0;
            while (j < this.resolution) {
                int p1x = (int)(x1.x + (double)j * displ1.x + (double)i * displ2.x);
                int p1y = (int)(x1.y + (double)j * displ1.y + (double)i * displ2.y);
                int p2x = (int)(x1.x + (double)(j + 1) * displ1.x + (double)i * displ2.x);
                int p2y = (int)(x1.y + (double)(j + 1) * displ1.y + (double)i * displ2.y);
                int p3x = (int)(x1.x + (double)(j + 1) * displ1.x + (double)(i + 1) * displ2.x);
                int p3y = (int)(x1.y + (double)(j + 1) * displ1.y + (double)(i + 1) * displ2.y);
                int p4x = (int)(x1.x + (double)j * displ1.x + (double)(i + 1) * displ2.x);
                int p4y = (int)(x1.y + (double)j * displ1.y + (double)(i + 1) * displ2.y);
                polygons[j + i * this.resolution] = new Polygon(new int[]{p1x, p2x, p3x, p4x}, new int[]{p1y, p2y, p3y, p4y}, 4);
                ++j;
            }
            ++i;
        }
        return polygons;
    }

    public void draw(BufferedImage framebuffer, Graphics2D g2) {
        if (this.visible) {
            Color oldColor = g2.getColor();
            Stroke oldStroke = g2.getStroke();
            g2.setColor(this.color);
            g2.setStroke(new BasicStroke());
            Punkt3D point4 = new Punkt3D(this.point1.x1 + (this.point3.x1 - this.point2.x1), this.point1.x2 + (this.point3.x2 - this.point2.x2), this.point1.x3 + (this.point3.x3 - this.point2.x3));
            Punkt2D x1 = this.scene3d.project(this.point1);
            Punkt2D x2 = this.scene3d.project(this.point2);
            Punkt2D x3 = this.scene3d.project(this.point3);
            Punkt2D x4 = this.scene3d.project(point4);
            Polygon[] polygons = this.calcMesh(x1, x2, x3, x4);
            switch (this.drawMode) {
                case 2: {
                    int i = 0;
                    while (i < polygons.length) {
                        g2.fillPolygon(polygons[i]);
                        ++i;
                    }
                    break;
                }
                case 1: {
                    int i = 0;
                    while (i < polygons.length) {
                        g2.drawPolygon(polygons[i]);
                        ++i;
                    }
                    break;
                }
            }
            g2.setColor(oldColor);
            g2.setStroke(oldStroke);
        }
    }
}

