/*
 * Decompiled with CFR 0.152.
 */
package uibk.mtk.draw3d.base;

import uibk.mtk.geom.geom3d.Punkt3D;
import uibk.mtk.geom.geom3d.Vector3D;
import uibk.mtk.lang.Messages;

public class Matrix3D {
    private static final String BUNDLE_NAME = "uibk.mtk.draw3d.base.messages";
    private double[][] coeffs = new double[4][4];

    public Matrix3D() {
    }

    public Matrix3D multiply(Matrix3D B) {
        Matrix3D mult = new Matrix3D();
        int i = 0;
        while (i < 4) {
            int j = 0;
            while (j < 4) {
                int k = 0;
                while (k < 4) {
                    double[] dArray = mult.coeffs[i];
                    int n = j;
                    dArray[n] = dArray[n] + this.coeffs[i][k] * B.coeffs[k][j];
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return mult;
    }

    public Vector3D multiply(Punkt3D v) {
        Vector3D mult = new Vector3D();
        mult.x1 = this.coeffs[0][0] * v.x1 + this.coeffs[0][1] * v.x2 + this.coeffs[0][2] * v.x3 + this.coeffs[0][3] * v.h;
        mult.x2 = this.coeffs[1][0] * v.x1 + this.coeffs[1][1] * v.x2 + this.coeffs[1][2] * v.x3 + this.coeffs[1][3] * v.h;
        mult.x3 = this.coeffs[2][0] * v.x1 + this.coeffs[2][1] * v.x2 + this.coeffs[2][2] * v.x3 + this.coeffs[2][3] * v.h;
        mult.h = this.coeffs[3][0] * v.x1 + this.coeffs[3][1] * v.x2 + this.coeffs[3][2] * v.x3 + this.coeffs[3][3] * v.h;
        return mult;
    }

    public double getCoeff(int i, int j) {
        return this.coeffs[i - 1][j - 1];
    }

    public static Matrix3D getIdentityMatrix() {
        Matrix3D matrix = new Matrix3D();
        int i = 0;
        while (i < 4) {
            matrix.coeffs[i][i] = 1.0;
            ++i;
        }
        return matrix;
    }

    public static Matrix3D getScaleMatrix(double xs, double ys, double zs) {
        Matrix3D matrix = Matrix3D.getIdentityMatrix();
        matrix.coeffs[0][0] = xs;
        matrix.coeffs[1][1] = ys;
        matrix.coeffs[2][2] = zs;
        return matrix;
    }

    public String toString() {
        String str = "";
        int i = 0;
        while (i < 4) {
            int j = 0;
            while (j < 4) {
                str = String.valueOf(str) + this.coeffs[i][j] + " ";
                ++j;
            }
            str = String.valueOf(str) + "\n";
            ++i;
        }
        return str;
    }

    public static Matrix3D getTranslationMatrix(double xt, double yt, double zt) {
        Matrix3D matrix = Matrix3D.getIdentityMatrix();
        matrix.coeffs[0][3] = xt;
        matrix.coeffs[1][3] = yt;
        matrix.coeffs[2][3] = zt;
        return matrix;
    }

    public static Matrix3D getParallelProjectionMatrixXZPlane() {
        Matrix3D matrix = Matrix3D.getIdentityMatrix();
        matrix.coeffs[1][1] = 0.0;
        return matrix;
    }

    public static Matrix3D getPerspectiveProjectionMatrixXZPlane(double distance) {
        Matrix3D matrix = Matrix3D.getIdentityMatrix();
        matrix.coeffs[1][1] = 0.0;
        matrix.coeffs[3][1] = -1.0 / distance;
        return matrix;
    }

    public static Matrix3D getRotationMatrixXAxis(double angle) {
        Matrix3D matrix = Matrix3D.getIdentityMatrix();
        matrix.coeffs[1][1] = Math.cos(angle);
        matrix.coeffs[1][2] = -Math.sin(angle);
        matrix.coeffs[2][1] = Math.sin(angle);
        matrix.coeffs[2][2] = Math.cos(angle);
        return matrix;
    }

    public static Matrix3D getRotationMatrixZAxis(double angle) {
        Matrix3D matrix = Matrix3D.getIdentityMatrix();
        matrix.coeffs[0][0] = Math.cos(angle);
        matrix.coeffs[0][1] = -Math.sin(angle);
        matrix.coeffs[1][0] = Math.sin(angle);
        matrix.coeffs[1][1] = Math.cos(angle);
        return matrix;
    }

    public static Matrix3D getRotationMatrixYAxis(double angle) {
        Matrix3D matrix = Matrix3D.getIdentityMatrix();
        matrix.coeffs[0][0] = Math.cos(angle);
        matrix.coeffs[0][2] = -Math.sin(angle);
        matrix.coeffs[2][0] = Math.sin(angle);
        matrix.coeffs[2][2] = Math.cos(angle);
        return matrix;
    }

    public static Matrix3D transpose(Matrix3D A) {
        Matrix3D T = new Matrix3D();
        int i = 0;
        while (i < 4) {
            int j = 0;
            while (j < 4) {
                T.coeffs[i][j] = A.coeffs[j][i];
                ++j;
            }
            ++i;
        }
        return T;
    }

    public Matrix3D(Matrix3D A) {
        int i = 0;
        while (i < 4) {
            int j = 0;
            while (j < 4) {
                this.coeffs[i][j] = A.coeffs[i][j];
                ++j;
            }
            ++i;
        }
    }

    public Matrix3D inverse() throws Exception {
        Matrix3D temp = new Matrix3D(this);
        Matrix3D inv = Matrix3D.getIdentityMatrix();
        int j = 0;
        while (j < 4) {
            double e = temp.coeffs[j][j];
            if (e == 0.0) {
                throw new Exception(Messages.getString(BUNDLE_NAME, "Matrix3D.3"));
            }
            int i = 0;
            while (i < 4) {
                temp.coeffs[j][i] = temp.coeffs[j][i] / e;
                inv.coeffs[j][i] = inv.coeffs[j][i] / e;
                ++i;
            }
            int k = 0;
            while (k < 4) {
                if (k != j) {
                    e = -temp.coeffs[k][j];
                    int i2 = 0;
                    while (i2 < 4) {
                        temp.coeffs[k][i2] = temp.coeffs[k][i2] + e * temp.coeffs[j][i2];
                        inv.coeffs[k][i2] = inv.coeffs[k][i2] + e * inv.coeffs[j][i2];
                        ++i2;
                    }
                }
                ++k;
            }
            ++j;
        }
        return inv;
    }
}

