/*
 * Decompiled with CFR 0.152.
 */
package uibk.mtk.draw3d.axescube3d;

import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import uibk.mtk.draw3d.axescube3d.AxesCube3D;
import uibk.mtk.draw3d.base.Scene3D;
import uibk.mtk.geom.geom2d.Punkt2D;
import uibk.mtk.geom.geom2d.Vector2D;
import uibk.mtk.geom.geom3d.Punkt3D;
import uibk.mtk.geom.geom3d.Vector3D;

public class Tick {
    Punkt3D mc_pos;
    Vector3D mc_dir;
    AxesCube3D axes;
    boolean big = false;
    Point start = new Point();
    Point end = new Point();
    Point labelpos = new Point();
    String label;
    private boolean drawlabel;

    public Tick(AxesCube3D axes, Punkt3D posmc, Vector3D dirmc, boolean big, String label) {
        this.mc_pos = posmc;
        this.mc_dir = dirmc;
        this.big = big;
        this.axes = axes;
        this.label = label;
    }

    private void checkIntersection(Graphics g2) {
        FontMetrics metrics = g2.getFontMetrics();
        int height = metrics.getAscent();
        int length = metrics.stringWidth(this.label);
        Rectangle r = new Rectangle(this.labelpos.x, this.labelpos.y - height, length, height);
        this.axes.labelarea.add(r);
        int i = 0;
        while (i < this.axes.labelarea.size() - 1) {
            Rectangle2D rect = (Rectangle2D)this.axes.labelarea.elementAt(i);
            if (r.intersects(rect)) {
                this.drawlabel = false;
                break;
            }
            ++i;
        }
    }

    public void draw(Graphics2D g2) {
        g2.setColor(this.axes.getColor());
        if (this.big && this.drawlabel) {
            g2.drawString(this.label, this.labelpos.x, this.labelpos.y);
        }
        g2.drawLine(this.start.x, this.start.y, this.end.x, this.end.y);
    }

    public void compute(Graphics2D g2, Scene3D scene3d) {
        this.drawlabel = true;
        Punkt2D startp = scene3d.project(this.mc_pos);
        this.start.x = (int)startp.x;
        this.start.y = (int)startp.y;
        Vector2D tickdir = scene3d.projectVector(this.mc_pos, this.mc_dir);
        double scale = this.big ? 8 : 4;
        Punkt2D endp = startp.add(tickdir.scale(scale));
        this.end.x = (int)endp.x;
        this.end.y = (int)endp.y;
        if (this.big) {
            FontMetrics metrics = g2.getFontMetrics();
            int height = metrics.getHeight();
            int length = metrics.stringWidth(this.label);
            tickdir.normalize();
            byte direction = AxesCube3D.getDirection(tickdir);
            double offsetx = 0.0;
            double offsety = 0.0;
            offsety = (8 & direction) > 0 ? (double)(13 + height) : 13.0;
            offsetx = (2 & direction) > 0 ? 13.0 : (double)(13 + length);
            tickdir.x *= offsetx;
            tickdir.y *= offsety;
            this.labelpos.x = (int)(startp.x + tickdir.x);
            this.labelpos.y = (int)(startp.y + tickdir.y);
            this.checkIntersection(g2);
        }
    }
}

