/*
 * Decompiled with CFR 0.152.
 */
package uibk.mtk.math.rational;

import java.awt.Component;
import java.math.BigInteger;
import uibk.mtk.exception.ExceptionLevel;
import uibk.mtk.lang.Messages;
import uibk.mtk.math.NotANumberException;
import uibk.mtk.math.polynom.PolynomException;
import uibk.mtk.math.rational.MatrixException;
import uibk.mtk.math.rational.RationalMatrix;
import uibk.mtk.math.rational.RationalNumber;

public final class RationalMatrixUtil {
    static final String BUNDLE_NAME = "uibk.mtk.math.rational.messages";

    private RationalMatrixUtil() {
    }

    public static RationalMatrix transpose(RationalMatrix m) throws MatrixException {
        RationalMatrix r = new RationalMatrix(m.getColumnDim(), m.getRowDim());
        int i = 0;
        while (i < m.getRowDim()) {
            int j = 0;
            while (j < m.getColumnDim()) {
                r.setValueAt(j, i, m.getVauleAt(i, j));
                ++j;
            }
            ++i;
        }
        return r;
    }

    public static RationalMatrix getIdentityMatrix(int rowDim, int columnDim, int view, Component parentComponent) throws MatrixException {
        RationalMatrix ret = new RationalMatrix(rowDim, columnDim);
        int i = 0;
        while (i < rowDim) {
            int j = 0;
            while (j < columnDim) {
                try {
                    RationalNumber r = i == j ? new RationalNumber(1L, 1L, view, parentComponent) : new RationalNumber(0L, 1L, view, parentComponent);
                    ret.setValueAtIntern(i, j, r);
                }
                catch (NotANumberException e) {
                    e.printStackTrace();
                }
                ++j;
            }
            ++i;
        }
        return ret;
    }

    public static RationalMatrix getNullMatrix(int rowDim, int columnDim, int view, Component parentComponent) throws MatrixException {
        RationalMatrix ret = new RationalMatrix(rowDim, columnDim);
        int i = 0;
        while (i < rowDim) {
            int j = 0;
            while (j < columnDim) {
                try {
                    ret.setValueAtIntern(i, j, new RationalNumber(0L, 1L, view, parentComponent));
                }
                catch (NotANumberException notANumberException) {
                    // empty catch block
                }
                ++j;
            }
            ++i;
        }
        return ret;
    }

    public static RationalMatrix mul(RationalMatrix m1, RationalMatrix m2) throws MatrixException, NotANumberException, PolynomException {
        if (m1.getColumnDim() != m2.getRowDim()) {
            throw new MatrixException(Messages.getString(BUNDLE_NAME, "RationalMatrix.6"), ExceptionLevel.ERROR);
        }
        RationalMatrix r = new RationalMatrix(m1.getRowDim(), m2.getColumnDim());
        int k = 0;
        while (k < m2.getColumnDim()) {
            int i = 0;
            while (i < m1.getRowDim()) {
                RationalNumber tmp = new RationalNumber(0L, 1L, 0, null);
                int j = 0;
                while (j < m1.getColumnDim()) {
                    tmp = m1.getVauleAt(i, j).mul(m2.getVauleAt(j, k)).add(tmp);
                    ++j;
                }
                r.setValueAt(i, k, tmp);
                ++i;
            }
            ++k;
        }
        return r;
    }

    public static RationalMatrix forwordInsert(RationalMatrix L, RationalMatrix b) throws MatrixException, NotANumberException, PolynomException {
        if ((L == null || b == null) && b == null) {
            throw new MatrixException(Messages.getString(BUNDLE_NAME, "RationalMatrixUtil.0"), ExceptionLevel.WARNING);
        }
        if (!RationalMatrixUtil.isLowerTriangle(L)) {
            throw new MatrixException(Messages.getString(BUNDLE_NAME, "RationalMatrixUtil.1"), ExceptionLevel.ERROR);
        }
        RationalMatrix x = L.initXMatrix(b);
        int solveIndexColumn = 0;
        while (solveIndexColumn < b.getColumnDim()) {
            int solveIndexRow = 0;
            while (solveIndexRow < L.getRowDim()) {
                RationalNumber sum = new RationalNumber(0L, 1L, L.getView(), (Component)L);
                int j = 0;
                while (j < solveIndexRow) {
                    sum = sum.add(L.getVauleAt(solveIndexRow, j).mul(x.getVauleAt(j, solveIndexColumn)));
                    ++j;
                }
                x.setValueAt(solveIndexRow, solveIndexColumn, b.getVauleAt(solveIndexRow, solveIndexColumn).sub(sum).div(L.getVauleAt(solveIndexRow, solveIndexRow)));
                ++solveIndexRow;
            }
            ++solveIndexColumn;
        }
        return x;
    }

    public static RationalMatrix backwardInsert(RationalMatrix U, RationalMatrix b) throws MatrixException, NotANumberException, PolynomException {
        int nullRows = RationalMatrixUtil.isSolveAble(U, b, -1);
        RationalMatrix x = U.initXMatrix(b);
        int k = 0;
        while (k < b.getColumnDim()) {
            int i = U.getRowDim() - 1 - nullRows;
            while (i >= 0) {
                RationalNumber sum = new RationalNumber(0L, 1L, U.getView(), (Component)U);
                int j = U.getColumnDim() - 1;
                while (j > i) {
                    sum = sum.add(U.getVauleAt(i, j).mul(x.getVauleAt(j, k)));
                    --j;
                }
                x.setValueAt(i, k, b.getVauleAt(i, k).sub(sum).div(U.getVauleAt(i, i)));
                --i;
            }
            ++k;
        }
        return x;
    }

    public static RationalMatrix backwardInsert(RationalMatrix U, RationalMatrix x, int index, RationalMatrix b) throws MatrixException, NotANumberException, PolynomException {
        int nullRows = RationalMatrixUtil.isSolveAble(U, b, index);
        if (x == null) {
            throw new MatrixException(Messages.getString(BUNDLE_NAME, "RationalMatrixUtil.0"), ExceptionLevel.WARNING);
        }
        if (U.getColumnDim() != x.getRowDim() || x.getColumnDim() != b.getColumnDim()) {
            throw new MatrixException(Messages.getString(BUNDLE_NAME, "RationalMatrix.6"), ExceptionLevel.WARNING);
        }
        int k = 0;
        while (k < b.getColumnDim()) {
            int i = U.getRowDim() - 1 - nullRows;
            while (i >= 0) {
                RationalNumber sum = new RationalNumber(0L, 1L, U.getView(), (Component)U);
                int j = U.getColumnDim() - 1;
                while (j > i) {
                    sum = sum.add(U.getVauleAt(i, j).mul(x.getVauleAt(j, k)));
                    --j;
                }
                x.setValueAt(i, k, b.getVauleAt(i, k).sub(sum).div(U.getVauleAt(i, i)));
                --i;
            }
            ++k;
        }
        return x;
    }

    public static boolean isLowerTriangle(RationalMatrix M) throws MatrixException {
        if (M == null) {
            return false;
        }
        if (M.getRowDim() != M.getColumnDim()) {
            return false;
        }
        int i = 0;
        while (i < M.getRowDim()) {
            if (M.getVauleAt(i, i).getNumerator().compareTo(BigInteger.ZERO) == 0) {
                return false;
            }
            ++i;
        }
        i = 0;
        while (i < M.getRowDim()) {
            int j = i + 1;
            while (j < M.getColumnDim()) {
                if (M.getVauleAt(i, j).getNumerator().compareTo(BigInteger.ZERO) != 0) {
                    return false;
                }
                ++j;
            }
            ++i;
        }
        return true;
    }

    public static int isSolveAble(RationalMatrix A, RationalMatrix b, int index) throws NotANumberException, MatrixException, PolynomException {
        int min;
        if (A == null || b == null) {
            throw new MatrixException(Messages.getString(BUNDLE_NAME, "RationalMatrix.5"), ExceptionLevel.WARNING);
        }
        index = index < 0 ? 0 : index;
        int n = min = A.getRowDim() < A.getColumnDim() ? A.getRowDim() : A.getColumnDim();
        if (A.getIndexPivot() < min) {
            A.gaussAlgorithmus(false);
        }
        if (A.getRowDim() != b.getRowDim()) {
            throw new MatrixException(Messages.getString(BUNDLE_NAME, "RationalMatrix.4"), ExceptionLevel.ERROR);
        }
        int nullRows = 0;
        int i = b.getRowDim() - 1;
        while (i > -1) {
            boolean rowIsNull = true;
            int j = A.getColumnDim() - 1;
            while (j > -1) {
                RationalNumber r = A.getVauleAt(i, j);
                if (r.getNumerator().compareTo(BigInteger.ZERO) != 0) {
                    rowIsNull = false;
                    break;
                }
                --j;
            }
            if (!rowIsNull) break;
            ++nullRows;
            j = 0;
            while (j < b.getColumnDim()) {
                if (b.getVauleAt(i, j).getNumerator().compareTo(BigInteger.ZERO) != 0) {
                    throw new MatrixException(Messages.getString(BUNDLE_NAME, "RationalMatrix.9"), ExceptionLevel.WARNING);
                }
                ++j;
            }
            --i;
        }
        if (index == 0 && A.getRowDim() - nullRows != A.getColumnDim() - index) {
            throw new MatrixException(Messages.getString(BUNDLE_NAME, "RationalMatrix.10"), ExceptionLevel.WARNING);
        }
        return nullRows;
    }

    public static RationalMatrix getSubMatrix(RationalMatrix A, int row1, int row2, int column1, int column2) throws MatrixException {
        if (row2 < row1 || column2 < column1) {
            throw new MatrixException(Messages.getString(BUNDLE_NAME, "RationalMatrix.10"), ExceptionLevel.WARNING);
        }
        RationalMatrix ret = new RationalMatrix(row2 - row1 + 1, column2 - column1 + 1);
        int i = row1;
        while (i <= row2) {
            int j = column1;
            while (j <= column2) {
                ret.setValueAt(i - row1, j - column1, A.getVauleAt(i, j));
                ++j;
            }
            ++i;
        }
        return ret;
    }
}

