/*
 * Decompiled with CFR 0.152.
 */
package uibk.mtk.math.rational;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Point;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import uibk.mtk.exception.ExceptionLevel;
import uibk.mtk.lang.Messages;
import uibk.mtk.math.NotANumberException;
import uibk.mtk.math.polynom.PolynomException;
import uibk.mtk.math.rational.MatrixException;
import uibk.mtk.math.rational.RationalMatrixEvent;
import uibk.mtk.math.rational.RationalMatrixListener;
import uibk.mtk.math.rational.RationalMatrixUtil;
import uibk.mtk.math.rational.RationalNumber;
import uibk.mtk.swing.base.MPanel;

public class RationalMatrix
extends MPanel {
    static final String BUNDLE_NAME = "uibk.mtk.math.rational.messages";
    private Vector<RationalMatrixListener> listener = new Vector();
    private RationalNumber[][] data;
    private MPanel[][] panels;
    private MPanel[] columns;
    private int rowDim = 0;
    private int columnDim = 0;
    private int view = -1;
    int indexPivot = 0;
    private RationalMatrix L = null;
    private RationalMatrix permutS = null;
    private RationalMatrix permutZ = null;
    private RationalMatrix x = null;
    private RationalMatrix b = null;
    int nullRows = -1;
    private int solveIndexColumn = -1;
    private int solveInexColumn = -1;
    private boolean isSolved = false;

    public RationalMatrix(RationalNumber[][] data) throws MatrixException {
        if (data == null || data[0] == null || data[0][0] == null) {
            throw new MatrixException(Messages.getString(BUNDLE_NAME, "RationalMatrix.0"), ExceptionLevel.ERROR);
        }
        this.data = data;
        this.rowDim = data.length;
        this.columnDim = data[0].length;
        this.view = data[0][0].getView();
        this.initPanels();
        this.intAlgorithm();
    }

    public RationalMatrix(int rowDimension, int columnDimension) throws MatrixException {
        if (rowDimension < 1 || columnDimension < 1) {
            throw new MatrixException(Messages.getString(BUNDLE_NAME, "RationalMatrix.1"), ExceptionLevel.ERROR);
        }
        this.data = new RationalNumber[rowDimension][columnDimension];
        this.rowDim = rowDimension;
        this.columnDim = columnDimension;
        this.view = -1;
        this.initPanels();
        this.intAlgorithm();
    }

    private void intAlgorithm() {
        this.indexPivot = 0;
        this.isSolved = false;
        this.nullRows = -1;
        this.solveIndexColumn = -1;
        this.solveInexColumn = -1;
        this.x = null;
        this.b = null;
    }

    private void initPanels() {
        this.setLayout(new BoxLayout(this, 0));
        this.panels = new MPanel[this.rowDim][this.columnDim];
        this.columns = new MPanel[this.columnDim];
        int j = 0;
        while (j < this.columnDim) {
            this.columns[j] = new MPanel();
            this.columns[j].setLayout(new BoxLayout(this.columns[j], 1));
            this.add(this.columns[j]);
            int i = 0;
            while (i < this.rowDim) {
                this.panels[i][j] = new MPanel();
                this.panels[i][j].setLayout(new BorderLayout());
                this.panels[i][j].setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
                if (this.data[i][j] != null) {
                    this.panels[i][j].add((Component)this.data[i][j], "Center");
                }
                this.columns[j].add(this.panels[i][j]);
                ++i;
            }
            ++j;
        }
    }

    public void setValueAt(int row, int column, RationalNumber r) throws MatrixException {
        this.setValueAtIntern(row, column, r);
        this.setMatrixToIdentity(this.permutS);
        this.setMatrixToIdentity(this.permutZ);
        this.setMatrixToIdentity(this.L);
        for (RationalMatrixListener rml : this.listener) {
            rml.valueSet(new RationalMatrixEvent(this, this, row, column));
        }
        this.intAlgorithm();
    }

    public void setValueAtIntern(int row, int column, RationalNumber r) throws MatrixException {
        if (r == null || row >= this.rowDim || column >= this.columnDim) {
            throw new MatrixException(Messages.getString(BUNDLE_NAME, "RationalMatrix.2"), ExceptionLevel.ERROR);
        }
        r.setFont(this.getFont());
        r.setBackground(this.getBackground());
        this.data[row][column] = r;
        this.panels[row][column].removeAll();
        this.panels[row][column].add((Component)this.data[row][column], "Center");
        if (this.view == -1) {
            this.view = r.getView();
        } else if (this.view != r.getView()) {
            r.setView(this.view);
        }
    }

    public RationalNumber getVauleAt(int row, int column) throws MatrixException {
        if (row >= this.rowDim || column >= this.columnDim || this.data[row][column] == null) {
            throw new MatrixException(Messages.getString(BUNDLE_NAME, "RationalMatrix.2"), ExceptionLevel.ERROR);
        }
        return this.data[row][column];
    }

    public void gaussStep(int row, int column, boolean columnPivot) throws MatrixException, NotANumberException, PolynomException {
        this.isPivotLegal(row, column, columnPivot);
        if (this.data[row][column].getDoubleValue() == 0.0) {
            throw new MatrixException(Messages.getString(BUNDLE_NAME, "RationalMatrix.3"), ExceptionLevel.INFO);
        }
        this.changeRowsIntern(this.indexPivot, row);
        this.changeColumnsIntern(this.indexPivot, column);
        RationalNumber pivot = this.data[this.indexPivot][this.indexPivot];
        int i = this.indexPivot + 1;
        while (i < this.rowDim) {
            RationalNumber r = this.data[i][this.indexPivot].div(pivot);
            this.subIntern(this.indexPivot, i, r);
            ++i;
        }
        ++this.indexPivot;
    }

    public void gaussStep(boolean columnPivot) throws NotANumberException, MatrixException, PolynomException {
        if (!this.haveLigalPivot(columnPivot)) {
            return;
        }
        int[] index = this.indexMaxValueAbs(this.indexPivot, this.indexPivot, columnPivot);
        if (this.data[index[0]][index[1]].getDoubleValue() == 0.0) {
            throw new MatrixException(Messages.getString(BUNDLE_NAME, "RationalMatrix.7"), ExceptionLevel.INFO);
        }
        this.gaussStep(index[0], index[1], columnPivot);
    }

    public RationalMatrix gaussAlgorithmus(boolean columnPivot) throws NotANumberException, MatrixException, PolynomException {
        while (this.haveLigalPivot(columnPivot)) {
            int[] index = this.indexMaxValueAbs(this.indexPivot, this.indexPivot, columnPivot);
            if (this.data[index[0]][index[1]].getDoubleValue() == 0.0) break;
            this.gaussStep(columnPivot);
        }
        return this;
    }

    public void changeRows(int row1, int row2) throws MatrixException {
        this.changeRowsIntern(row1, row2);
        this.intAlgorithm();
    }

    public void changeColumns(int col1, int col2) throws MatrixException {
        this.changeColumnsIntern(col1, col2);
        this.intAlgorithm();
    }

    private void changeRowsIntern(int row1, int row2) throws MatrixException {
        RationalNumber tmp;
        this.permutZ = this.getPermuttationZeilen();
        if (row1 == row2 || row1 < 0 || row2 < 0) {
            return;
        }
        if (row1 >= this.rowDim || row2 >= this.rowDim) {
            throw new MatrixException(Messages.getString(BUNDLE_NAME, "RationalMatrix.2"), ExceptionLevel.ERROR);
        }
        int i = 0;
        while (i < this.columnDim) {
            tmp = this.data[row1][i];
            this.setValueAtIntern(row1, i, this.data[row2][i]);
            this.setValueAtIntern(row2, i, tmp);
            ++i;
        }
        i = 0;
        while (i < this.permutZ.columnDim) {
            tmp = this.permutZ.data[i][row1];
            this.permutZ.setValueAtIntern(i, row1, this.permutZ.data[i][row2]);
            this.permutZ.setValueAtIntern(i, row2, tmp);
            ++i;
        }
        if (this.L != null) {
            i = 0;
            while (i < this.indexPivot) {
                tmp = this.L.data[row1][i];
                this.L.setValueAtIntern(row1, i, this.L.data[row2][i]);
                this.L.setValueAtIntern(row2, i, tmp);
                ++i;
            }
        }
    }

    private void changeColumnsIntern(int col1, int col2) throws MatrixException {
        RationalNumber tmp;
        this.permutS = this.getPermuttationSpalten();
        if (col1 == col2 || col1 < 0 || col2 < 0) {
            return;
        }
        if (col1 >= this.rowDim || col1 >= this.rowDim) {
            throw new MatrixException(Messages.getString(BUNDLE_NAME, "RationalMatrix.2"), ExceptionLevel.ERROR);
        }
        int i = 0;
        while (i < this.rowDim) {
            tmp = this.data[i][col1];
            this.setValueAtIntern(i, col1, this.data[i][col2]);
            this.setValueAtIntern(i, col2, tmp);
            ++i;
        }
        i = 0;
        while (i < this.permutS.rowDim) {
            tmp = this.permutS.data[col1][i];
            this.permutS.setValueAtIntern(col1, i, this.permutS.data[col2][i]);
            this.permutS.setValueAtIntern(col2, i, tmp);
            ++i;
        }
    }

    public RationalMatrix subIntern(int row1, int row2, RationalNumber t) throws MatrixException, NotANumberException, PolynomException {
        this.L = this.getL();
        if (row1 >= this.rowDim || row2 >= this.rowDim) {
            throw new MatrixException(Messages.getString(BUNDLE_NAME, "RationalMatrix.2"), ExceptionLevel.ERROR);
        }
        int i = 0;
        while (i < this.columnDim) {
            this.setValueAtIntern(row2, i, this.data[row2][i].sub(t.mul(this.data[row1][i])));
            ++i;
        }
        i = row1;
        while (i < this.L.columnDim) {
            this.L.setValueAtIntern(row2, i, this.L.data[row2][i].add(t.mul(this.L.data[row1][i])));
            ++i;
        }
        this.isSolved = false;
        return this;
    }

    public synchronized void setView(int view) {
        if (this.view != view) {
            int i = 0;
            while (i < this.rowDim) {
                int j = 0;
                while (j < this.columnDim) {
                    if (this.data[i][j] != null) {
                        this.data[i][j].setView(view);
                    }
                    ++j;
                }
                ++i;
            }
            this.view = view;
        }
    }

    public int getView() {
        return this.view;
    }

    public int[] setBorder(int xCoordinate, int yCoordinate, Color c) {
        int[] ret = new int[]{-1, -1};
        if (c == null) {
            c = Color.black;
        }
        if (this.columns == null || this.panels == null || this.panels[0] == null || this.panels[0][0] == null) {
            return ret;
        }
        int i = 0;
        while (i < this.rowDim) {
            int j = 0;
            while (j < this.columnDim) {
                int width = this.panels[i][j].getWidth();
                int height = this.panels[i][j].getHeight();
                Point p = this.panels[i][j].getLocation();
                p.x = this.columns[j].getLocation().x;
                if (xCoordinate > p.x && xCoordinate < p.x + width && yCoordinate > p.y && yCoordinate < p.y + height) {
                    this.panels[i][j].setBorder(BorderFactory.createLineBorder(c));
                    ret[0] = i;
                    ret[1] = j;
                } else {
                    this.panels[i][j].setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
                }
                ++j;
            }
            ++i;
        }
        return ret;
    }

    public int[] setBorderByIndex(int rowIndex, int columnIndex, Color c) {
        int[] ret = new int[]{-1, -1};
        if (c == null) {
            c = Color.black;
        }
        int i = 0;
        while (i < this.rowDim) {
            int j = 0;
            while (j < this.columnDim) {
                if (rowIndex == i && columnIndex == j) {
                    this.panels[i][j].setBorder(BorderFactory.createLineBorder(c));
                    ret[0] = i;
                    ret[1] = j;
                } else {
                    this.panels[i][j].setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
                }
                ++j;
            }
            ++i;
        }
        return ret;
    }

    public int[] indexMaxValueAbs() throws NotANumberException, MatrixException, PolynomException {
        return this.indexMaxValueAbs(0, 0, false);
    }

    public int[] indexMaxValueAbs(int initRowIndex, int initColumnIndex, boolean searchOneColumn) throws NotANumberException, MatrixException, PolynomException {
        int[] ret = new int[]{-1, -1};
        if (this.data == null || this.data[0] == null || this.data[0][0] == null) {
            return ret;
        }
        if (initRowIndex >= this.rowDim || initColumnIndex >= this.columnDim) {
            throw new MatrixException(Messages.getString(BUNDLE_NAME, "RationalMatrix.2"), ExceptionLevel.ERROR);
        }
        int cD = this.columnDim;
        if (searchOneColumn) {
            cD = initColumnIndex + 1;
        }
        RationalNumber max = null;
        int i = initRowIndex;
        while (i < this.rowDim) {
            int j = initColumnIndex;
            while (j < cD) {
                if (this.data[i][j] != null) {
                    if (max == null) {
                        max = this.data[i][j].abs();
                        ret[0] = i;
                        ret[1] = j;
                    } else if (this.data[i][j].abs().compareTo(max) == 1) {
                        max = this.data[i][j].abs();
                        ret[0] = i;
                        ret[1] = j;
                    }
                }
                ++j;
            }
            ++i;
        }
        return ret;
    }

    public int getColumnDim() {
        return this.columnDim;
    }

    public int getRowDim() {
        return this.rowDim;
    }

    public RationalMatrix solve(RationalMatrix b) throws MatrixException, NotANumberException, PolynomException {
        RationalMatrix x = null;
        this.initSolve(x, b);
        while (!this.isSolved()) {
            x = this.solveStep(true);
        }
        return x;
    }

    public void initSolve(RationalMatrix x, RationalMatrix b) throws NotANumberException, MatrixException, PolynomException {
        if (this.solveIndexColumn != -1) {
            return;
        }
        if (this.getRowDim() != b.getRowDim()) {
            throw new MatrixException(Messages.getString(BUNDLE_NAME, "RationalMatrix.4"), ExceptionLevel.ERROR);
        }
        RationalMatrix T = RationalMatrixUtil.transpose(this.getPermuttationZeilen().clone());
        RationalMatrix Tb = RationalMatrixUtil.mul(T, b);
        this.b = RationalMatrixUtil.forwordInsert(this.getL(), Tb);
        int min = this.columnDim < this.rowDim ? this.columnDim : this.rowDim;
        int i = 0;
        while (i < min) {
            if (this.getVauleAt(i, i).getDoubleValue() == 0.0) break;
            ++i;
        }
        int rank = i;
        this.nullRows = RationalMatrixUtil.isSolveAble(this, this.b, this.columnDim - rank);
        this.x = x != null ? x : this.initXMatrix(this.b);
        this.solveIndexColumn = this.rowDim - 1 - this.nullRows;
        this.solveInexColumn = 0;
        if (this.solveIndexColumn < 0) {
            this.isSolved = true;
        }
    }

    public RationalMatrix solveStep(boolean permutX) throws MatrixException, NotANumberException, PolynomException {
        if (this.isSolved) {
            return this.x;
        }
        RationalNumber sum = new RationalNumber(0L, 1L, this.view, (Component)this);
        int j = this.columnDim - 1;
        while (j > this.solveIndexColumn) {
            sum = sum.add(this.getVauleAt(this.solveIndexColumn, j).mul(this.x.getVauleAt(j, this.solveInexColumn)));
            --j;
        }
        this.x.setValueAt(this.solveIndexColumn, this.solveInexColumn, this.b.getVauleAt(this.solveIndexColumn, this.solveInexColumn).sub(sum).div(this.getVauleAt(this.solveIndexColumn, this.solveIndexColumn)));
        if (this.solveIndexColumn == 0) {
            this.solveIndexColumn = this.rowDim - 1 - this.nullRows;
            ++this.solveInexColumn;
        } else {
            --this.solveIndexColumn;
        }
        if (this.solveInexColumn == this.b.columnDim) {
            if (permutX) {
                this.x = RationalMatrixUtil.mul(RationalMatrixUtil.transpose(this.permutS), this.x);
            }
            this.isSolved = true;
        }
        return this.x;
    }

    public RationalMatrix getPermuttationSpalten() throws MatrixException {
        if (this.permutS == null) {
            this.permutS = RationalMatrixUtil.getIdentityMatrix(this.columnDim, this.columnDim, this.view, this);
        }
        return this.permutS;
    }

    public RationalMatrix getPermuttationZeilen() throws MatrixException {
        if (this.permutZ == null) {
            this.permutZ = RationalMatrixUtil.getIdentityMatrix(this.rowDim, this.rowDim, this.view, this);
        }
        return this.permutZ;
    }

    public RationalMatrix getL() throws MatrixException {
        if (this.L == null) {
            this.L = RationalMatrixUtil.getIdentityMatrix(this.rowDim, this.rowDim, this.view, this);
        }
        return this.L;
    }

    public void setBackground(Color c) {
        super.setBackground(c);
        if (c != null && this.data != null) {
            int i = 0;
            while (i < this.rowDim) {
                int j = 0;
                while (j < this.columnDim) {
                    if (this.data[i][j] != null) {
                        this.data[i][j].setBackground(c);
                    }
                    this.panels[i][j].setBackground(c);
                    ++j;
                }
                ++i;
            }
        }
    }

    public void setFont(Font f) {
        super.setFont(f);
        if (f != null && this.data != null) {
            RationalNumber[][] rationalNumberArray = this.data;
            int n = this.data.length;
            int n2 = 0;
            while (n2 < n) {
                RationalNumber[] row = rationalNumberArray[n2];
                if (row != null) {
                    RationalNumber[] rationalNumberArray2 = row;
                    int n3 = row.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        RationalNumber r = rationalNumberArray2[n4];
                        if (r != null) {
                            r.setFont(f);
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        }
    }

    public RationalMatrix clone() {
        try {
            int j;
            RationalNumber[][] data = new RationalNumber[this.rowDim][this.columnDim];
            int i = 0;
            while (i < this.rowDim) {
                int j2 = 0;
                while (j2 < this.columnDim) {
                    data[i][j2] = this.getVauleAt(i, j2).clone();
                    ++j2;
                }
                ++i;
            }
            RationalMatrix r = new RationalMatrix(data);
            r.indexPivot = this.indexPivot;
            if (this.L != null) {
                RationalMatrix p;
                data = new RationalNumber[this.L.rowDim][this.L.columnDim];
                int i2 = 0;
                while (i2 < this.L.rowDim) {
                    j = 0;
                    while (j < this.L.columnDim) {
                        data[i2][j] = this.L.getVauleAt(i2, j).clone();
                        ++j;
                    }
                    ++i2;
                }
                r.L = p = new RationalMatrix(data);
            }
            if (this.permutS != null) {
                RationalMatrix p;
                data = new RationalNumber[this.permutS.rowDim][this.permutS.columnDim];
                int i3 = 0;
                while (i3 < this.permutS.rowDim) {
                    j = 0;
                    while (j < this.permutS.columnDim) {
                        data[i3][j] = this.permutS.getVauleAt(i3, j).clone();
                        ++j;
                    }
                    ++i3;
                }
                r.permutS = p = new RationalMatrix(data);
            }
            if (this.permutZ != null) {
                RationalMatrix p;
                data = new RationalNumber[this.permutZ.rowDim][this.permutZ.columnDim];
                int i4 = 0;
                while (i4 < this.permutZ.rowDim) {
                    j = 0;
                    while (j < this.permutZ.columnDim) {
                        data[i4][j] = this.permutZ.getVauleAt(i4, j).clone();
                        ++j;
                    }
                    ++i4;
                }
                r.permutZ = p = new RationalMatrix(data);
            }
            if (this.b != null) {
                RationalMatrix bneu;
                data = new RationalNumber[this.b.rowDim][this.b.columnDim];
                int i5 = 0;
                while (i5 < this.b.rowDim) {
                    j = 0;
                    while (j < this.b.columnDim) {
                        data[i5][j] = this.b.getVauleAt(i5, j).clone();
                        ++j;
                    }
                    ++i5;
                }
                r.b = bneu = new RationalMatrix(data);
            }
            if (this.x != null) {
                RationalMatrix xNeu;
                data = new RationalNumber[this.x.rowDim][this.x.columnDim];
                int i6 = 0;
                while (i6 < this.x.rowDim) {
                    j = 0;
                    while (j < this.x.columnDim) {
                        data[i6][j] = this.x.getVauleAt(i6, j).clone();
                        ++j;
                    }
                    ++i6;
                }
                r.x = xNeu = new RationalMatrix(data);
            }
            r.solveIndexColumn = this.solveIndexColumn;
            r.solveInexColumn = this.solveInexColumn;
            r.nullRows = this.nullRows;
            r.isSolved = this.isSolved;
            return r;
        }
        catch (MatrixException e) {
            return null;
        }
    }

    public String toString() {
        String s = "";
        RationalNumber[][] rationalNumberArray = this.data;
        int n = this.data.length;
        int n2 = 0;
        while (n2 < n) {
            RationalNumber[] row;
            RationalNumber[] rationalNumberArray2 = row = rationalNumberArray[n2];
            int n3 = row.length;
            int n4 = 0;
            while (n4 < n3) {
                RationalNumber r = rationalNumberArray2[n4];
                if (r != null) {
                    s = String.valueOf(s) + r.toString() + "  ";
                }
                ++n4;
            }
            s = String.valueOf(s) + "\n";
            ++n2;
        }
        return s;
    }

    public int getIndexPivot() {
        return this.indexPivot;
    }

    public boolean haveLigalPivot(boolean columnPivot) {
        int min;
        int n = min = this.rowDim < this.columnDim ? this.rowDim : this.columnDim;
        if (this.indexPivot >= min) {
            return false;
        }
        int rD = this.rowDim;
        if (columnPivot) {
            rD = this.indexPivot + 1;
        }
        int i = this.indexPivot;
        while (i < rD) {
            int j = this.indexPivot;
            while (j < this.columnDim) {
                if (this.data[i][j].getDoubleValue() != 0.0) {
                    return true;
                }
                ++j;
            }
            ++i;
        }
        return false;
    }

    public void isPivotLegal(int row, int column, boolean columnPivot) throws MatrixException {
        if (row >= this.rowDim || column >= this.columnDim) {
            throw new MatrixException(Messages.getString(BUNDLE_NAME, "RationalMatrix.2"), ExceptionLevel.ERROR);
        }
        if (columnPivot ? row < this.indexPivot || column != this.indexPivot : row < this.indexPivot || column < this.indexPivot) {
            throw new MatrixException(Messages.getString(BUNDLE_NAME, "RationalMatrix.3"), ExceptionLevel.INFO);
        }
        if (this.indexPivot >= this.rowDim || this.indexPivot >= this.columnDim) {
            throw new MatrixException(Messages.getString(BUNDLE_NAME, "RationalMatrix.7"), ExceptionLevel.INFO);
        }
    }

    public boolean isSolved() {
        return this.isSolved;
    }

    public void setSolved(boolean b) {
        this.isSolved = b;
    }

    private RationalMatrix setMatrixToIdentity(RationalMatrix m) {
        if (m == null) {
            return null;
        }
        int i = 0;
        while (i < m.rowDim) {
            int j = 0;
            while (j < m.columnDim) {
                try {
                    RationalNumber r = i == j ? new RationalNumber(1L, 1L, m.getView(), (Component)this) : new RationalNumber(0L, 1L, m.getView(), (Component)this);
                    m.setValueAtIntern(i, j, r);
                }
                catch (NotANumberException e) {
                    e.printStackTrace();
                }
                catch (MatrixException e) {
                    e.printStackTrace();
                }
                ++j;
            }
            ++i;
        }
        return m;
    }

    public void addRationalMatrixListener(RationalMatrixListener rml) {
        this.listener.add(rml);
    }

    public void removeRationalMatrixListener(RationalMatrixListener rml) {
        this.listener.remove(rml);
    }

    public RationalMatrix initXMatrix(RationalMatrix b) throws MatrixException {
        if (b == null) {
            return null;
        }
        RationalMatrix x = new RationalMatrix(this.columnDim, b.columnDim);
        this.solveIndexColumn = -1;
        return x;
    }

    public int getSolveIndexRow() {
        return this.solveIndexColumn;
    }

    public void setIndexPivot(int indexPivot) {
        this.indexPivot = indexPivot;
    }
}

