/*
 * Decompiled with CFR 0.152.
 */
package uibk.mtk.math.rational;

import java.util.Vector;
import uibk.mtk.exception.ExceptionLevel;
import uibk.mtk.lang.Messages;
import uibk.mtk.math.NotANumberException;
import uibk.mtk.math.polynom.PolynomException;
import uibk.mtk.math.rational.MatrixException;
import uibk.mtk.math.rational.RationalMatrix;
import uibk.mtk.math.rational.RationalMatrixUtil;
import uibk.mtk.math.rational.RationalNumber;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MatrixAttributes {
    static final String BUNDLE_NAME = "uibk.mtk.math.rational.messages";
    private final RationalMatrix m;
    private final RationalNumber det;
    private final int columnDim;
    private final int rowDim;
    private final int rank;
    private final int kernDim;
    private final Vector<RationalMatrix> basisKern = new Vector();

    public MatrixAttributes(RationalMatrix A) throws NotANumberException, MatrixException, PolynomException {
        int i;
        if (A == null) {
            throw new MatrixException("Ung\u00fcltige Matrix", ExceptionLevel.ERROR);
        }
        this.m = A.clone();
        this.m.gaussAlgorithmus(false);
        this.columnDim = this.m.getColumnDim();
        this.rowDim = this.m.getRowDim();
        if (this.columnDim != this.rowDim) {
            this.det = null;
        } else {
            RationalNumber det = new RationalNumber(this.m.getView(), this.m);
            i = 0;
            while (i < this.columnDim) {
                det = det.mul(this.m.getVauleAt(i, i));
                ++i;
            }
            this.det = det;
        }
        int min = this.columnDim < this.rowDim ? this.columnDim : this.rowDim;
        i = 0;
        while (i < min) {
            if (this.m.getVauleAt(i, i).getDoubleValue() == 0.0) break;
            ++i;
        }
        this.rank = i;
        this.kernDim = this.columnDim - this.rank;
        if (this.kernDim > 0) {
            try {
                RationalMatrix x = RationalMatrixUtil.getNullMatrix(this.m.getColumnDim(), this.kernDim, 0, null);
                int k = 0;
                while (k < this.kernDim) {
                    x.setValueAt(x.getRowDim() - k - 1, k, new RationalNumber(1L, 1L, 0, null));
                    ++k;
                }
                RationalMatrix b = RationalMatrixUtil.backwardInsert(this.m, x, this.kernDim, RationalMatrixUtil.getNullMatrix(this.m.getRowDim(), x.getColumnDim(), 0, null));
                RationalMatrix T = RationalMatrixUtil.transpose(this.m.getPermuttationSpalten());
                b = RationalMatrixUtil.mul(T, b);
                int j = 0;
                while (j < b.getColumnDim()) {
                    this.basisKern.add(RationalMatrixUtil.getSubMatrix(b, 0, b.getRowDim() - 1, j, j));
                    ++j;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public int getColumnDim() {
        return this.columnDim;
    }

    public RationalNumber getDet() throws MatrixException {
        if (this.m.getColumnDim() != this.m.getRowDim() || this.det == null) {
            throw new MatrixException(Messages.getString(BUNDLE_NAME, "RationalValues.0"), ExceptionLevel.ERROR);
        }
        return this.det;
    }

    public int getKernDim() {
        return this.kernDim;
    }

    public int getRank() {
        return this.rank;
    }

    public int getRowDim() {
        return this.rowDim;
    }

    public String getDim() {
        return String.valueOf(this.rowDim) + "x" + this.columnDim;
    }

    public String toString() {
        String ret = "Dim: " + this.getDim() + "; Det: " + this.det + "; rank: " + this.rank + "; kernDim: " + this.kernDim + "\nBasis Kern: \n";
        for (RationalMatrix mat : this.basisKern) {
            ret = String.valueOf(ret) + mat.toString();
        }
        return ret;
    }

    public Vector<RationalMatrix> getBasisKern() {
        return this.basisKern;
    }
}

