/*
 * Decompiled with CFR 0.152.
 */
package uibk.mtk.math.polynom;

import java.math.BigInteger;
import java.util.HashMap;
import java.util.Vector;
import uibk.mtk.math.polynom.Monom;
import uibk.mtk.math.polynom.PolynomException;
import uibk.mtk.math.polynom.Variables;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Polynom {
    private HashMap<Variables, Monom> p = new HashMap();

    public Polynom() {
        Monom m = Monom.getZERO();
        this.p.put(m.variables, m);
    }

    private Polynom(HashMap<Variables, Monom> p) {
        this.p = p;
    }

    public Polynom(BigInteger i) {
        Monom m = new Monom(Variables.ONE, i);
        this.p.put(m.variables, m);
    }

    public Polynom(Monom m) {
        m = m == null ? Monom.getZERO() : m.clone();
        this.p.put(m.variables, m);
    }

    public Polynom(String var) {
        Monom m = new Monom(var, BigInteger.ONE);
        this.p.put(m.variables, m);
    }

    public Polynom multiply(BigInteger i) {
        Polynom ret = this.clone();
        for (Monom c : ret.p.values()) {
            c.multiply(i);
        }
        return ret;
    }

    public Polynom multiply(Monom m) throws PolynomException {
        Polynom ret = this.clone();
        m = m.clone();
        for (Monom c : ret.p.values()) {
            c.multiply(m);
        }
        return ret;
    }

    public Polynom multiply(Polynom pol) throws PolynomException {
        Vector<Monom> tmp = new Vector<Monom>();
        for (Monom m1 : this.p.values()) {
            for (Monom m2 : pol.p.values()) {
                Monom m3 = m1.clone();
                m3.multiply(m2.clone());
                tmp.add(m3);
            }
        }
        HashMap<Variables, Monom> p = new HashMap<Variables, Monom>();
        p.put(((Monom)tmp.firstElement()).variables, (Monom)tmp.firstElement());
        Polynom ret = new Polynom(p);
        int i = 1;
        while (i < tmp.size()) {
            ret = ret.add((Monom)tmp.get(i));
            ++i;
        }
        return ret;
    }

    public Polynom divide(BigInteger i) {
        Polynom ret = this.clone();
        for (Monom c : ret.p.values()) {
            c.divide(i);
        }
        return ret;
    }

    public Polynom add(BigInteger i) throws PolynomException {
        return this.add(new Monom(Variables.ONE, i));
    }

    public Polynom add(Monom m) throws PolynomException {
        Polynom ret = this.clone();
        m = m.clone();
        if (ret.p.containsKey(m.variables)) {
            ret.p.get(m.variables).add(m);
        } else {
            ret.p.put(m.variables, m);
        }
        return ret;
    }

    public Polynom add(Polynom pol) throws PolynomException {
        Polynom ret = this.clone();
        for (Monom m : pol.p.values()) {
            ret = ret.add(m);
        }
        return ret;
    }

    public Polynom subtract(BigInteger i) throws PolynomException {
        return this.subtract(new Monom(Variables.ONE, i));
    }

    public Polynom subtract(Monom m) throws PolynomException {
        Polynom ret = this.clone();
        m = m.clone();
        if (ret.p.containsKey(m.variables)) {
            ret.p.get(m.variables).subtract(m);
        } else {
            Monom c_tmp = new Monom(m.variables, m.coefficient.multiply(new BigInteger("-1")));
            ret.p.put(c_tmp.variables, c_tmp);
        }
        return ret;
    }

    public String toString() {
        String ret = "";
        for (Monom c : this.p.values()) {
            if (ret.length() != 0 && c.coefficient.signum() != -1) {
                ret = String.valueOf(ret) + "+";
            }
            ret = String.valueOf(ret) + c.toString();
        }
        if (ret.length() == 0) {
            ret = String.valueOf(ret) + "0";
        }
        return ret;
    }

    public BigInteger getGcd() {
        BigInteger gcd = null;
        for (Monom c : this.p.values()) {
            gcd = gcd == null ? c.coefficient : c.coefficient.gcd(gcd);
        }
        return gcd;
    }

    public Polynom clone() {
        HashMap<Variables, Monom> p_tmp = new HashMap<Variables, Monom>();
        for (Monom m : this.p.values()) {
            m = m.clone();
            p_tmp.put(m.getVars(), m);
        }
        return new Polynom(p_tmp);
    }
}

