/*
 * Decompiled with CFR 0.152.
 */
package uibk.applets.gaussAlgorithmus;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.math.BigInteger;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import uibk.applets.gaussAlgorithmus.AppletGaussAlgorithmus;
import uibk.mtk.lang.Messages;
import uibk.mtk.math.NotANumberException;
import uibk.mtk.math.polynom.Polynom;
import uibk.mtk.math.polynom.PolynomException;
import uibk.mtk.math.rational.MatrixAttributes;
import uibk.mtk.math.rational.MatrixException;
import uibk.mtk.math.rational.RationalMatrix;
import uibk.mtk.math.rational.RationalMatrixEvent;
import uibk.mtk.math.rational.RationalMatrixListener;
import uibk.mtk.math.rational.RationalNumber;
import uibk.mtk.swing.base.MPanel;
import uibk.mtk.swing.base.TitledPanel;

public class PanelMatrixParameter
extends MPanel
implements RationalMatrixListener {
    private final AppletGaussAlgorithmus main;
    private TitledPanel panelDim;
    private TitledPanel panelDet;
    private TitledPanel panelRank;
    private TitledPanel panelKern;
    private MPanel panelBasisKern;
    private Vector<RationalMatrix> basisKern = null;
    private MatrixAttributes matrixAttributes = null;

    public PanelMatrixParameter(AppletGaussAlgorithmus main) {
        this.main = main;
        this.initPanel();
    }

    private void initPanel() {
        this.setLayout(new BoxLayout(this, 1));
        this.add(this.dimensionPanel());
        this.add(this.determinantPanel());
        this.add(this.rankPanel());
        this.add(this.kernPanel());
        this.add(this.basisKernPanel());
        this.add(Box.createHorizontalGlue());
    }

    private TitledPanel dimensionPanel() {
        this.panelDim = new TitledPanel(Messages.getString("uibk.applets.gaussAlgorithmus.messages", "PanelKenngroessen.0"));
        this.panelDim.setLayout(new BorderLayout());
        this.panelDim.setMaximumSize(new Dimension(10000, 50));
        return this.panelDim;
    }

    private TitledPanel determinantPanel() {
        this.panelDet = new TitledPanel(Messages.getString("uibk.applets.gaussAlgorithmus.messages", "PanelKenngroessen.1"));
        this.panelDet.setLayout(new BorderLayout());
        this.panelDet.setMaximumSize(new Dimension(10000, 50));
        return this.panelDet;
    }

    private TitledPanel rankPanel() {
        this.panelRank = new TitledPanel(Messages.getString("uibk.applets.gaussAlgorithmus.messages", "PanelKenngroessen.2"));
        this.panelRank.setLayout(new BorderLayout());
        this.panelRank.setMaximumSize(new Dimension(10000, 50));
        return this.panelRank;
    }

    private TitledPanel kernPanel() {
        this.panelKern = new TitledPanel(Messages.getString("uibk.applets.gaussAlgorithmus.messages", "PanelKenngroessen.3"));
        this.panelKern.setLayout(new BorderLayout());
        this.panelKern.setMaximumSize(new Dimension(10000, 50));
        return this.panelKern;
    }

    private MPanel basisKernPanel() {
        TitledPanel panel = new TitledPanel(Messages.getString("uibk.applets.gaussAlgorithmus.messages", "PanelKenngroessen.4"));
        panel.setLayout(new BorderLayout());
        panel.setPreferredSize(new Dimension(1000, 1000));
        panel.setMaximumSize(new Dimension(10000, 10000));
        this.panelBasisKern = new MPanel();
        JScrollPane scroll = new JScrollPane(this.panelBasisKern);
        scroll.setBorder(BorderFactory.createEmptyBorder());
        panel.add(scroll);
        return panel;
    }

    public void setMatrixParameter(RationalMatrix A) throws NotANumberException, MatrixException, PolynomException {
        this.panelDim.removeAll();
        this.panelDet.removeAll();
        this.panelRank.removeAll();
        this.panelKern.removeAll();
        this.panelBasisKern.removeAll();
        if (A == null) {
            this.matrixAttributes = null;
            return;
        }
        this.matrixAttributes = new MatrixAttributes(A);
        this.panelDim.add(new JLabel(this.matrixAttributes.getDim()));
        try {
            this.panelDet.add((Component)new JLabel(this.matrixAttributes.getDet().toString()), "Center");
        }
        catch (Exception e) {
            JLabel text = new JLabel(e.getMessage());
            this.panelDet.add((Component)text, "Center");
        }
        this.panelRank.add(new JLabel(String.valueOf(this.matrixAttributes.getRank())));
        this.panelKern.add(new JLabel(String.valueOf(this.matrixAttributes.getKernDim())));
        if (this.matrixAttributes.getKernDim() > 0) {
            RationalMatrix x = new RationalMatrix(this.matrixAttributes.getColumnDim(), 1);
            int i = 0;
            while (i < x.getRowDim()) {
                x.setValueAt(i, 0, new RationalNumber(new Polynom("x[" + (i + 1) + "]"), new Polynom(BigInteger.ONE), 1, (Component)this));
                ++i;
            }
            this.panelBasisKern.add(x);
            x.setBackground(AppletGaussAlgorithmus.COLOR_NO_EDIT);
            this.panelBasisKern.add(new JLabel(" = "));
            i = 0;
            while (i < this.matrixAttributes.getBasisKern().size()) {
                RationalMatrix mat = this.matrixAttributes.getBasisKern().get(i);
                this.panelBasisKern.add(mat);
                mat.setBackground(AppletGaussAlgorithmus.COLOR_NO_EDIT);
                if (i != this.matrixAttributes.getBasisKern().size() - 1) {
                    this.panelBasisKern.add(new JLabel(" , "));
                }
                ++i;
            }
            this.basisKern = new Vector<RationalMatrix>(this.matrixAttributes.getBasisKern());
            this.basisKern.add(x);
        } else {
            this.basisKern = null;
        }
    }

    public void valueSet(RationalMatrixEvent ev) {
        try {
            this.setMatrixParameter(ev.getM());
        }
        catch (Exception e) {
            this.main.report.reportException(null, e, this.main);
        }
    }

    public MatrixAttributes getMatrixAttributes() {
        return this.matrixAttributes;
    }

    public void setView(int view) {
        if (this.basisKern == null) {
            return;
        }
        for (RationalMatrix m : this.basisKern) {
            m.setView(view);
        }
    }
}

