/*
 * Decompiled with CFR 0.152.
 */
package uibk.applets.gaussAlgorithmus;

import javax.swing.BorderFactory;
import javax.swing.JLabel;
import uibk.applets.gaussAlgorithmus.AppletGaussAlgorithmus;
import uibk.applets.gaussAlgorithmus.PanelControl;
import uibk.applets.gaussAlgorithmus.PanelMain;
import uibk.applets.gaussAlgorithmus.PanelMatrixParameter;
import uibk.mtk.exception.ExceptionLevel;
import uibk.mtk.lang.Messages;
import uibk.mtk.math.NotANumberException;
import uibk.mtk.math.polynom.PolynomException;
import uibk.mtk.math.rational.MatrixException;
import uibk.mtk.math.rational.RationalMatrix;
import uibk.mtk.math.rational.RationalMatrixUtil;
import uibk.mtk.swing.base.MPanel;

public class PanelMainLU
extends PanelMain {
    private int solveStep = 0;

    public PanelMainLU(AppletGaussAlgorithmus main, PanelControl panelControl, PanelMatrixParameter panelParameter) {
        super(main, panelControl, panelParameter);
    }

    public synchronized void initGLS(boolean permutX) throws MatrixException, NotANumberException {
        RationalMatrix b;
        int o;
        this.initPanels();
        MPanel[] mPanelArray = this.panels;
        int n = this.panels.length;
        int n2 = 0;
        while (n2 < n) {
            MPanel p = mPanelArray[n2];
            p.removeAll();
            ++n2;
        }
        int n3 = o = this.panelControl.isColumnPivot() ? 2 : 0;
        if (this.solveStep < 3) {
            this.A.setFont(AppletGaussAlgorithmus.FONT);
            this.A.addMouseListener(this.mouseEvents);
            this.A.addMouseMotionListener(this.mouseEvents);
            this.A.setBackground(AppletGaussAlgorithmus.COLOR_EDIT);
            this.panels[4].add(this.A);
            if (!this.panelControl.isColumnPivot()) {
                this.panels[5].add(new JLabel("*"));
            }
        }
        if (this.solveStep < 1) {
            this.A.getPermuttationZeilen().setFont(AppletGaussAlgorithmus.FONT);
            this.A.getPermuttationZeilen().setBackground(AppletGaussAlgorithmus.COLOR_NO_EDIT);
            this.panels[0].add(this.A.getPermuttationZeilen());
            this.panels[1].add(new JLabel("*"));
        }
        if (this.solveStep < 2) {
            this.A.getL().setFont(AppletGaussAlgorithmus.FONT);
            this.A.getL().setBackground(AppletGaussAlgorithmus.COLOR_NO_EDIT);
            this.panels[2].add(this.A.getL());
            this.panels[3].add(new JLabel("*"));
        }
        if (this.solveStep < 4 && !this.panelControl.isColumnPivot()) {
            this.A.getPermuttationSpalten().setFont(AppletGaussAlgorithmus.FONT);
            this.A.getPermuttationSpalten().setBackground(AppletGaussAlgorithmus.COLOR_NO_EDIT);
            this.panels[6].add(this.A.getPermuttationSpalten());
        }
        if ((b = this.b) != null) {
            if (this.solveStep < 4) {
                this.panels[7 - o].add(new JLabel("*"));
            }
            if (this.history.size() == 1) {
                b.setBackground(AppletGaussAlgorithmus.COLOR_EDIT);
                b.addMouseListener(this.mouseEvents);
                b.addMouseMotionListener(this.mouseEvents);
            } else {
                b.setBackground(AppletGaussAlgorithmus.COLOR_NO_EDIT);
            }
            b.setFont(AppletGaussAlgorithmus.FONT);
            this.panels[10 - o].add(b);
            this.bDisplay = b;
            RationalMatrix x = this.x;
            if (x != null) {
                x.setBackground(AppletGaussAlgorithmus.COLOR_NO_EDIT);
                x.setFont(AppletGaussAlgorithmus.FONT);
                this.panels[8 - o].add(x);
                this.panels[9 - o].add(new JLabel("="));
            }
            this.xDisplay = x;
        }
        this.setView(this.panelControl.getView());
        this.main.setMainPanel();
    }

    protected void solveStep() throws MatrixException, NotANumberException, PolynomException {
        block18: {
            if (this.A == null) {
                return;
            }
            if (this.b == null) {
                throw new MatrixException(Messages.getString("uibk.applets.gaussAlgorithmus.messages", "PanelMain.20"), ExceptionLevel.INFO);
            }
            if (this.x != null) {
                if (this.solveStep < 4) {
                    try {
                        try {
                            if (this.solveStep == 0) {
                                this.A.getPermuttationZeilen().setBorder(BorderFactory.createLineBorder(AppletGaussAlgorithmus.COLOR_SOLVE));
                                this.addSteppToHistory(null, null, null, false);
                                RationalMatrix T = RationalMatrixUtil.transpose(this.A.getPermuttationZeilen().clone());
                                this.b = RationalMatrixUtil.mul(T, this.b);
                            } else if (this.solveStep == 1) {
                                this.A.getL().setBorder(BorderFactory.createLineBorder(AppletGaussAlgorithmus.COLOR_SOLVE));
                                this.addSteppToHistory(null, null, null, false);
                                this.b = RationalMatrixUtil.forwordInsert(this.A.getL(), this.b);
                            } else if (this.solveStep == 2) {
                                this.A.setBorder(BorderFactory.createLineBorder(AppletGaussAlgorithmus.COLOR_SOLVE));
                                this.addSteppToHistory(null, null, null, false);
                                this.b = RationalMatrixUtil.backwardInsert(this.A, this.b);
                                if (this.panelControl.isColumnPivot()) {
                                    ++this.solveStep;
                                }
                            } else if (this.solveStep == 3) {
                                this.A.getPermuttationSpalten().setBorder(BorderFactory.createLineBorder(AppletGaussAlgorithmus.COLOR_SOLVE));
                                this.addSteppToHistory(null, null, null, false);
                                RationalMatrix T = RationalMatrixUtil.transpose(this.A.getPermuttationSpalten().clone());
                                this.b = RationalMatrixUtil.mul(T, this.b);
                                this.A.setSolved(true);
                            }
                            ((PanelMain.History)this.history.lastElement()).b = this.b;
                            break block18;
                        }
                        catch (MatrixException e) {
                            this.removeStepFromHistory();
                            throw e;
                        }
                        catch (NotANumberException e) {
                            this.removeStepFromHistory();
                            throw e;
                        }
                    }
                    finally {
                        ++this.solveStep;
                        this.initGLS(false);
                    }
                }
                throw new MatrixException(Messages.getString("uibk.applets.gaussAlgorithmus.messages", "PanelMain.0"), ExceptionLevel.INFO);
            }
        }
    }

    protected void newGLSImpl() {
        this.solveStep = 0;
    }

    protected void removeStepFromHistoryImpl() {
        if (this.solveStep == 4 && this.panelControl.isColumnPivot()) {
            --this.solveStep;
        }
        if (this.solveStep > 0) {
            --this.solveStep;
        }
    }

    protected void addSteppToHistory() {
    }
}

