/*
 * Decompiled with CFR 0.152.
 */
package uibk.applets.gaussAlgorithmus;

import java.awt.Component;
import java.util.Vector;
import javax.swing.JLabel;
import uibk.applets.gaussAlgorithmus.AppletGaussAlgorithmus;
import uibk.applets.gaussAlgorithmus.PanelControl;
import uibk.applets.gaussAlgorithmus.PanelMain;
import uibk.applets.gaussAlgorithmus.PanelMatrixParameter;
import uibk.mtk.exception.ExceptionLevel;
import uibk.mtk.lang.Messages;
import uibk.mtk.math.NotANumberException;
import uibk.mtk.math.polynom.PolynomException;
import uibk.mtk.math.rational.MatrixException;
import uibk.mtk.math.rational.RationalMatrix;
import uibk.mtk.math.rational.RationalMatrixUtil;
import uibk.mtk.math.rational.RationalNumber;
import uibk.mtk.swing.base.MPanel;

public class PanelMainGauss
extends PanelMain {
    private Vector<RationalMatrix> generalSolution = new Vector();
    private final PanelMatrixParameter panelParameter;
    private int index = -1;

    public PanelMainGauss(AppletGaussAlgorithmus main, PanelControl panelControl, PanelMatrixParameter panelParameter) {
        super(main, panelControl, panelParameter);
        this.panelParameter = panelParameter;
    }

    public synchronized void initGLS(boolean permutX) throws MatrixException, NotANumberException, PolynomException {
        RationalMatrix x;
        this.initPanels();
        MPanel[] mPanelArray = this.panels;
        int n = this.panels.length;
        int n2 = 0;
        while (n2 < n) {
            MPanel p = mPanelArray[n2];
            p.removeAll();
            ++n2;
        }
        if (this.A != null && this.index != -1) {
            this.A.setFont(AppletGaussAlgorithmus.FONT);
            this.A.addMouseListener(this.mouseEvents);
            this.A.addMouseMotionListener(this.mouseEvents);
            this.A.setBackground(AppletGaussAlgorithmus.COLOR_EDIT);
            this.panels[0].add(this.A);
            if (this.b != null) {
                this.panels[1].add(new JLabel("*"));
            }
        }
        if ((x = this.x) != null) {
            if (permutX) {
                x = RationalMatrixUtil.mul(this.A.getPermuttationSpalten().clone(), x);
            }
            x.setBackground(AppletGaussAlgorithmus.COLOR_NO_EDIT);
            x.setFont(AppletGaussAlgorithmus.FONT);
            this.panels[2].add(x);
        }
        this.xDisplay = x;
        ((PanelMain.History)this.history.lastElement()).xDisplay = x;
        RationalMatrix b = this.b;
        if (b != null) {
            this.panels[3].add(new JLabel("="));
            if (this.history.size() == 1) {
                b.setBackground(AppletGaussAlgorithmus.COLOR_EDIT);
                b.addMouseListener(this.mouseEvents);
                b.addMouseMotionListener(this.mouseEvents);
            } else if (this.A != null && this.index == -2) {
                RationalMatrix T = RationalMatrixUtil.transpose(this.A.getPermuttationZeilen().clone());
                RationalMatrix Tb = RationalMatrixUtil.mul(T, b);
                b = RationalMatrixUtil.forwordInsert(this.A.getL(), Tb);
            }
            if (this.history.size() == 1) {
                b.setBackground(AppletGaussAlgorithmus.COLOR_EDIT);
            } else {
                b.setBackground(AppletGaussAlgorithmus.COLOR_NO_EDIT);
            }
            b.setFont(AppletGaussAlgorithmus.FONT);
            this.panels[4].add(b);
        }
        this.bDisplay = b;
        ((PanelMain.History)this.history.lastElement()).bDisplay = b;
        int i = 0;
        while (i < this.generalSolution.size()) {
            if (i + 5 > 23) {
                throw new MatrixException("Interner Fehler, Dimension des GLS zu gro\u00df.", ExceptionLevel.ERROR);
            }
            RationalMatrix m = this.generalSolution.get(i);
            String txt = "+ t";
            if (this.generalSolution.size() > 1) {
                txt = "+ t[" + (i + 1) + "]";
            }
            JLabel l = new JLabel(txt);
            l.setFont(AppletGaussAlgorithmus.FONT);
            this.panels[6 + 2 * i - 1].add(l);
            this.panels[6 + 2 * i].add(m);
            m.setBackground(AppletGaussAlgorithmus.COLOR_NO_EDIT);
            m.setFont(AppletGaussAlgorithmus.FONT);
            ++i;
        }
        this.setView(this.panelControl.getView());
        this.main.setMainPanel();
    }

    protected void solveStep() throws MatrixException, NotANumberException, PolynomException {
        if (this.A == null) {
            return;
        }
        if (this.b == null) {
            throw new MatrixException(Messages.getString("uibk.applets.gaussAlgorithmus.messages", "PanelMain.20"), ExceptionLevel.INFO);
        }
        if (this.index == -1) {
            throw new MatrixException(Messages.getString("uibk.applets.gaussAlgorithmus.messages", "PanelMain.0"), ExceptionLevel.INFO);
        }
        if (this.index == -2) {
            RationalMatrixUtil.isSolveAble(this.A, this.bDisplay, this.panelParameter.getMatrixAttributes().getKernDim());
        }
        boolean expand = false;
        if (this.index == -2) {
            expand = this.expand(this.A, this.bDisplay, this.xDisplay);
        }
        if (this.index >= 0 && !expand) {
            this.addSteppToHistory(this.index, this.index, AppletGaussAlgorithmus.COLOR_SOLVE, false);
            this.solveStep(this.A, this.b);
            this.initGLS(false);
        }
        ((PanelMain.History)this.history.lastElement()).A = this.A;
        ((PanelMain.History)this.history.lastElement()).b = this.b;
        ((PanelMain.History)this.history.lastElement()).index = this.index;
    }

    private boolean expand(RationalMatrix A, RationalMatrix b, RationalMatrix x) throws NotANumberException, MatrixException, PolynomException {
        if (A.getIndexPivot() != A.getColumnDim()) {
            this.addSteppToHistory(this.index, this.index, AppletGaussAlgorithmus.COLOR_SOLVE, false);
            this.generalSolution.removeAllElements();
            int kernDim = ((PanelMain)this).panelParameter.getMatrixAttributes().getKernDim();
            this.index = A.getColumnDim() - 1;
            int i = 0;
            while (i < kernDim) {
                RationalMatrix m = RationalMatrixUtil.getNullMatrix(A.getColumnDim(), 1, A.getView(), this);
                m.setValueAt(m.getRowDim() - 1 - i, 0, new RationalNumber(1L, 1L, A.getView(), (Component)this));
                this.generalSolution.add(m);
                ++i;
            }
            if (b.getRowDim() != A.getColumnDim()) {
                RationalMatrix id = RationalMatrixUtil.getIdentityMatrix(A.getColumnDim(), b.getRowDim(), A.getView(), this);
                this.b = RationalMatrixUtil.mul(id, b);
                id = RationalMatrixUtil.getIdentityMatrix(A.getColumnDim(), A.getRowDim(), A.getView(), this);
                this.A = RationalMatrixUtil.mul(id, A);
            } else {
                this.b = b.clone();
            }
            i = A.getColumnDim() - 1;
            while (i > A.getColumnDim() - 1 - kernDim) {
                this.A.setValueAtIntern(i, i, new RationalNumber(1L, 1L, A.getView(), (Component)this));
                --i;
            }
            this.x = x.clone();
            this.A.setIndexPivot(A.getColumnDim());
            ((PanelMain.History)this.history.lastElement()).x = this.x;
            this.saveGeneralSolutionToHistory();
            this.initGLS(false);
            return true;
        }
        this.index = A.getColumnDim() - 1;
        this.b = b.clone();
        ((PanelMain.History)this.history.lastElement()).x = this.x = x.clone();
        return false;
    }

    private void solveStep(RationalMatrix A, RationalMatrix b) throws MatrixException, NotANumberException, PolynomException {
        if (A.getVauleAt(this.index, this.index).compareTo(RationalNumber.ONE) != 0) {
            int i = 0;
            while (i < b.getColumnDim()) {
                b.setValueAt(this.index, i, b.getVauleAt(this.index, i).div(A.getVauleAt(this.index, this.index)));
                ++i;
            }
            for (RationalMatrix m : this.generalSolution) {
                m.setValueAt(this.index, 0, m.getVauleAt(this.index, 0).div(A.getVauleAt(this.index, this.index)));
            }
            A.setValueAtIntern(this.index, this.index, new RationalNumber(1L, 1L, A.getView(), (Component)this));
            if (this.index == 0) {
                A.setSolved(true);
                --this.index;
            }
        } else {
            int i = this.index - 1;
            while (i >= 0) {
                b.subIntern(this.index, i, A.getVauleAt(i, this.index));
                for (RationalMatrix m : this.generalSolution) {
                    m.subIntern(this.index, i, A.getVauleAt(i, this.index));
                }
                A.setValueAtIntern(i, this.index, new RationalNumber(0L, 1L, A.getView(), (Component)this));
                --i;
            }
            --this.index;
        }
        this.A = A;
        this.b = b;
    }

    protected void newGLSImpl() {
        this.A.addRationalMatrixListener(this.panelParameter);
        this.index = -2;
        this.generalSolution.removeAllElements();
    }

    protected void removeStepFromHistoryImpl() {
        this.generalSolution = ((PanelMain.History)this.history.lastElement()).generalSolution != null ? ((PanelMain.History)this.history.lastElement()).generalSolution : new Vector();
        this.index = ((PanelMain.History)this.history.lastElement()).index;
    }

    protected void addSteppToHistory() {
        this.saveGeneralSolutionToHistory();
        ((PanelMain.History)this.history.lastElement()).index = this.index;
    }

    private void saveGeneralSolutionToHistory() {
        if (this.history == null || this.history.size() == 0) {
            return;
        }
        Vector<RationalMatrix> v = new Vector<RationalMatrix>();
        for (RationalMatrix m : this.generalSolution) {
            m.setBackground(AppletGaussAlgorithmus.COLOR_HISTORY);
            m.setFont(AppletGaussAlgorithmus.FONT_HISTORY);
            v.add(m.clone());
        }
        ((PanelMain.History)this.history.lastElement()).generalSolution = v;
        this.generalSolution = v;
    }
}

