/*
 * Decompiled with CFR 0.152.
 */
package uibk.applets.gaussAlgorithmus;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import uibk.applets.gaussAlgorithmus.AppletGaussAlgorithmus;
import uibk.applets.gaussAlgorithmus.MouseEvents;
import uibk.applets.gaussAlgorithmus.PanelControl;
import uibk.applets.gaussAlgorithmus.PanelMatrixParameter;
import uibk.mtk.exception.ExceptionLevel;
import uibk.mtk.lang.Messages;
import uibk.mtk.math.NotANumberException;
import uibk.mtk.math.polynom.Polynom;
import uibk.mtk.math.polynom.PolynomException;
import uibk.mtk.math.rational.MatrixException;
import uibk.mtk.math.rational.RationalMatrix;
import uibk.mtk.math.rational.RationalMatrixEvent;
import uibk.mtk.math.rational.RationalMatrixListener;
import uibk.mtk.math.rational.RationalNumber;
import uibk.mtk.swing.base.MPanel;

public abstract class PanelMain
extends MPanel
implements RationalMatrixListener,
ComponentListener {
    protected final AppletGaussAlgorithmus main;
    protected final PanelMatrixParameter panelParameter;
    protected final PanelControl panelControl;
    protected final MouseEvents mouseEvents;
    protected RationalMatrix A;
    protected RationalMatrix x;
    protected RationalMatrix xDisplay;
    protected RationalMatrix b;
    protected RationalMatrix bDisplay;
    protected final MPanel[] panels = new MPanel[25];
    protected Vector<History> history = new Vector();

    public PanelMain(AppletGaussAlgorithmus main, PanelControl panelControl, PanelMatrixParameter panelParameter) {
        this.main = main;
        this.panelParameter = panelParameter;
        this.mouseEvents = new MouseEvents(main, this, panelControl);
        this.panelControl = panelControl;
        this.setBackground(AppletGaussAlgorithmus.COLOR_BGD);
        this.setLayout(new BoxLayout(this, 1));
    }

    protected void initPanels() {
        this.removeAll();
        this.history.lastElement().removeAll();
        this.history.lastElement().setBackground(AppletGaussAlgorithmus.COLOR_BGD);
        this.history.lastElement().setAlignmentX(0.0f);
        this.history.lastElement().add(Box.createGlue());
        int i = 0;
        while (i < this.panels.length) {
            this.panels[i] = new MPanel();
            this.panels[i].setBackground(AppletGaussAlgorithmus.COLOR_BGD);
            this.history.lastElement().add(this.panels[i]);
            ++i;
        }
        this.history.lastElement().add(Box.createGlue());
        i = this.history.size();
        while (i > 0) {
            this.add(this.history.get(i - 1));
            --i;
        }
        this.add(Box.createVerticalGlue());
    }

    public void newGLS(int rows, int columns, int columnsRe, int view) throws MatrixException, NotANumberException, PolynomException {
        int j;
        int i;
        RationalMatrix A = new RationalMatrix(rows, columns);
        RationalMatrix b = null;
        if (columnsRe > 0) {
            b = new RationalMatrix(rows, columnsRe);
            i = 0;
            while (i < rows) {
                j = 0;
                while (j < columnsRe) {
                    b.setValueAt(i, j, new RationalNumber(0L, 1L, view, (Component)this.main));
                    ++j;
                }
                ++i;
            }
        }
        i = 0;
        while (i < rows) {
            j = 0;
            while (j < columns) {
                A.setValueAt(i, j, new RationalNumber(0L, 1L, view, (Component)this.main));
                ++j;
            }
            ++i;
        }
        this.newGLS(A, b);
    }

    public void newGLS(RationalMatrix A, RationalMatrix b) throws MatrixException, NotANumberException, PolynomException {
        this.A = A;
        this.b = b;
        this.newGLSImpl();
        this.x = this.initXMatrix(A, b);
        this.history.removeAllElements();
        this.history.add(new History(A, this.x, b, this.xDisplay, this.bDisplay, false));
        this.initGLS(false);
        this.panelParameter.setMatrixParameter(A);
        A.addRationalMatrixListener(this);
        this.setTitleStep();
        this.main.report.reportSuccess(Messages.getString("uibk.applets.gaussAlgorithmus.messages", "PanelMain.13"));
        this.panelControl.setEnabalePivotPanel(true);
    }

    protected RationalMatrix initXMatrix(RationalMatrix A, RationalMatrix b) throws MatrixException {
        if (b == null) {
            return null;
        }
        RationalMatrix x = A.initXMatrix(b);
        int i = 0;
        while (i < A.getColumnDim()) {
            int j = 0;
            while (j < b.getColumnDim()) {
                String sym = "x[" + (i + 1) + "," + (j + 1) + "]";
                if (b.getColumnDim() == 1) {
                    sym = "x[" + (i + 1) + "]";
                }
                x.setValueAt(i, j, new RationalNumber(new Polynom(sym), new Polynom("1"), 3, (Component)this.main));
                ++j;
            }
            ++i;
        }
        return x;
    }

    protected abstract void newGLSImpl();

    public abstract void initGLS(boolean var1) throws MatrixException, NotANumberException, PolynomException;

    public void valueSet(RationalMatrixEvent ev) {
        this.setTitleStep();
        this.main.report.reportSuccess(Messages.getString("uibk.applets.gaussAlgorithmus.messages", "PanelMain.14"));
    }

    protected void addSteppToHistory(Integer rowIndex, Integer columnIndex, Color c, boolean permutX) throws MatrixException, NotANumberException {
        this.A.removeMouseListener(this.mouseEvents);
        this.A.removeMouseMotionListener(this.mouseEvents);
        this.A.setBackground(AppletGaussAlgorithmus.COLOR_HISTORY);
        this.A.setFont(AppletGaussAlgorithmus.FONT_HISTORY);
        if (rowIndex != null && columnIndex != null && c != null) {
            this.A.setBorderByIndex(rowIndex, columnIndex, c);
        }
        if (this.bDisplay != null) {
            this.bDisplay.removeMouseListener(this.mouseEvents);
            this.bDisplay.removeMouseMotionListener(this.mouseEvents);
            this.bDisplay.setBackground(AppletGaussAlgorithmus.COLOR_HISTORY);
            this.bDisplay.setFont(AppletGaussAlgorithmus.FONT_HISTORY);
        }
        this.A.getPermuttationZeilen().setBackground(AppletGaussAlgorithmus.COLOR_HISTORY);
        this.A.getPermuttationZeilen().setFont(AppletGaussAlgorithmus.FONT_HISTORY);
        this.A.getL().setBackground(AppletGaussAlgorithmus.COLOR_HISTORY);
        this.A.getL().setFont(AppletGaussAlgorithmus.FONT_HISTORY);
        this.A.getPermuttationSpalten().setBackground(AppletGaussAlgorithmus.COLOR_HISTORY);
        this.A.getPermuttationSpalten().setFont(AppletGaussAlgorithmus.FONT_HISTORY);
        if (this.xDisplay != null) {
            this.xDisplay.setBackground(AppletGaussAlgorithmus.COLOR_HISTORY);
            this.xDisplay.setFont(AppletGaussAlgorithmus.FONT_HISTORY);
        }
        this.A = this.A.clone();
        if (this.b != null) {
            this.x = this.x.clone();
            this.b = this.b.clone();
        }
        this.history.add(new History(this.A, this.x, this.b, this.xDisplay, this.bDisplay, permutX));
        this.addSteppToHistory();
        this.panelControl.setEnabalePivotPanel(false);
    }

    protected abstract void addSteppToHistory();

    public void removeStepFromHistory() throws MatrixException, NotANumberException, PolynomException {
        if (this.history.size() > 1) {
            this.history.remove(this.history.lastElement());
            this.removeStepFromHistoryImpl();
            this.A = this.history.lastElement().A;
            this.A.setBorderByIndex(-1, -1, null);
            this.x = this.history.lastElement().x;
            this.b = this.history.lastElement().b;
            this.initGLS(this.history.lastElement().permutX);
            this.setTitleStep();
            this.main.report.reportSuccess(Messages.getString("uibk.applets.gaussAlgorithmus.messages", "PanelMain.12"));
        }
        if (this.history.size() == 1) {
            this.panelControl.setEnabalePivotPanel(true);
        }
    }

    public void goToFirstHistroyEntry() throws MatrixException, NotANumberException, PolynomException {
        while (this.history.size() > 1) {
            this.removeStepFromHistory();
        }
    }

    protected abstract void removeStepFromHistoryImpl();

    public void setView(int view) throws MatrixException {
        RationalMatrix A = null;
        RationalMatrix x = null;
        RationalMatrix b = null;
        RationalMatrix xDisplay = null;
        RationalMatrix bDisplay = null;
        Vector<RationalMatrix> generalSolution = null;
        for (History h : this.history) {
            A = h.A;
            x = h.x;
            b = h.b;
            xDisplay = h.xDisplay;
            bDisplay = h.bDisplay;
            generalSolution = h.generalSolution;
            if (A != null) {
                A.setView(view);
                if (b != null) {
                    b.setView(view);
                }
                if (A.getPermuttationSpalten() != null) {
                    A.getPermuttationSpalten().setView(view);
                }
                if (A.getPermuttationZeilen() != null) {
                    A.getPermuttationZeilen().setView(view);
                }
                if (A.getL() != null) {
                    A.getL().setView(view);
                }
            }
            if (x != null) {
                if (x.getView() == 3 || x.getView() == 4) {
                    if (view == 1) {
                        x.setView(4);
                    } else if (view == 2) {
                        x.setView(3);
                    }
                } else {
                    x.setView(view);
                }
            }
            if (b != null) {
                b.setView(view);
            }
            if (xDisplay != null) {
                xDisplay.setView(view);
            }
            if (bDisplay != null) {
                bDisplay.setView(view);
            }
            if (generalSolution == null) continue;
            for (RationalMatrix m : generalSolution) {
                if (m == null) continue;
                m.setView(view);
            }
        }
        this.panelParameter.setView(view);
    }

    /*
     * Unable to fully structure code
     */
    public void gaussAlgorithmus() throws NotANumberException, MatrixException, PolynomException {
        if (this.A != null) ** GOTO lbl5
        return;
        while (this.A.getVauleAt((index = this.A.indexMaxValueAbs(this.A.getIndexPivot(), this.A.getIndexPivot(), this.panelControl.isColumnPivot()))[0], index[1]).getDoubleValue() != 0.0) {
            this.gaussStep(index[0], index[1]);
lbl5:
            // 2 sources

            if (this.A.haveLigalPivot(this.panelControl.isColumnPivot())) continue;
        }
    }

    public void solve() throws NotANumberException, MatrixException, PolynomException {
        if (this.A == null) {
            return;
        }
        this.gaussAlgorithmus();
        while (!this.A.isSolved()) {
            this.solveStep();
        }
    }

    public void step() throws NotANumberException, MatrixException, PolynomException {
        if (this.A == null) {
            return;
        }
        this.main.report.reportSuccess(this.setTitleStep());
        if (this.A.haveLigalPivot(this.panelControl.isColumnPivot())) {
            int[] index = this.A.indexMaxValueAbs(this.A.getIndexPivot(), this.A.getIndexPivot(), this.panelControl.isColumnPivot());
            if (this.A.getVauleAt(index[0], index[1]).getDoubleValue() == 0.0) {
                throw new MatrixException(Messages.getString("uibk.applets.gaussAlgorithmus.messages", "PanelMain.1"), ExceptionLevel.INFO);
            }
            this.gaussStep(index[0], index[1]);
        } else {
            this.solveStep();
        }
        this.setTitleStep();
    }

    public String setTitleStep() {
        String msg = this.A == null ? Messages.getString("uibk.applets.gaussAlgorithmus.messages", "PanelControl.5") : (this.A.haveLigalPivot(false) ? Messages.getString("uibk.applets.gaussAlgorithmus.messages", "PanelMain.10") : Messages.getString("uibk.applets.gaussAlgorithmus.messages", "PanelMain.11"));
        this.panelControl.setTitleStep(msg);
        return msg;
    }

    public void gaussStep(int rowIndex, int columnIndex) throws MatrixException, NotANumberException, PolynomException {
        this.addSteppToHistory(rowIndex, columnIndex, AppletGaussAlgorithmus.COLOR_PIVOT, true);
        try {
            this.A.gaussStep(rowIndex, columnIndex, this.panelControl.isColumnPivot());
            this.initGLS(true);
        }
        catch (MatrixException e) {
            this.removeStepFromHistory();
            throw e;
        }
        catch (NotANumberException e) {
            this.removeStepFromHistory();
            throw e;
        }
    }

    protected abstract void solveStep() throws MatrixException, NotANumberException, PolynomException;

    public RationalMatrix getA() {
        return this.A;
    }

    public RationalMatrix getBDisplay() {
        return this.bDisplay;
    }

    public void componentHidden(ComponentEvent e) {
    }

    public void componentMoved(ComponentEvent e) {
    }

    public void componentResized(ComponentEvent e) {
    }

    public void componentShown(ComponentEvent e) {
        this.setTitleStep();
    }

    protected class History
    extends MPanel {
        RationalMatrix A;
        RationalMatrix x;
        RationalMatrix b;
        RationalMatrix xDisplay;
        RationalMatrix bDisplay;
        Vector<RationalMatrix> generalSolution;
        boolean permutX;
        int index = -2;

        public History(RationalMatrix A, RationalMatrix x, RationalMatrix b, RationalMatrix xDisplay, RationalMatrix bDisplay, boolean permutX) {
            this.A = A;
            this.x = x;
            this.b = b;
            this.permutX = permutX;
            this.xDisplay = xDisplay;
            this.bDisplay = bDisplay;
        }
    }
}

