/*
 * Decompiled with CFR 0.152.
 */
package uibk.applets.gaussAlgorithmus;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import uibk.applets.gaussAlgorithmus.AppletGaussAlgorithmus;
import uibk.applets.gaussAlgorithmus.PanelExampleData;
import uibk.applets.gaussAlgorithmus.PanelMain;
import uibk.mtk.lang.Messages;
import uibk.mtk.swing.base.IntegerTextField;
import uibk.mtk.swing.base.MPanel;
import uibk.mtk.swing.base.TitledPanel;

public class PanelControl
extends MPanel
implements ActionListener {
    private final AppletGaussAlgorithmus main;
    private final JRadioButton fraction_view = new JRadioButton(Messages.getString("uibk.applets.gaussAlgorithmus.messages", "PanelControl.11"));
    private final JRadioButton double_view = new JRadioButton(Messages.getString("uibk.applets.gaussAlgorithmus.messages", "PanelControl.12"));
    private final IntegerTextField rows = new IntegerTextField(10, 1, 10, Messages.getString("uibk.applets.gaussAlgorithmus.messages", "PanelControl.14"));
    private final IntegerTextField columns = new IntegerTextField(10, 1, 10, Messages.getString("uibk.applets.gaussAlgorithmus.messages", "PanelControl.15"));
    private final IntegerTextField columnsReSite = new IntegerTextField(10, 0, 10, Messages.getString("uibk.applets.gaussAlgorithmus.messages", "PanelControl.16"));
    private final JRadioButton columnPivot = new JRadioButton(Messages.getString("uibk.applets.gaussAlgorithmus.messages", "PanelControl.30"), true);
    private final JRadioButton fullPivot = new JRadioButton(Messages.getString("uibk.applets.gaussAlgorithmus.messages", "PanelControl.31"), false);
    private final TitledPanel pivotPanel = new TitledPanel(Messages.getString("uibk.applets.gaussAlgorithmus.messages", "PanelControl.32"));
    private final TitledPanel panelGauss = this.buttonsStep();

    public PanelControl(AppletGaussAlgorithmus main) {
        this.main = main;
        this.initPanel();
    }

    private void initPanel() {
        this.setLayout(new BoxLayout(this, 1));
        this.add(new PanelExampleData(this.main, this));
        this.add(this.buttonViewPanel());
        this.add(this.createEmtyMatrixPanel());
        this.add(this.creatPivotPanel());
        this.add(this.panelGauss);
        this.add(Box.createVerticalGlue());
        this.add(this.buttonsControl());
    }

    private TitledPanel buttonViewPanel() {
        TitledPanel panel = new TitledPanel(Messages.getString("uibk.applets.gaussAlgorithmus.messages", "PanelControl.10"));
        panel.setLayout(new GridLayout(1, 2));
        panel.setMaximumSize(new Dimension(1000, 20));
        panel.add(this.fraction_view);
        this.fraction_view.setSelected(true);
        this.fraction_view.addActionListener(this);
        this.fraction_view.setActionCommand("fraction_view");
        panel.add(this.double_view);
        this.double_view.setSelected(false);
        this.double_view.addActionListener(this);
        this.double_view.setActionCommand("double_view");
        return panel;
    }

    private TitledPanel createEmtyMatrixPanel() {
        TitledPanel titlePanel = new TitledPanel(Messages.getString("uibk.applets.gaussAlgorithmus.messages", "PanelControl.13"));
        titlePanel.setLayout(new GridBagLayout());
        titlePanel.setMaximumSize(new Dimension(2000, 120));
        JLabel labelRows = new JLabel(Messages.getString("uibk.applets.gaussAlgorithmus.messages", "PanelControl.14"));
        JLabel labelColumns = new JLabel(Messages.getString("uibk.applets.gaussAlgorithmus.messages", "PanelControl.15"));
        JLabel lableColumnsRe = new JLabel(Messages.getString("uibk.applets.gaussAlgorithmus.messages", "PanelControl.16"));
        this.setMaximumSize(new Dimension(2000, 120));
        titlePanel.add((Component)labelRows, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        titlePanel.add((Component)this.rows, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        titlePanel.add((Component)labelColumns, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 0, 0, 0), 0, 0));
        titlePanel.add((Component)this.columns, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        titlePanel.add((Component)lableColumnsRe, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 0, 0, 0), 0, 0));
        titlePanel.add((Component)this.columnsReSite, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        JButton creat = new JButton(Messages.getString("uibk.applets.gaussAlgorithmus.messages", "PanelControl.0"));
        titlePanel.add((Component)creat, new GridBagConstraints(0, 4, 2, 1, 0.0, 0.0, 10, 0, new Insets(20, 0, 0, 0), 0, 0));
        creat.addActionListener(this);
        creat.setActionCommand("create");
        return titlePanel;
    }

    private TitledPanel creatPivotPanel() {
        this.pivotPanel.setLayout(new GridLayout(2, 1));
        this.pivotPanel.setMaximumSize(new Dimension(2000, 120));
        this.pivotPanel.add(this.columnPivot);
        this.pivotPanel.add(this.fullPivot);
        ButtonGroup group = new ButtonGroup();
        group.add(this.columnPivot);
        group.add(this.fullPivot);
        this.columnPivot.addActionListener(this);
        this.columnPivot.setActionCommand("pivot");
        this.fullPivot.addActionListener(this);
        this.fullPivot.setActionCommand("pivot");
        return this.pivotPanel;
    }

    public boolean isColumnPivot() {
        return this.columnPivot.isSelected();
    }

    private TitledPanel buttonsStep() {
        TitledPanel panel = new TitledPanel(Messages.getString("uibk.applets.gaussAlgorithmus.messages", "PanelControl.5"));
        JButton step = new JButton(Messages.getString("uibk.applets.gaussAlgorithmus.messages", "PanelControl.2"));
        JButton rev = new JButton(Messages.getString("uibk.applets.gaussAlgorithmus.messages", "PanelControl.4"));
        panel.setMaximumSize(new Dimension(1000, 20));
        panel.add(step);
        panel.add(rev);
        step.addActionListener(this);
        step.setActionCommand("step");
        step.setPreferredSize(new Dimension(100, 23));
        rev.addActionListener(this);
        rev.setActionCommand("rev");
        rev.setPreferredSize(new Dimension(100, 23));
        return panel;
    }

    private MPanel buttonsControl() {
        MPanel panel = new MPanel();
        panel.setMaximumSize(new Dimension(1000, 100));
        JButton zerlegung = new JButton(Messages.getString("uibk.applets.gaussAlgorithmus.messages", "PanelControl.1"));
        panel.add(zerlegung);
        JButton solve = new JButton(Messages.getString("uibk.applets.gaussAlgorithmus.messages", "PanelControl.3"));
        panel.add(solve);
        zerlegung.addActionListener(this);
        zerlegung.setActionCommand("deco");
        solve.addActionListener(this);
        solve.setActionCommand("solve");
        return panel;
    }

    public void actionPerformed(ActionEvent ev) {
        try {
            if (ev.getActionCommand() == "create") {
                PanelMain[] panelMainArray = this.main.mainPanel;
                int n = this.main.mainPanel.length;
                int n2 = 0;
                while (n2 < n) {
                    PanelMain mainP = panelMainArray[n2];
                    mainP.newGLS(this.rows.getValue(), this.columns.getValue(), this.columnsReSite.getValue(), this.getView());
                    ++n2;
                }
            } else if (ev.getActionCommand() == "step") {
                this.main.getSelectedMainPanel().step();
            } else if (ev.getActionCommand() == "deco") {
                this.main.getSelectedMainPanel().gaussAlgorithmus();
            } else if (ev.getActionCommand() == "solve") {
                this.main.getSelectedMainPanel().solve();
            } else if (ev.getActionCommand() == "fraction_view") {
                this.fraction_view.setSelected(true);
                this.double_view.setSelected(false);
                PanelMain[] panelMainArray = this.main.mainPanel;
                int n = this.main.mainPanel.length;
                int n3 = 0;
                while (n3 < n) {
                    PanelMain mainP = panelMainArray[n3];
                    mainP.setView(1);
                    ++n3;
                }
            } else if (ev.getActionCommand() == "double_view") {
                this.double_view.setSelected(true);
                this.fraction_view.setSelected(false);
                PanelMain[] panelMainArray = this.main.mainPanel;
                int n = this.main.mainPanel.length;
                int n4 = 0;
                while (n4 < n) {
                    PanelMain mainP = panelMainArray[n4];
                    mainP.setView(2);
                    ++n4;
                }
            } else if (ev.getActionCommand() == "rev") {
                this.main.getSelectedMainPanel().removeStepFromHistory();
            } else if (ev.getActionCommand() == "pivot") {
                PanelMain[] panelMainArray = this.main.mainPanel;
                int n = this.main.mainPanel.length;
                int n5 = 0;
                while (n5 < n) {
                    PanelMain mainP = panelMainArray[n5];
                    mainP.initGLS(false);
                    ++n5;
                }
            }
        }
        catch (Exception e) {
            this.main.report.reportException(null, e, this.main);
            e.printStackTrace();
        }
        this.main.setMainPanel();
    }

    public int getView() {
        if (this.fraction_view.isSelected()) {
            return 1;
        }
        if (this.double_view.isSelected()) {
            return 2;
        }
        return 0;
    }

    public void setTitleStep(String title) {
        this.panelGauss.setBorderTitle(title);
        this.panelGauss.repaint();
    }

    public void setEnabalePivotPanel(boolean b) {
        this.pivotPanel.setEnabled(b);
    }
}

