/*
 * Decompiled with CFR 0.152.
 */
package uibk.mtk.swing;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JRadioButton;
import uibk.mtk.draw3d.base.RMathPanel3D;
import uibk.mtk.draw3d.rasterizer.Rasterizer;
import uibk.mtk.swing.Messages;
import uibk.mtk.swing.base.TitledPanel;

public class PanelRendering
extends TitledPanel
implements ActionListener {
    RMathPanel3D mathpanel3d;
    Rasterizer rasterizer;

    public PanelRendering(RMathPanel3D mathpanel3d) {
        super(Messages.getString("PanelRendering.0"));
        this.mathpanel3d = mathpanel3d;
        this.rasterizer = mathpanel3d.getRasterizer();
        this.initComponents();
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (event.getActionCommand().equals("speed")) {
            this.rasterizer.setRenderingHint(0);
        }
        if (event.getActionCommand().equals("quality")) {
            this.rasterizer.setRenderingHint(1);
        }
        this.mathpanel3d.repaint();
    }

    void initComponents() {
        this.setLayout(new GridBagLayout());
        this.setMaximumSize(new Dimension(1000, 90));
        JRadioButton radioQuality = new JRadioButton(Messages.getString("PanelRendering.3"));
        radioQuality.setActionCommand("quality");
        radioQuality.addActionListener(this);
        JRadioButton radioSpeed = new JRadioButton(Messages.getString("PanelRendering.5"));
        radioSpeed.setActionCommand("speed");
        radioSpeed.addActionListener(this);
        ButtonGroup groupRenderingOpt = new ButtonGroup();
        groupRenderingOpt.add(radioQuality);
        groupRenderingOpt.add(radioSpeed);
        if (this.rasterizer.getRenderingHint() == 1) {
            radioQuality.setSelected(true);
        } else {
            radioSpeed.setSelected(true);
        }
        this.add((Component)radioQuality, new GridBagConstraints(0, 0, 1, 1, 0.1, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        this.add((Component)radioSpeed, new GridBagConstraints(0, 1, 1, 1, 0.1, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
    }
}

