/*
 * Decompiled with CFR 0.152.
 */
package uibk.mtk.geom;

import java.util.Vector;
import uibk.mtk.geom.CoordinateBox3D;
import uibk.mtk.geom.CoordinateRect2D;
import uibk.mtk.geom.Punkt2D;
import uibk.mtk.geom.Punkt3D;

public final class GeomUtil {
    public static final int INTERSECTION_EMPTY = 0;
    public static final int INTERSECTION_POINT = 1;
    public static final int INTESECTION_LINE = 2;

    private GeomUtil() {
    }

    public static int intersectLines(Punkt2D p, Punkt2D dir, Punkt2D u, Punkt2D v, Punkt2D s) {
        double slope1 = dir.y / dir.x;
        double slope2 = (v.y - u.y) / (v.x - u.x);
        if (Double.isInfinite(slope1) && Double.isInfinite(slope2)) {
            if (p.x == u.x) {
                return 2;
            }
            return 0;
        }
        if (Double.isInfinite(slope1) && !Double.isInfinite(slope2)) {
            double d2 = u.y - slope2 * u.x;
            double sy = slope2 * p.x + d2;
            if (sy <= u.y && sy >= v.y || sy >= u.y && sy <= v.y) {
                s.x = p.x;
                s.y = sy;
                return 1;
            }
            return 0;
        }
        if (!Double.isInfinite(slope1) && Double.isInfinite(slope2)) {
            double d1 = p.y - slope1 * p.x;
            double sy = slope1 * u.x + d1;
            if (sy <= u.y && sy >= v.y || sy >= u.y && sy <= v.y) {
                s.x = u.x;
                s.y = sy;
                return 1;
            }
            return 0;
        }
        if (!Double.isInfinite(slope1) && !Double.isInfinite(slope2)) {
            double d1 = p.y - slope1 * p.x;
            double d2 = u.y - slope2 * u.x;
            if (slope1 == slope2) {
                if (d1 == d2) {
                    s.setLocation(u);
                    return 2;
                }
                return 0;
            }
            double sx = (d2 - d1) / (slope1 - slope2);
            double sy = slope2 * sx + d2;
            if ((sy <= u.y && sy >= v.y || sy >= u.y && sy <= v.y) && (sx <= u.x && sx >= v.x || sx >= u.x && sx <= v.x)) {
                s.x = sx;
                s.y = sy;
                return 1;
            }
            return 0;
        }
        return 0;
    }

    public static double distPointLine(double x, double y, double p1x, double p1y, double p2x, double p2y) {
        boolean containsy;
        double ax = x;
        double ay = y;
        double lx = p2x - p1x;
        double ly = p2y - p1y;
        double norm = Math.sqrt(lx * lx + ly * ly);
        double s = (ax -= p1x) * (lx /= norm) + (ay -= p1y) * (ly /= norm);
        lx *= s;
        ly *= s;
        lx += p1x;
        ly += p1y;
        boolean containsx = lx >= p1x && lx <= p2x || lx <= p1x && lx >= p2x;
        boolean bl = containsy = ly >= p1y && ly <= p2y || ly <= p1y && ly >= p2y;
        if (containsx && containsy) {
            return (lx -= x) * lx + (ly -= y) * ly;
        }
        double dist1 = (x - p1x) * (x - p1x) + (y - p1y) * (y - p1y);
        double dist2 = (x - p2x) * (x - p2x) + (y - p2y) * (y - p2y);
        return Math.min(dist1, dist2);
    }

    public static CoordinateBox3D getLimits3D(Vector points) {
        double maximumx = Double.NEGATIVE_INFINITY;
        double maximumy = Double.NEGATIVE_INFINITY;
        double maximumz = Double.NEGATIVE_INFINITY;
        double minimumx = Double.POSITIVE_INFINITY;
        double minimumy = Double.POSITIVE_INFINITY;
        double minimumz = Double.POSITIVE_INFINITY;
        int i = 0;
        while (i < points.size()) {
            Punkt3D p = (Punkt3D)points.elementAt(i);
            if (p != null) {
                if (p.x1 > maximumx) {
                    maximumx = p.x1;
                }
                if (p.x2 > maximumy) {
                    maximumy = p.x2;
                }
                if (p.x3 > maximumz) {
                    maximumz = p.x3;
                }
                if (p.x1 < minimumx) {
                    minimumx = p.x1;
                }
                if (p.x2 < minimumy) {
                    minimumy = p.x2;
                }
                if (p.x3 < minimumz) {
                    minimumz = p.x3;
                }
            }
            ++i;
        }
        return new CoordinateBox3D(minimumx, maximumx, minimumy, maximumy, minimumz, maximumz);
    }

    public static CoordinateRect2D getLimits2D(Vector points) {
        double maximumx = Double.NEGATIVE_INFINITY;
        double maximumy = Double.NEGATIVE_INFINITY;
        double minimumx = Double.POSITIVE_INFINITY;
        double minimumy = Double.POSITIVE_INFINITY;
        int i = 0;
        while (i < points.size()) {
            Punkt2D p = (Punkt2D)points.elementAt(i);
            if (p != null) {
                if (p.x > maximumx) {
                    maximumx = p.x;
                }
                if (p.y > maximumy) {
                    maximumy = p.y;
                }
                if (p.x < minimumx) {
                    minimumx = p.x;
                }
                if (p.y < minimumy) {
                    minimumy = p.y;
                }
            }
            ++i;
        }
        return new CoordinateRect2D(minimumx, maximumx, minimumy, maximumy);
    }
}

