/*
 * Decompiled with CFR 0.152.
 */
package uibk.mtk.draw3d.objects.surfaceext;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import uibk.mtk.draw3d.base.MathPanel3D;
import uibk.mtk.draw3d.base.Rasterable3D;
import uibk.mtk.draw3d.objects.surface3d.Triangle;
import uibk.mtk.draw3d.objects.surface3d.Vertex3D;
import uibk.mtk.draw3d.objects.surfaceext.ArrowZ3D;
import uibk.mtk.draw3d.objects.surfaceext.Messages;
import uibk.mtk.draw3d.rasterizer.Rasterizer;
import uibk.mtk.geom.CoordinateBox3D;
import uibk.mtk.geom.Punkt2D;
import uibk.mtk.geom.Punkt3D;
import uibk.mtk.geom.Vector2D;
import uibk.mtk.geom.Vector3D;
import uibk.mtk.lang.PrepaintComputable;
import uibk.mtk.math.functions.Function2D;
import uibk.mtk.util.Grid2D;

public class PartialDerivates3D
extends Rasterable3D
implements PrepaintComputable {
    public static final int DIRECTIONALDERIVATE = 0;
    public static final int PARTIALALDERIVATES = 1;
    public static final int TANGENTPLANE = 2;
    int mode = 1;
    private static final int NX = 8;
    private static final int NY = 8;
    Triangle[] triangles = new Triangle[98];
    Vertex3D[] vertices;
    ArrowZ3D arrowx = new ArrowZ3D();
    ArrowZ3D arrowy = new ArrowZ3D();
    ArrowZ3D arrowdir = new ArrowZ3D();
    Function2D f;
    Punkt2D base;
    private static final Vector2D DIRX = new Vector2D(1.0, 0.0);
    private static final Vector2D DIRY = new Vector2D(0.0, 1.0);
    private static final Color COLORPLANE = new Color(200, 200, 200);
    private static final Color COLORARROWS = new Color(200, 200, 200);

    public PartialDerivates3D(Function2D f) {
        this.draw = false;
        this.f = f;
    }

    public PartialDerivates3D() {
        this(null);
    }

    public void setFunction(Function2D f) {
        this.f = f;
    }

    @Override
    public void setRasterizer(Rasterizer rasterizer) {
        super.setRasterizer(rasterizer);
        this.arrowx.setRasterizer(rasterizer);
        this.arrowy.setRasterizer(rasterizer);
        this.arrowdir.setRasterizer(rasterizer);
    }

    @Override
    public void setMathPanel3D(MathPanel3D panel3d) {
        super.setMathPanel3D(panel3d);
        this.arrowx.setMathPanel3D(panel3d);
        this.arrowy.setMathPanel3D(panel3d);
        this.arrowdir.setMathPanel3D(panel3d);
    }

    @Override
    public void draw(BufferedImage framebuffer, Graphics2D g2) {
        if (!this.draw) {
            return;
        }
        if (this.mode == 0) {
            this.arrowdir.draw(framebuffer, g2);
        }
        if (this.mode == 1) {
            this.arrowx.draw(framebuffer, g2);
            this.arrowy.draw(framebuffer, g2);
        }
        if (this.mode == 2) {
            this.drawTangentPlane();
        }
    }

    public void compute(Punkt2D p, Vector2D dir) throws Exception {
        this.base = p;
        if (this.mode == 0) {
            this.setupArrow(this.arrowdir, p, dir);
        }
        if (this.mode == 1) {
            this.setupArrow(this.arrowx, p, DIRX);
            this.setupArrow(this.arrowy, p, DIRY);
        }
        if (this.mode == 2) {
            this.computeTangentPlane();
        }
        this.draw = true;
    }

    public void setMode(int mode) {
        this.mode = mode;
    }

    public int getMode() {
        return this.mode;
    }

    void setupArrow(ArrowZ3D arrow, Punkt2D p, Vector2D direction) throws Exception {
        Punkt3D a = null;
        Vector3D vx = null;
        try {
            a = new Punkt3D(p.x, p.y, this.f.getValue(p.x, p.y));
            vx = this.getDerivationVector(p, direction);
        }
        catch (Exception e1) {
            this.draw = false;
            throw new Exception(Messages.getString("PartialDerivates3D.0"));
        }
        double length = this.panel.getScene3D().getBoundingBox().getXRange() / 2.0;
        vx.normalize();
        vx.scaleself(length);
        arrow.setBase(a);
        arrow.setHead(a.add(vx));
        arrow.setColor(COLORARROWS);
    }

    public Vector3D getDerivationVector(Punkt2D a, Vector2D v) throws Exception {
        Punkt2D vn = v.scale(1.0 / v.norm());
        double d = this.f.getDerivate(a, new Vector2D(vn.x, vn.y));
        return new Vector3D(vn.x, vn.y, d);
    }

    void computeTangentPlane() throws Exception {
        Punkt2D[][] gridpoints;
        double temp;
        Punkt3D a = new Punkt3D(this.base.x, this.base.y, this.f.getValue(this.base.x, this.base.y));
        Vector3D vx = null;
        Vector3D vy = null;
        try {
            vx = this.getDerivationVector(new Punkt2D(this.base.x, this.base.y), new Vector2D(1.0, 0.0));
            vy = this.getDerivationVector(new Punkt2D(this.base.x, this.base.y), new Vector2D(0.0, 1.0));
        }
        catch (Exception e1) {
            this.draw = false;
            throw new Exception(Messages.getString("PartialDerivates3D.1"));
        }
        Vector3D n = vx.crossProd(vy);
        CoordinateBox3D box = this.panel.getScene3D().getBoundingBox();
        double length = Math.min(Math.min(box.getXRange(), box.getYRange()), box.getZRange()) * 1.0 / 3.0;
        vx.normalize();
        vx.scaleself(length);
        vy.normalize();
        vy.scaleself(length);
        double xmin = a.add((Punkt3D)vx).x1;
        double xmax = a.sub((Punkt3D)vx).x1;
        double ymin = a.add((Punkt3D)vy).x2;
        double ymax = a.sub((Punkt3D)vy).x2;
        if (xmin > xmax) {
            temp = xmax;
            xmax = xmin;
            xmin = temp;
        }
        if (ymin > ymax) {
            temp = ymax;
            ymax = ymin;
            ymin = temp;
        }
        if ((gridpoints = Grid2D.createGrid2D(xmin, xmax, ymin, ymax, 8, 8)) == null) {
            this.draw = false;
            throw new Exception(Messages.getString("PartialDerivates3D.2"));
        }
        double d = n.x1 * a.x1 + n.x2 * a.x2 + n.x3 * a.x3;
        int c = 0;
        double z = 0.0;
        int i = 0;
        while (i < 8) {
            int j = 0;
            while (j < 8) {
                Punkt2D point = gridpoints[i][j];
                z = n.x3 != 0.0 ? (d - point.x * n.x1 - point.y * n.x2) / n.x3 : a.x3;
                this.vertices[c] = new Vertex3D(point.x, point.y, z);
                ++c;
                ++j;
            }
            ++i;
        }
        c = 0;
        int k = 0;
        while (k < 7) {
            int i2 = 0;
            while (i2 < 7) {
                int p1 = k * 8 + i2;
                int p2 = (k + 1) * 8 + i2;
                int p3 = (k + 1) * 8 + i2 + 1;
                int p4 = k * 8 + i2 + 1;
                this.triangles[c] = new Triangle(this.vertices[p1], this.vertices[p2], this.vertices[p4]);
                this.triangles[++c] = new Triangle(this.vertices[p3], this.vertices[p4], this.vertices[p2]);
                ++c;
                ++i2;
            }
            ++k;
        }
    }

    void drawTangentPlane() {
        if (this.triangles[0] == null) {
            return;
        }
        this.rasterizer.enableZBuffer(true);
        this.rasterizer.setColor(COLORPLANE);
        int w = this.rasterizer.getLineWidth();
        int i = 0;
        while (i < this.triangles.length) {
            this.rasterizer.drawline(this.triangles[i].p1, this.triangles[i].p2);
            this.rasterizer.drawline(this.triangles[i].p1, this.triangles[i].p3);
            ++i;
        }
        this.rasterizer.setLineWidth(w);
    }

    @Override
    public void prepaintcompute() {
        if (this.mode == 2) {
            int i;
            if (this.vertices == null) {
                this.vertices = new Vertex3D[64];
                i = 0;
                while (i < 64) {
                    this.vertices[i] = new Vertex3D();
                    ++i;
                }
            }
            i = 0;
            while (i < this.vertices.length) {
                this.vertices[i].dc = this.scene3d.mcToDevice(this.vertices[i].mc);
                this.vertices[i].wc = this.scene3d.getWC(this.vertices[i].mc);
                this.vertices[i].distance = this.scene3d.calcdepth(this.vertices[i].wc);
                ++i;
            }
        }
    }
}

