/*
 * Decompiled with CFR 0.152.
 */
package uibk.mtk.draw3d.objects.surfaceext;

import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import uibk.mtk.draw3d.base.Rasterable3D;
import uibk.mtk.geom.Punkt2D;
import uibk.mtk.geom.Punkt3D;
import uibk.mtk.geom.Vector2D;

class ArrowZ3D
extends Rasterable3D {
    protected Punkt3D base = new Punkt3D();
    protected Punkt3D head = new Punkt3D();
    private static final int LENGTHARROWHEAD = 10;
    private static final int OFFSETWINGS = 5;
    private static final int LINEWIDTH = 2;

    public ArrowZ3D(Punkt3D base, Punkt3D head) {
        base.setLocation(base);
        head.setLocation(head);
    }

    public ArrowZ3D() {
        this.head.x1 = 1.0;
    }

    public Punkt3D getHead() {
        return this.head;
    }

    public Punkt3D getBase() {
        return this.base;
    }

    public void setBase(Punkt3D p) {
        this.base.setLocation(p);
    }

    public void setHead(Punkt3D p) {
        this.head.setLocation(p);
    }

    @Override
    public void draw(BufferedImage framebuffer, Graphics2D g2) {
        this.rasterizer.enableZBuffer(true);
        double depthbase = this.scene3d.calcdepth(this.scene3d.getWC(this.base));
        double depthhead = this.scene3d.calcdepth(this.scene3d.getWC(this.head));
        Punkt2D pbase = this.scene3d.project(this.base);
        Punkt2D phead = this.scene3d.project(this.head);
        if (pbase.equals(phead) || !pbase.isReal() || !phead.isReal()) {
            return;
        }
        Vector2D dir = pbase.sub(phead).toVector();
        dir.normalize();
        Vector2D n = dir.normaldir();
        dir.scaleself(10.0);
        n.scaleself(5.0);
        Punkt2D s = phead.add(dir);
        Punkt2D left = s.add(n);
        Punkt2D right = s.add(Punkt2D.inverse(n));
        int oldwidth = this.rasterizer.getLineWidth();
        this.rasterizer.setLineWidth(2);
        this.rasterizer.setColor(this.color);
        this.rasterizer.drawline((int)pbase.x, (int)pbase.y, (int)phead.x, (int)phead.y, depthbase, depthhead);
        this.rasterizer.drawline((int)left.x, (int)left.y, (int)phead.x, (int)phead.y, depthbase, depthhead);
        this.rasterizer.drawline((int)right.x, (int)right.y, (int)phead.x, (int)phead.y, depthbase, depthhead);
        this.rasterizer.setLineWidth(oldwidth);
    }
}

