/*
 * Decompiled with CFR 0.152.
 */
package uibk.mtk.draw3d.objects.surface3d;

import java.util.Vector;
import uibk.mtk.draw3d.objects.surface3d.Triangle;
import uibk.mtk.draw3d.objects.surface3d.Vertex3D;
import uibk.mtk.geom.CoordinateBox3D;

public class Mesh {
    private Vector triangles;
    private Vector vertices;

    public Mesh(Vector triangles, Vector vertices) {
        this.triangles = triangles;
        this.vertices = vertices;
    }

    public CoordinateBox3D getBoundingBox() {
        if (this.triangles == null || this.triangles.size() == 0) {
            return null;
        }
        double xmin = Double.POSITIVE_INFINITY;
        double xmax = Double.NEGATIVE_INFINITY;
        double ymin = Double.POSITIVE_INFINITY;
        double ymax = Double.NEGATIVE_INFINITY;
        double zmin = Double.POSITIVE_INFINITY;
        double zmax = Double.NEGATIVE_INFINITY;
        int i = 0;
        while (i < this.triangles.size()) {
            Triangle t = (Triangle)this.triangles.elementAt(i);
            Vertex3D[] vert = new Vertex3D[]{t.p1, t.p2, t.p3};
            int j = 0;
            while (j < 3) {
                Vertex3D v = vert[j];
                if (v.mc.x1 < xmin) {
                    xmin = v.mc.x1;
                }
                if (v.mc.x1 > xmax) {
                    xmax = v.mc.x1;
                }
                if (v.mc.x2 < ymin) {
                    ymin = v.mc.x2;
                }
                if (v.mc.x2 > ymax) {
                    ymax = v.mc.x2;
                }
                if (v.mc.x3 < zmin) {
                    zmin = v.mc.x3;
                }
                if (v.mc.x3 > zmax) {
                    zmax = v.mc.x3;
                }
                ++j;
            }
            ++i;
        }
        return new CoordinateBox3D(xmin, xmax, ymin, ymax, zmin, zmax);
    }

    public Vector getTriangles() {
        return this.triangles;
    }

    public Vector getVertices() {
        return this.vertices;
    }
}

