/*
 * Decompiled with CFR 0.152.
 */
package uibk.mtk.draw3d.objects.surface3d;

import java.util.Vector;
import uibk.mtk.draw3d.objects.surface3d.Mesh;
import uibk.mtk.draw3d.objects.surface3d.Messages;
import uibk.mtk.draw3d.objects.surface3d.Triangle;
import uibk.mtk.draw3d.objects.surface3d.Vertex3D;
import uibk.mtk.geom.CoordinateRect2D;
import uibk.mtk.geom.Punkt2D;
import uibk.mtk.lang.ComputationException;
import uibk.mtk.math.SingularityChecker;
import uibk.mtk.math.functions.Function1D;
import uibk.mtk.math.functions.Function2D;
import uibk.mtk.util.Grid2D;

public class Function2DMeshBuilder {
    Function2D f;
    private double zmin;
    private double zmax;
    private Vector mesh_vertices;
    private boolean[] added;
    Vertex3D[] vertices;
    double dirx;
    double diry;
    double p1x;
    double p1y;
    Function1D g = new Function1D(){

        @Override
        public double getValue(double t) {
            return Function2DMeshBuilder.this.f.getValue(Function2DMeshBuilder.this.p1x + Function2DMeshBuilder.this.dirx * t, Function2DMeshBuilder.this.p1y + Function2DMeshBuilder.this.diry * t);
        }

        @Override
        public double getDerivation(double x) throws Exception {
            throw new RuntimeException("");
        }
    };
    SingularityChecker singfinder;

    public Function2DMeshBuilder(Function2D f) {
        this.f = f;
    }

    private Mesh simpleTriangulization(Vertex3D[] vertices, int nx, int ny) throws Exception {
        Vector<Triangle> triangles = new Vector<Triangle>((nx - 1) * (ny - 1) * 2);
        Vector<Vertex3D> vert = new Vector<Vertex3D>(nx * ny);
        int i = 0;
        while (i < vertices.length) {
            if (!vertices[i].mc.isReal()) {
                throw new ComputationException(Messages.getString("Function2DMeshBuilder.1"));
            }
            ++i;
        }
        int k = 0;
        while (k < nx - 1) {
            int i2 = 0;
            while (i2 < ny - 1) {
                int p1 = k * nx + i2;
                int p2 = (k + 1) * nx + i2;
                int p3 = (k + 1) * nx + i2 + 1;
                int p4 = k * nx + i2 + 1;
                triangles.add(new Triangle(vertices[p1], vertices[p2], vertices[p4]));
                triangles.add(new Triangle(vertices[p3], vertices[p4], vertices[p2]));
                ++i2;
            }
            ++k;
        }
        if (triangles.size() == 0) {
            throw new ComputationException(Messages.getString("Function2DMeshBuilder.2"));
        }
        i = 0;
        while (i < vertices.length) {
            vert.add(vertices[i]);
            ++i;
        }
        return new Mesh(triangles, vert);
    }

    private Mesh advancedTriangulization(Vertex3D[] vertices, int nx, int ny) throws Exception {
        Vector<Triangle> triangles = new Vector<Triangle>((nx - 1) * (ny - 1) * 2);
        this.mesh_vertices = new Vector(nx * ny);
        this.singfinder = new SingularityChecker(this.zmin, this.zmax);
        Punkt2D a1 = new Punkt2D();
        Punkt2D a2 = new Punkt2D();
        Punkt2D a3 = new Punkt2D();
        Punkt2D a4 = new Punkt2D();
        int k = 0;
        while (k < nx - 1) {
            int i = 0;
            while (i < ny - 1) {
                int p1 = k * nx + i;
                int p2 = (k + 1) * nx + i;
                int p3 = (k + 1) * nx + i + 1;
                int p4 = k * nx + i + 1;
                a1.setLocation(vertices[p1].mc.x1, vertices[p1].mc.x2);
                a2.setLocation(vertices[p2].mc.x1, vertices[p2].mc.x2);
                a3.setLocation(vertices[p3].mc.x1, vertices[p3].mc.x2);
                a4.setLocation(vertices[p4].mc.x1, vertices[p4].mc.x2);
                if (!(this.hasSingularity(a1, a2) || this.hasSingularity(a2, a4) || this.hasSingularity(a4, a1))) {
                    this.add(p1);
                    this.add(p2);
                    this.add(p4);
                    triangles.add(new Triangle(vertices[p1], vertices[p2], vertices[p4]));
                }
                if (!(this.hasSingularity(a3, a2) || this.hasSingularity(a2, a4) || this.hasSingularity(a4, a3))) {
                    this.add(p3);
                    this.add(p2);
                    this.add(p4);
                    triangles.add(new Triangle(vertices[p3], vertices[p4], vertices[p2]));
                }
                ++i;
            }
            ++k;
        }
        if (triangles.size() == 0) {
            throw new Exception(Messages.getString("Function2DMeshBuilder.3"));
        }
        return new Mesh(triangles, this.mesh_vertices);
    }

    private void add(int i) {
        if (!this.added[i]) {
            this.mesh_vertices.add(this.vertices[i]);
            this.added[i] = true;
        }
    }

    public Mesh build(CoordinateRect2D rect, int nx, int ny, boolean checksing) throws Exception {
        this.vertices = new Vertex3D[nx * ny];
        this.added = new boolean[nx * ny];
        Punkt2D[][] grid = Grid2D.createGrid2D(rect.xmin, rect.xmax, rect.ymin, rect.ymax, nx, ny);
        double z = 0.0;
        this.zmin = Double.POSITIVE_INFINITY;
        this.zmax = Double.NEGATIVE_INFINITY;
        int c = 0;
        int i = 0;
        while (i < nx) {
            int j = 0;
            while (j < ny) {
                z = this.f.getValue(grid[i][j].x, grid[i][j].y);
                if (!Double.isInfinite(z) && !Double.isNaN(z)) {
                    if (z < this.zmin) {
                        this.zmin = z;
                    }
                    if (z > this.zmax) {
                        this.zmax = z;
                    }
                }
                this.vertices[c] = new Vertex3D(grid[i][j].x, grid[i][j].y, z);
                ++c;
                ++j;
            }
            ++i;
        }
        if (checksing) {
            return this.advancedTriangulization(this.vertices, nx, ny);
        }
        return this.simpleTriangulization(this.vertices, nx, ny);
    }

    private boolean hasSingularity(Punkt2D p1, Punkt2D p2) {
        this.dirx = p2.x - p1.x;
        this.diry = p2.y - p1.y;
        this.p1x = p1.x;
        this.p1y = p1.y;
        return this.singfinder.hasSingularity(this.g, 0.0, 1.0);
    }
}

